/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.parameter;

import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import java.util.ArrayList;
import java.util.List;

public class VisMultiVariableParameter
extends VisVariableParameter {
    public static final String type = "multivariation";
    private int[] _orderIndexes = null;
    private int _currentOrderIndex;

    public VisMultiVariableParameter(String name) {
        super(name);
        this._currentOrderIndex = 0;
    }

    public VisMultiVariableParameter(VisMultiVariableParameter parameter) throws VisCoachParameterCreationException {
        super(parameter);
        if (parameter._orderIndexes != null) {
            this._orderIndexes = (int[])parameter._orderIndexes.clone();
        }
        this._currentOrderIndex = parameter._currentOrderIndex;
    }

    public VisMultiVariableParameter(VisMultiVariableParameter parameter, boolean shallow) throws VisCoachParameterCreationException {
        super(parameter, shallow);
        if (parameter._orderIndexes != null) {
            this._orderIndexes = (int[])parameter._orderIndexes.clone();
        }
        this._currentOrderIndex = parameter._currentOrderIndex;
    }

    @Override
    public void addVariation(VisParameter parameter) {
        this.addChildParameter(parameter);
    }

    public List<VisParameter> getCurrentVariations() {
        ArrayList<VisParameter> activeVariations = new ArrayList<VisParameter>();
        if (this._orderIndexes != null) {
            for (int i = 0; i < this._currentOrderIndex; ++i) {
                activeVariations.add((VisParameter)this.childList.get(this._orderIndexes[i]));
            }
        }
        return activeVariations;
    }

    public void setVariationActive(int index, boolean active) {
        if (index < this.getNumVariations()) {
            this.growOrderIndexesAsNecessary();
            this._orderIndexes[this._currentOrderIndex++] = index;
        }
    }

    public void setAllVariationsInnactive() {
        this._orderIndexes = new int[this.getNumVariations()];
        this._currentOrderIndex = 0;
    }

    private void growOrderIndexesAsNecessary() {
        if (this._orderIndexes == null) {
            this.setAllVariationsInnactive();
        } else if (this._orderIndexes.length < this.getNumVariations()) {
            int[] newOrderIndexes = new int[this.getNumVariations()];
            for (int i = 0; i < this._orderIndexes.length; ++i) {
                newOrderIndexes[i] = this._orderIndexes[i];
            }
            this._orderIndexes = newOrderIndexes;
        }
    }

    @Override
    public String serializeVariationChoices() {
        String serializeOutput = "";
        for (int i = 0; i < this._currentOrderIndex; ++i) {
            if (i != 0) {
                serializeOutput = serializeOutput + "-";
            }
            serializeOutput = serializeOutput + this._orderIndexes[i];
        }
        serializeOutput = serializeOutput + ".";
        return serializeOutput;
    }

    @Override
    public int deserializeVariationChoices(String key, int index) {
        this.setAllVariationsInnactive();
        int currentIndex = index;
        int currentVariationIndex = 0;
        if (key.charAt(currentIndex) >= '0' && key.charAt(currentIndex) <= '9') {
            while (key.charAt(currentIndex) != '.') {
                if (key.charAt(currentIndex) == '-') {
                    ++currentIndex;
                }
                int numericEndIndex = currentIndex + 1;
                while (key.charAt(numericEndIndex) >= '0' && key.charAt(numericEndIndex) <= '9') {
                    ++numericEndIndex;
                }
                currentVariationIndex = Integer.parseInt(key.substring(currentIndex, numericEndIndex));
                currentIndex = numericEndIndex;
                this.setVariationActive(currentVariationIndex, true);
            }
            ++currentIndex;
        }
        return currentIndex;
    }
}

