/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.parameter;

import com.ibm.aurora.visCoach.core.parameter.ParameterGraphCopier;
import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VisParentParameter
extends VisParameter {
    public static final String type = "parent";
    protected Map<String, VisParameter> children = null;
    protected List<VisParameter> childList = null;

    public VisParentParameter(String name) {
        super(name);
    }

    public VisParentParameter(VisParentParameter parameter) throws VisCoachParameterCreationException {
        super(parameter);
        if (parameter.childList != null) {
            this.copyChildrenFromParameter(parameter);
        }
    }

    public VisParentParameter(VisParentParameter parameter, boolean shallow) throws VisCoachParameterCreationException {
        super(parameter);
        if (!shallow && parameter.childList != null) {
            this.copyChildrenFromParameter(parameter);
        }
    }

    private void copyChildrenFromParameter(VisParentParameter parameter) throws VisCoachParameterCreationException {
        for (VisParameter param : parameter.childList) {
            this.addChildParameter(VisParentParameter.getCopyOfParameter(param));
        }
    }

    public void addChildParameters(List<VisParameter> params) {
        for (VisParameter param : params) {
            this.addChildParameter(param);
        }
    }

    public void addChildParameterCopies(List<VisParameter> params) throws VisCoachParameterCreationException {
        for (VisParameter param : params) {
            this.addChildParameterCopy(param);
        }
    }

    public void addChildParameter(VisParameter param) {
        if (this.children == null) {
            this.children = new HashMap<String, VisParameter>();
            this.childList = new ArrayList<VisParameter>();
        }
        if (!this.children.containsKey(param.getName())) {
            this.children.put(param.getName(), param);
        }
        this.childList.add(param);
    }

    public void addChildParameterCopy(VisParameter param) throws VisCoachParameterCreationException {
        this.addChildParameter(VisParentParameter.getCopyOfParameter(param));
    }

    public VisParameter getChildParameter(String name) {
        if (this.children != null) {
            return this.children.get(name);
        }
        return null;
    }

    public List<VisParameter> getParameters() {
        return this.childList;
    }

    public void clearChildParameters() {
        this.children = null;
        this.childList = null;
    }

    public int getNumChildren() {
        if (this.childList != null) {
            return this.childList.size();
        }
        return 0;
    }

    public boolean hasChildren() {
        return this.getNumChildren() > 0;
    }

    public static VisParameter getCopyOfParameter(VisParameter parameter) throws VisCoachParameterCreationException {
        if (VisParentParameter.class.isInstance(parameter)) {
            return VisParentParameter.getCopyOfParameter(parameter, false);
        }
        return VisParameter.getCopyOfParameter(parameter);
    }

    public static VisParentParameter getCopyOfParameter(VisParameter parameter, boolean shallow) throws VisCoachParameterCreationException {
        if (!shallow && VisParentParameter.class.isInstance(parameter)) {
            return ParameterGraphCopier.deepCopyParameter((VisParentParameter)parameter);
        }
        VisParentParameter newParameter = null;
        try {
            newParameter = (VisParentParameter)parameter.getClass().getConstructor(parameter.getClass(), Boolean.TYPE).newInstance(parameter, shallow);
        }
        catch (IllegalArgumentException e) {
            throw new VisCoachParameterCreationException(e.getMessage(), parameter.getName());
        }
        catch (SecurityException e) {
            throw new VisCoachParameterCreationException(e.getMessage(), parameter.getName());
        }
        catch (InstantiationException e) {
            throw new VisCoachParameterCreationException(e.getMessage(), parameter.getName());
        }
        catch (IllegalAccessException e) {
            throw new VisCoachParameterCreationException(e.getMessage(), parameter.getName());
        }
        catch (InvocationTargetException e) {
            throw new VisCoachParameterCreationException(e.getMessage(), parameter.getName());
        }
        catch (NoSuchMethodException e) {
            throw new VisCoachParameterCreationException(e.getMessage(), parameter.getName());
        }
        return newParameter;
    }
}

