/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.parameter;

import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolutionGroupMember;

public class VisVariableParameter
extends VisParentParameter
implements IResolutionGroupMember {
    public static final String type = "variation";
    private int _currentVariation = -1;
    private boolean _isTransient = false;
    private String _resolutionGroupTag = null;
    private boolean _enumerateVariations = true;

    public VisVariableParameter(String name) {
        super(name);
    }

    public VisVariableParameter(VisVariableParameter parameter) throws VisCoachParameterCreationException {
        super(parameter);
        this._currentVariation = parameter._currentVariation;
        this._resolutionGroupTag = parameter._resolutionGroupTag;
        this._enumerateVariations = parameter._enumerateVariations;
    }

    public VisVariableParameter(VisVariableParameter parameter, boolean shallow) throws VisCoachParameterCreationException {
        super(parameter, shallow);
        this._currentVariation = parameter._currentVariation;
        this._resolutionGroupTag = parameter._resolutionGroupTag;
        this._enumerateVariations = parameter._enumerateVariations;
    }

    public int getNumVariations() {
        return this.getNumChildren();
    }

    public VisParameter getCurrentVariation() {
        return (VisParameter)this.childList.get(this._currentVariation);
    }

    public int getcurrentVariationIndex() {
        return this._currentVariation;
    }

    public void setcurrentVariation(int variation) {
        this._currentVariation = variation;
    }

    public void addVariation(VisParameter parameter) {
        this.addChildParameter(parameter);
    }

    public String serializeVariationChoices() {
        return "" + this._currentVariation;
    }

    public int deserializeVariationChoices(String key, int index) {
        int currentIndex = index;
        int keyLength = key.length();
        if (key.charAt(currentIndex) >= '0' && key.charAt(currentIndex) <= '9') {
            int numericEndIndex;
            for (numericEndIndex = currentIndex + 1; numericEndIndex < keyLength && key.charAt(numericEndIndex) >= '0' && key.charAt(numericEndIndex) <= '9'; ++numericEndIndex) {
            }
            this._currentVariation = Integer.parseInt(key.substring(currentIndex, numericEndIndex));
            currentIndex = numericEndIndex;
        }
        return currentIndex;
    }

    @Override
    public void setToResolutionGroup(IResolutionGroupMember resolutionGroupParameter) {
        this._resolutionGroupTag = resolutionGroupParameter.getResolutionGroupName();
    }

    @Override
    public String getResolutionGroupName() {
        return this._resolutionGroupTag;
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setTransient(boolean isTransient) {
        this._isTransient = isTransient;
    }

    public void setEnumerateAllVariationsActive(boolean allow) {
        this._enumerateVariations = allow;
    }

    public boolean enumerateAllVariationsActive() {
        return this._enumerateVariations;
    }
}

