/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.parameter.parameterFactory;

import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.IIndividualParameterFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ParameterFactory {
    private final Map<String, IIndividualParameterFactory> _individualParameterFactories = new HashMap<String, IIndividualParameterFactory>();

    public void checkAndRegisterIndividualParameterFactory(String type, IIndividualParameterFactory individualParameterFactory) {
        if (null == individualParameterFactory) {
            throw new IllegalArgumentException("individualParameterFactory cannot be null");
        }
        IIndividualParameterFactory existingIndividualParameterFactory = this._individualParameterFactories.put(type, individualParameterFactory);
        if (null != existingIndividualParameterFactory) {
            this._individualParameterFactories.put(type, existingIndividualParameterFactory);
            throw new IllegalArgumentException(type + "already registered");
        }
    }

    public VisParameter createParameter(String type) throws VisCoachParameterCreationException {
        return this.createParameter(type, "anonymous", Collections.<String, String>emptyMap());
    }

    public VisParameter createParameter(String type, String name) throws VisCoachParameterCreationException {
        return this.createParameter(type, name, Collections.<String, String>emptyMap());
    }

    public VisParameter createParameter(String type, String name, Map<String, String> attributes) throws VisCoachParameterCreationException {
        VisParameter visParam = null;
        IIndividualParameterFactory individualParameterFactory = this._individualParameterFactories.get(type);
        if (null == individualParameterFactory) {
            throw new VisCoachParameterCreationException("Could not create parameter of type " + type, name);
        }
        visParam = individualParameterFactory.createVisParameter(name, attributes);
        return visParam;
    }
}

