/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.rules;

import com.ibm.aurora.visCoach.core.rules.VisRule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RulesManager<VR extends VisRule> {
    private Map<String, Map<String, String>> _templatePropertiesList = null;
    private Map<String, List<VR>> _templateRulesList = null;
    private Map<String, VR> _ruleList = null;
    protected final Map<String, Map<String, String>> _templateGroupAttributes = new HashMap<String, Map<String, String>>();

    public boolean hasTemplate(String templateId) {
        return this._templateRulesList != null && this._templateRulesList.containsKey(templateId);
    }

    public Set<String> getTemplateIds() {
        if (this._templateRulesList != null) {
            return this._templateRulesList.keySet();
        }
        return null;
    }

    public List<VR> getTemplateRules(String templateId) {
        List<VR> templateRules;
        List<VR> ruleList = null;
        String baseTemplate = this.getTemplateProperty(templateId, "extends");
        if (baseTemplate != null) {
            ruleList = this.getTemplateRules(baseTemplate);
        }
        if (this._templateRulesList != null && (templateRules = this._templateRulesList.get(templateId)) != null) {
            if (ruleList == null) {
                ruleList = new ArrayList<VR>();
            }
            ruleList.addAll(templateRules);
        }
        return ruleList;
    }

    public VR getRule(String id) {
        if (this._ruleList != null) {
            return (VR)((VisRule)this._ruleList.get(id));
        }
        return null;
    }

    public String getTemplateProperty(String id, String propName) {
        Map<String, String> propList;
        if (this._templatePropertiesList != null && (propList = this._templatePropertiesList.get(id)) != null) {
            return propList.get(propName);
        }
        return null;
    }

    public Map<String, String> getTemplateProperties(String id) {
        if (this._templatePropertiesList != null) {
            return this._templatePropertiesList.get(id);
        }
        return null;
    }

    protected void addRule(String id, VR rule) {
        if (this._ruleList == null) {
            this._ruleList = new HashMap<String, VR>();
        }
        this._ruleList.put(id, rule);
    }

    protected void addTemplateProperties(String templateId, Map<String, String> propertyList) {
        if (this._templatePropertiesList == null) {
            this._templatePropertiesList = new HashMap<String, Map<String, String>>();
        }
        this._templatePropertiesList.put(templateId, propertyList);
    }

    protected void addTemplateRulesList(String templateId, List<VR> rulesList) {
        if (this._templateRulesList == null) {
            this._templateRulesList = new HashMap<String, List<VR>>();
        }
        this._templateRulesList.put(templateId, rulesList);
    }

    public Map<String, String> getGroupAttributes(String name) {
        return this._templateGroupAttributes.get(name);
    }
}

