/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.rules.xml;

import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.rules.xml.IVisRuleLoader;
import com.ibm.aurora.visCoach.core.rules.xml.IVisRuleStringExpressionLoader;
import com.ibm.aurora.visCoach.core.rules.xml.IVisRuleXMLExpressionLoader;
import com.ibm.aurora.visCoach.core.rules.xml.VisRuleStringExpressionLoaderUnsupported;
import com.ibm.aurora.visCoach.core.rules.xml.VisRuleXMLExpressionLoaderUnsupported;
import com.ibm.aurora.visCoach.core.utils.xmlHelper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VisRuleXMLLoader<VR extends VisRule>
implements IVisRuleLoader<VR> {
    final IVisRuleStringExpressionLoader<VR> visRuleStringExpressionLoader;
    final IVisRuleXMLExpressionLoader<VR> visRuleXMLExpressionLoader;

    public VisRuleXMLLoader(IVisRuleStringExpressionLoader<VR> visRuleStringExpressionLoader, IVisRuleXMLExpressionLoader<VR> visRuleXMLExpressionLoader) {
        this.visRuleStringExpressionLoader = visRuleStringExpressionLoader;
        this.visRuleXMLExpressionLoader = visRuleXMLExpressionLoader;
    }

    public VisRuleXMLLoader(IVisRuleStringExpressionLoader<VR> visRuleStringExpressionLoader) {
        this(visRuleStringExpressionLoader, new VisRuleXMLExpressionLoaderUnsupported());
    }

    public VisRuleXMLLoader(IVisRuleXMLExpressionLoader<VR> visRuleXMLExpressionLoader) {
        this(new VisRuleStringExpressionLoaderUnsupported(), visRuleXMLExpressionLoader);
    }

    public VisRuleXMLLoader() {
        this(new VisRuleStringExpressionLoaderUnsupported(), new VisRuleXMLExpressionLoaderUnsupported());
    }

    @Override
    public void loadRuleFromNode(VR visRule, Element element) throws Exception {
        String sWeight;
        String sDescription;
        String isRequired = xmlHelper.getAttribute(element, "required");
        if (isRequired != null) {
            ((VisRule)visRule).setRequired(Boolean.valueOf(isRequired));
        }
        if ((sDescription = xmlHelper.getAttribute(element, "description")) != null) {
            ((VisRule)visRule).setDescription(sDescription);
        }
        if ((sWeight = xmlHelper.getAttribute(element, "weight")) != null) {
            ((VisRule)visRule).setWeight(Float.valueOf(sWeight).floatValue());
        }
        this.loadRuleExpression(visRule, element);
        this.loadScoreExpression(visRule, element);
        this.loadNodeIdentifierExpression(visRule, element);
    }

    protected void loadRuleExpression(VR visRule, Element element) throws Exception {
        String expression = xmlHelper.getAttribute(element, "expression");
        NodeList nodeList = element.getElementsByTagName("expression");
        int nodeListLength = nodeList.getLength();
        if (expression != null && nodeListLength > 0) {
            throw new UnsupportedOperationException("Only one of an expression attribute or child element can be specified");
        }
        if (expression != null) {
            this.visRuleStringExpressionLoader.setRuleExpression(visRule, expression);
        }
        if (nodeListLength > 1) {
            throw new UnsupportedOperationException("length (" + nodeListLength + ") > 1");
        }
        if (1 == nodeListLength) {
            Element expressionElement = (Element)nodeList.item(0);
            this.visRuleXMLExpressionLoader.setRuleExpression(visRule, expressionElement);
        }
    }

    protected void loadNodeIdentifierExpression(VR visRule, Element element) throws Exception {
        String expression = xmlHelper.getAttribute(element, "nodeIdentifier");
        NodeList nodeList = element.getElementsByTagName("nodeIdentifier");
        int nodeListLength = nodeList.getLength();
        if (expression != null && nodeListLength > 0) {
            throw new UnsupportedOperationException("Only one of an score attribute or child element can be specified");
        }
        if (expression != null) {
            this.visRuleStringExpressionLoader.setNodeIdentifierExpression(visRule, expression);
        }
        if (nodeListLength > 1) {
            throw new UnsupportedOperationException("length (" + nodeListLength + ") > 1");
        }
        if (1 == nodeListLength) {
            Element expressionElement = (Element)nodeList.item(0);
            this.visRuleXMLExpressionLoader.setNodeIdentifierExpression(visRule, expressionElement);
        }
    }

    protected void loadScoreExpression(VR visRule, Element element) throws Exception {
        String expression = xmlHelper.getAttribute(element, "score");
        NodeList nodeList = element.getElementsByTagName("score");
        int nodeListLength = nodeList.getLength();
        if (expression != null && nodeListLength > 0) {
            throw new UnsupportedOperationException("Only one of an score attribute or child element can be specified");
        }
        if (expression != null) {
            this.visRuleStringExpressionLoader.setScoreExpression(visRule, expression);
        }
        if (nodeListLength > 1) {
            throw new UnsupportedOperationException("length (" + nodeListLength + ") > 1");
        }
        if (1 == nodeListLength) {
            Element expressionElement = (Element)nodeList.item(0);
            this.visRuleXMLExpressionLoader.setScoreExpression(visRule, expressionElement);
        }
    }
}

