/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.rules.xml;

import com.ibm.aurora.visCoach.core.rules.IVisRuleFactory;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.rules.xml.IVisRuleLoader;
import com.ibm.aurora.visCoach.core.utils.xmlHelper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRulesManager<VR extends VisRule>
extends RulesManager<VR> {
    final IVisRuleFactory<VR> visRuleFactory;

    public XMLRulesManager(IVisRuleFactory<VR> visRuleFactory) {
        this.visRuleFactory = visRuleFactory;
    }

    public void load(String[] rulesFiles, String[] rulesMappingFiles, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        if (rulesFiles != null) {
            for (String rulesFile : rulesFiles) {
                this.loadRulesFile(rulesFile, visRuleLoader);
            }
        }
        if (rulesMappingFiles != null) {
            for (String rulesMappingFile : rulesMappingFiles) {
                this.loadRulesMappingFile(rulesMappingFile, visRuleLoader);
            }
        }
    }

    public void load(String rulesfile, String rulesMappingFile, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        String[] rulesMappingFiles = new String[]{rulesMappingFile};
        String[] rulesFiles = new String[]{rulesfile};
        this.load(rulesFiles, rulesMappingFiles, visRuleLoader);
    }

    public void load(InputStream rulesfileStream, InputStream rulesMappingStream, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        if (rulesfileStream != null) {
            this.loadRulesStream(rulesfileStream, visRuleLoader);
        }
        if (rulesMappingStream != null) {
            this.loadRulesMappingStream(rulesMappingStream, visRuleLoader);
        }
    }

    protected void loadRulesFile(String rulesFile, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        Node rulesRoot = xmlHelper.parseXMLFile(rulesFile);
        this.loadRules(rulesRoot, visRuleLoader);
    }

    protected void loadRulesStream(InputStream rulesStream, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        Node rulesRoot = xmlHelper.parseXMLStream(rulesStream);
        this.loadRules(rulesRoot, visRuleLoader);
    }

    private void loadRules(Node rulesRoot, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        NodeList rules = xmlHelper.resolveNodeListXpath(rulesRoot, "rule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Element rule = (Element)rules.item(i);
            String id = xmlHelper.getAttribute(rule, "id");
            String visRule = this.visRuleFactory.createVisRule(id);
            visRuleLoader.loadRuleFromNode(visRule, rule);
            this.addRule(id, visRule);
        }
    }

    protected void loadRulesMappingFile(String rulesMappingFile, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        Node rulesMappingRoot = xmlHelper.parseXMLFile(rulesMappingFile);
        this.loadRulesMapping(rulesMappingRoot, visRuleLoader);
    }

    protected void loadRulesMappingStream(InputStream rulesMappingStream, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        Node rulesMappingRoot = xmlHelper.parseXMLStream(rulesMappingStream);
        this.loadRulesMapping(rulesMappingRoot, visRuleLoader);
    }

    private void loadRulesMapping(Node rulesMappingRoot, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        NodeList ruleMappingGroups = xmlHelper.resolveNodeListXpath(rulesMappingRoot, "templateGroup");
        if (ruleMappingGroups.getLength() > 0) {
            this.loadTemplateGroup(ruleMappingGroups, visRuleLoader);
        } else {
            NodeList ruleMappingRefs = xmlHelper.resolveNodeListXpath(rulesMappingRoot, "templateRef");
            this.loadTemplateRef(ruleMappingRefs, visRuleLoader);
        }
    }

    protected void loadTemplateRef(NodeList ruleMappingRefs, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        for (int i = 0; i < ruleMappingRefs.getLength(); ++i) {
            Node templateRef = ruleMappingRefs.item(i);
            Map<String, String> attributesMap = xmlHelper.getAttributesFromNode(templateRef);
            String templateId = attributesMap.get("id");
            this.addTemplateRulesList(templateId, this.getXMLTemplateRuleList(templateRef, visRuleLoader));
            this.addTemplateProperties(templateId, attributesMap);
        }
    }

    protected void loadTemplateGroup(NodeList ruleMappingGroups, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        for (int i = 0; i < ruleMappingGroups.getLength(); ++i) {
            Node templateGroup = ruleMappingGroups.item(i);
            Map<String, String> groupAttributesMap = xmlHelper.getAttributesFromNode(templateGroup);
            String groupName = groupAttributesMap.get("name");
            this._templateGroupAttributes.put(groupName, groupAttributesMap);
            List<VR> groupRules = this.getXMLTemplateRuleList(templateGroup, visRuleLoader);
            NodeList templateRefs = templateGroup.getChildNodes();
            for (int j = 0; j < templateRefs.getLength(); ++j) {
                Node templateRef = templateRefs.item(j);
                if (!templateRef.getNodeName().equals("templateRef")) continue;
                Map<String, String> attributesMap = xmlHelper.getAttributesFromNode(templateRef);
                attributesMap.put("group", groupName);
                String templateId = attributesMap.get("id");
                List<VR> templateRules = this.getXMLTemplateRuleList(templateRef, visRuleLoader);
                templateRules.addAll(groupRules);
                this.addTemplateRulesList(templateId, templateRules);
                this.addTemplateProperties(templateId, attributesMap);
            }
        }
    }

    protected List<VR> getXMLTemplateRuleList(Node templateNode, IVisRuleLoader<VR> visRuleLoader) throws Exception {
        NodeList ruleRefNodes = xmlHelper.resolveNodeListXpath(templateNode, "ruleref");
        ArrayList<VR> rules = new ArrayList<VR>();
        for (int i = 0; i < ruleRefNodes.getLength(); ++i) {
            Element ruleRefNode = (Element)ruleRefNodes.item(i);
            String ruleId = xmlHelper.getAttribute(ruleRefNode, "id");
            VR visRule = this.visRuleFactory.createVisRule(this.getRule(ruleId));
            visRuleLoader.loadRuleFromNode(visRule, ruleRefNode);
            rules.add(visRule);
        }
        return rules;
    }
}

