/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.score;

import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.parameter.VisMultiVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScorableParameter;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.score.ScoreRec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScoreManager {
    private final RulesManager<? extends VisRule> _rulesManager;

    public ScoreManager(RulesManager<? extends VisRule> rulesManager) {
        this._rulesManager = rulesManager;
    }

    public boolean validateTemplate(InputManager inputs, String templateId) {
        boolean bAllRequiredRulesPassed = true;
        List<? extends VisRule> templateRules = this._rulesManager.getTemplateRules(templateId);
        if (templateRules == null) {
            bAllRequiredRulesPassed = false;
        } else {
            for (VisRule visRule : templateRules) {
                if (!visRule.isRequired() || visRule.isResolvable(inputs)) continue;
                bAllRequiredRulesPassed = false;
            }
        }
        return bAllRequiredRulesPassed;
    }

    public ScoreRec scoreTemplate(InputManager inputs, String templateId) {
        List<ScoreRecord> scoreRecords = this.scoreTemplateRules(inputs, templateId);
        return this.convertScoresToScoreRec(scoreRecords);
    }

    public ScoreRec scoreVariation(InputManager inputs, VisParentParameter parameterTree) {
        ArrayList<ScoreRecord> scoreRecords = null;
        if (parameterTree.hasChildren()) {
            scoreRecords = new ArrayList<ScoreRecord>();
            this.getScoreFromParameterList(parameterTree.getParameters(), inputs, scoreRecords);
        }
        return this.convertScoresToScoreRec(scoreRecords);
    }

    private ScoreRec convertScoresToScoreRec(List<ScoreRecord> scoreRecords) {
        ScoreRec scoreRec = new ScoreRec();
        if (scoreRecords != null) {
            Collections.sort(scoreRecords);
            for (ScoreRecord scoreRecord : scoreRecords) {
                if (Float.isNaN(scoreRecord.score)) continue;
                scoreRec.score += scoreRecord.score;
                if (scoreRecord.scoreDescription == null) continue;
                scoreRec.descriptions.add(scoreRecord.scoreDescription);
            }
        }
        return scoreRec;
    }

    private List<ScoreRecord> scoreTemplateRules(InputManager inputs, String templateId) {
        ArrayList<ScoreRecord> scoreRecords = new ArrayList<ScoreRecord>();
        List<? extends VisRule> templateRules = this._rulesManager.getTemplateRules(templateId);
        if (templateRules != null) {
            for (VisRule visRule : templateRules) {
                ScoreRecord scoreRecord;
                if (!visRule.isScorable() || (scoreRecord = this.scoreRule(visRule, inputs)) == null) continue;
                scoreRecords.add(scoreRecord);
            }
        }
        return scoreRecords;
    }

    private void getScoreFromParameterList(List<VisParameter> parameters, InputManager inputs, List<ScoreRecord> scoreRecords) {
        for (VisParameter parameter : parameters) {
            VisParentParameter parentParam;
            ScoreRecord scoreRec;
            if (VisVariableParameter.class.isInstance(parameter) && !VisMultiVariableParameter.class.isInstance(parameter)) {
                parameter = ((VisVariableParameter)parameter).getCurrentVariation();
            }
            if ((scoreRec = this.scoreParameter(parameter, inputs)) != null) {
                scoreRecords.add(scoreRec);
            }
            if (!VisParentParameter.class.isInstance(parameter) || !(parentParam = (VisParentParameter)parameter).hasChildren()) continue;
            this.getScoreFromParameterList(parentParam.getParameters(), inputs, scoreRecords);
        }
    }

    private ScoreRecord scoreParameter(VisParameter parameter, InputManager inputs) {
        ScoreRecord scoreRecord = null;
        if (IScorableParameter.class.isInstance(parameter)) {
            scoreRecord = new ScoreRecord(((IScorableParameter)((Object)parameter)).getScore(), ((IScorableParameter)((Object)parameter)).getScoreDescription());
            if (scoreRecord.score == 0.0f) {
                scoreRecord = null;
            }
        }
        return scoreRecord;
    }

    private ScoreRecord scoreRule(VisRule rule, InputManager inputs) {
        ScoreRecord scoreRecord = null;
        float score = rule.getScore(inputs);
        if (score != 0.0f) {
            scoreRecord = new ScoreRecord(score, rule.getDescription());
        }
        return scoreRecord;
    }

    private class ScoreRecord
    implements Comparable<ScoreRecord> {
        public float score = 0.0f;
        public String scoreDescription = null;

        public ScoreRecord(float theScore, String theScoreDescription) {
            this.score = theScore;
            this.scoreDescription = theScoreDescription;
        }

        @Override
        public int compareTo(ScoreRecord o) {
            if (o.score > this.score) {
                return 1;
            }
            if (o.score < this.score) {
                return -1;
            }
            return 0;
        }
    }
}

