/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class xmlHelper {
    private static final char[] ENCODED_QUOT = "&quot;".toCharArray();
    private static final char[] ENCODED_AMP = "&amp;".toCharArray();
    private static final char[] ENCODED_APOS = "&apos;".toCharArray();
    private static final char[] ENCODED_LT = "&lt;".toCharArray();
    private static final char[] ENCODED_GT = "&gt;".toCharArray();

    public static Node parseXMLFile(String sFileName) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document inputDocument = builder.parse(new File(sFileName));
            return inputDocument.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Node parseXMLStream(InputStream istream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document inputDocument = builder.parse(istream);
            return inputDocument.getDocumentElement();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Node parseString(String sInput) {
        Document doc = xmlHelper.getParsedDocument(sInput);
        if (doc != null) {
            return xmlHelper.getParsedDocument(sInput).getDocumentElement();
        }
        return null;
    }

    public static Document getParsedDocument(String contents) {
        String processingInstruction;
        int posEncoding;
        String encoding = "UTF-8";
        if ("<?xml".equals(contents.substring(0, 5)) && (posEncoding = (processingInstruction = contents.substring(5, contents.indexOf("?>"))).indexOf("encoding=")) != -1) {
            encoding = processingInstruction.substring(posEncoding += 10);
            int posQuot = encoding.indexOf(34);
            if (posQuot == -1) {
                posQuot = encoding.indexOf(39);
            }
            encoding = encoding.substring(0, posQuot);
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            builder = factory.newDocumentBuilder();
            Document inputDocument = builder.parse(new ByteArrayInputStream(contents.trim().getBytes(encoding)));
            return inputDocument;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAttribute(Node node, String attributeName) {
        Node attribute = node.getAttributes().getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    public static String getAttributeChecked(Element element, String name) {
        if (element.hasAttribute(name)) {
            return element.getAttribute(name);
        }
        throw new UnsupportedOperationException("Expected " + name + " attribute in:\n" + xmlHelper.nodeToString(element));
    }

    public static Element getChildElement(Element element, String name, boolean checkAndThrow) {
        Element result = null;
        NodeList nodeList = element.getElementsByTagName(name);
        int length = nodeList.getLength();
        if (1 == length) {
            result = (Element)nodeList.item(0);
        } else if (checkAndThrow) {
            if (0 == length) {
                throw new UnsupportedOperationException("Expected " + name + " element in:\n" + xmlHelper.nodeToString(element));
            }
            throw new UnsupportedOperationException("Expected only one " + name + " element in:\n" + xmlHelper.nodeToString(element));
        }
        return result;
    }

    public static Element getChildElementChecked(Element element, String name) {
        return xmlHelper.getChildElement(element, name, true);
    }

    private static XPathExpression prepareXpathExpression(String expression) {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        XPathExpression xPathExpr = null;
        try {
            xPathExpr = xpath.compile(expression);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xPathExpr;
    }

    public static String resolveXPathString(Node node, String expression) {
        XPathExpression xPathExpr = xmlHelper.prepareXpathExpression(expression);
        return xmlHelper.resolveXPathString(node, xPathExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resolveXPathString(Node node, XPathExpression xPathExpr) {
        String resolvedString = null;
        try {
            XPathExpression xPathExpression = xPathExpr;
            synchronized (xPathExpression) {
                resolvedString = (String)xPathExpr.evaluate(node, XPathConstants.STRING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resolvedString;
    }

    public static boolean resolveXPathBoolean(Node node, String expression) {
        XPathExpression xPathExpr = xmlHelper.prepareXpathExpression(expression);
        return xmlHelper.resolveXPathBoolean(node, xPathExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean resolveXPathBoolean(Node node, XPathExpression xPathExpr) {
        boolean value = false;
        try {
            XPathExpression xPathExpression = xPathExpr;
            synchronized (xPathExpression) {
                value = (Boolean)xPathExpr.evaluate(node, XPathConstants.BOOLEAN);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static float resolveXPathNumber(Node node, String expression) {
        XPathExpression xPathExpr = xmlHelper.prepareXpathExpression(expression);
        return xmlHelper.resolveXPathNumber(node, xPathExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float resolveXPathNumber(Node node, XPathExpression xPathExpr) {
        float value = 0.0f;
        try {
            XPathExpression xPathExpression = xPathExpr;
            synchronized (xPathExpression) {
                value = ((Double)xPathExpr.evaluate(node, XPathConstants.NUMBER)).floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static NodeList resolveNodeListXpath(Node node, String expression) {
        XPathExpression xPathExpr = xmlHelper.prepareXpathExpression(expression);
        return xmlHelper.resolveNodeListXpath(node, xPathExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeList resolveNodeListXpath(Node node, XPathExpression xPathExpr) {
        NodeList nodes = null;
        try {
            XPathExpression xPathExpression = xPathExpr;
            synchronized (xPathExpression) {
                nodes = (NodeList)xPathExpr.evaluate(node, XPathConstants.NODESET);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodes;
    }

    public static Node resolveNodeXpath(Node node, String expression) {
        XPathExpression xPathExpr = xmlHelper.prepareXpathExpression(expression);
        return xmlHelper.resolveNodeXpath(node, xPathExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node resolveNodeXpath(Node node, XPathExpression xPathExpr) {
        Node returnNode = null;
        try {
            XPathExpression xPathExpression = xPathExpr;
            synchronized (xPathExpression) {
                returnNode = (Node)xPathExpr.evaluate(node, XPathConstants.NODE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnNode;
    }

    public static Map<String, String> getAttributesFromNode(Node node) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            Node attribute = node.getAttributes().item(i);
            attributes.put(attribute.getNodeName(), attribute.getTextContent());
        }
        return attributes;
    }

    public static String nodeToString(Node node) {
        return xmlHelper.domSourceToString(new DOMSource(node), true);
    }

    public static String nodeListToString(NodeList nodeList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(i).append(": ").append(xmlHelper.nodeToString(nodeList.item(i)));
        }
        return sb.toString();
    }

    public static String docToString(Node node) {
        return xmlHelper.domSourceToString(new DOMSource(node), false);
    }

    public static String docToString(Document doc) {
        return xmlHelper.domSourceToString(new DOMSource(doc), false);
    }

    private static String domSourceToString(DOMSource domSource, boolean bFragment) {
        String domSourceAsString = "";
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (bFragment) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StreamResult transformedResult = new StreamResult(new StringWriter());
            transformer.transform(domSource, transformedResult);
            domSourceAsString = transformedResult.getWriter().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domSourceAsString;
    }

    public static String encode(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int i = 0;
        int len = str.length();
        int begin = 0;
        char[] entity = null;
        char[] chars = str.toCharArray();
        StringBuffer buffer = new StringBuffer(len + 64);
        for (i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch == '<') {
                entity = ENCODED_LT;
            } else if (ch == '>') {
                entity = ENCODED_GT;
            } else if (ch == '\"') {
                entity = ENCODED_QUOT;
            } else if (ch == '&') {
                entity = ENCODED_AMP;
            } else {
                if (ch != '\'') continue;
                entity = ENCODED_APOS;
            }
            buffer.append(chars, begin, i - begin);
            buffer.append(entity);
            begin = i + 1;
        }
        buffer.append(chars, begin, len - begin);
        return buffer.toString();
    }

    public static String decode(String str) {
        if (str == null || str.length() < 1) {
            return "";
        }
        int len = str.length();
        int i = str.indexOf(38);
        if (i < 0) {
            return str;
        }
        int curPos = 0;
        char[] chars = str.toCharArray();
        StringBuffer buffer = new StringBuffer(len);
        try {
            do {
                int elen = 0;
                int ch = 38;
                char cch = chars[i + 1];
                if (cch == 'q') {
                    if (chars[i + 2] == 'u' && chars[i + 3] == 'o' && chars[i + 4] == 't') {
                        elen = 5;
                        ch = 34;
                    }
                } else if (cch == 'a') {
                    cch = chars[i + 2];
                    if (cch == 'm') {
                        if (chars[i + 3] == 'p') {
                            elen = 4;
                            ch = 38;
                        }
                    } else if (cch == 'p' && chars[i + 3] == 'o' && chars[i + 4] == 's') {
                        elen = 5;
                        ch = 39;
                    }
                } else if (cch == 'l') {
                    if (chars[i + 2] == 't') {
                        elen = 3;
                        ch = 60;
                    }
                } else if (cch == 'g' && chars[i + 2] == 't') {
                    elen = 3;
                    ch = 62;
                }
                if (chars[i + elen] == ';') {
                    buffer.append(chars, curPos, i - curPos);
                    buffer.append((char)ch);
                    curPos = i += elen + 1;
                    continue;
                }
                ++i;
            } while ((i = str.indexOf(38, i)) > 0);
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        buffer.append(chars, curPos, len - curPos);
        return buffer.toString();
    }
}

