/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.variationengine;

import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import com.ibm.aurora.visCoach.core.parameter.VisDependentValueParameter;
import com.ibm.aurora.visCoach.core.parameter.VisMultiVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisScopeParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IMultiResolvableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.variationengine.VariationTree;
import com.ibm.aurora.visCoach.core.variationengine.VisCoachParameterVariationTreeProducerException;
import java.util.List;

public class ParameterVariationTreeProducer {
    private ParameterFactory _parameterFactory = null;

    public ParameterVariationTreeProducer(ParameterFactory parameterFactory) {
        this._parameterFactory = parameterFactory;
    }

    public VariationTree getParameterVariationTree(VisParentParameter parameterTree, InputManager inputManager) throws VisCoachException {
        VisScopeParentParameter rootParameter = new VisScopeParentParameter(parameterTree, true);
        rootParameter.resolve(inputManager.getRootScope());
        this.processAllNodeChildParameters(rootParameter.getScope(null), rootParameter, parameterTree);
        return new VariationTree(rootParameter);
    }

    private boolean canProcessParameter(VisParameter param) {
        return !VisDependentValueParameter.class.isInstance(param);
    }

    private VisParameter processParameter(InputScopeObject currentScope, VisParameter originalParameter) throws VisCoachException {
        if (IMultiResolvableParameter.class.isInstance(originalParameter)) {
            return this.processMultiResolvableParameter(currentScope, originalParameter);
        }
        return this.processSimpleParameter(currentScope, originalParameter);
    }

    private VisParameter processSimpleParameter(InputScopeObject currentScope, VisParameter originalParameter) throws VisCoachException {
        VisParameter param = null;
        boolean isParentParameter = VisParentParameter.class.isInstance(originalParameter);
        param = isParentParameter ? VisParentParameter.getCopyOfParameter(originalParameter, true) : VisParameter.getCopyOfParameter(originalParameter);
        if (IResolvableParameter.class.isInstance(param) && !((IResolvableParameter)((Object)param)).isResolved()) {
            ((IResolvableParameter)((Object)param)).resolve(currentScope);
        }
        if (isParentParameter && (!IConditionalParameter.class.isInstance(param) || ((IConditionalParameter)((Object)param)).isValid())) {
            this.processAllNodeChildParameters(currentScope, (VisParentParameter)param, (VisParentParameter)originalParameter);
        }
        return param;
    }

    private VisParameter processMultiResolvableParameter(InputScopeObject currentScope, VisParameter originalParameter) throws VisCoachException {
        IMultiResolvableParameter variationsProducer = (IMultiResolvableParameter)((Object)originalParameter);
        List<InputScopeObject> possibleVariations = variationsProducer.resolvePossibleVariations(currentScope);
        if (possibleVariations.size() <= 1 && !variationsProducer.allowsMultipleVariationsAtOnce()) {
            if (possibleVariations.size() == 1) {
                return this.processSimpleParameter(possibleVariations.get(0), originalParameter);
            }
            throw new VisCoachParameterVariationTreeProducerException("MultiResolvable Parameter " + originalParameter.getName() + " could not be resolved to any possibilities");
        }
        VisVariableParameter varParam = variationsProducer.allowsMultipleVariationsAtOnce() ? (VisMultiVariableParameter)this._parameterFactory.createParameter("multivariation", originalParameter.getName()) : (VisVariableParameter)this._parameterFactory.createParameter("variation", originalParameter.getName());
        varParam.setTransient(true);
        varParam.setEnumerateAllVariationsActive(variationsProducer.allowsEnumerateAllPossiblities());
        for (InputScopeObject variationScope : possibleVariations) {
            varParam.addVariation(this.processSimpleParameter(variationScope, originalParameter));
        }
        varParam.setToResolutionGroup(variationsProducer);
        return varParam;
    }

    private void processAllNodeChildParameters(InputScopeObject scopeList, VisParentParameter parentParam, VisParentParameter originalParameter) throws VisCoachException {
        List<VisParameter> originalChildParameters;
        InputScopeObject currentScope = scopeList;
        if (IScopeParameter.class.isInstance(parentParam)) {
            currentScope = ((IScopeParameter)((Object)parentParam)).getScope(scopeList);
        }
        if ((originalChildParameters = originalParameter.getParameters()) != null) {
            for (int i = 0; i < originalChildParameters.size(); ++i) {
                VisParameter originalVisParam = originalChildParameters.get(i);
                if (this.canProcessParameter(originalVisParam)) {
                    parentParam.addChildParameter(this.processParameter(currentScope, originalVisParam));
                    continue;
                }
                VisParameter param = VisParentParameter.getCopyOfParameter(originalVisParam);
                parentParam.addChildParameter(param);
            }
        }
    }
}

