/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.variationengine;

import com.ibm.aurora.visCoach.core.IVariationsInitializationHandle;
import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.variationengine.ParameterVariationTreeProducer;
import com.ibm.aurora.visCoach.core.variationengine.VariationTree;
import com.ibm.aurora.visCoach.core.variationengine.VariationTreeResolver;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VariationManager
implements IVariationsInitializationHandle {
    private InputManager _inputsManager = null;
    private Map<String, VariationTree> _variationTreeMap = null;
    private ParameterVariationTreeProducer _parameterVariationTreeProducer = null;
    private VariationTreeResolver _variationTreeResolver = null;
    private ParameterFactory _parameterFactory = null;

    public VariationManager(ParameterFactory parameterFactory, InputManager inputsManager) {
        this._inputsManager = inputsManager;
        this._parameterFactory = parameterFactory;
        this._variationTreeResolver = new VariationTreeResolver(this._parameterFactory);
        this._variationTreeMap = new HashMap<String, VariationTree>();
        this._parameterVariationTreeProducer = new ParameterVariationTreeProducer(this._parameterFactory);
    }

    public VisParentParameter resolveVariation(String key, VisTemplate template) throws VisCoachException {
        VariationTree variationTree = this.getVariationTree(template);
        return this._variationTreeResolver.resolveVariation(key, variationTree, this._inputsManager);
    }

    public List<String> getVariationKeys(VisTemplate template) throws VisCoachException {
        return this.getVariationTree(template).getVariationKeys();
    }

    private VariationTree getVariationTree(VisTemplate template) throws VisCoachException {
        VariationTree result = this._variationTreeMap.get(template.getId());
        if (null == result) {
            result = this._parameterVariationTreeProducer.getParameterVariationTree(template.getVisParameterTree(), this._inputsManager);
            this._variationTreeMap.put(template.getId(), result);
        }
        return result;
    }

    @Override
    public InputManager getInputManager() {
        return this._inputsManager;
    }
}

