/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.variationengine;

import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.inputs.InputManager;
import com.ibm.aurora.visCoach.core.inputs.InputScopeObject;
import com.ibm.aurora.visCoach.core.parameter.VisCoachParameterCreationException;
import com.ibm.aurora.visCoach.core.parameter.VisDependentValueParameter;
import com.ibm.aurora.visCoach.core.parameter.VisLoopParameter;
import com.ibm.aurora.visCoach.core.parameter.VisMultiVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisScopeParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolvableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.variationengine.VariationTree;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariationTreeResolver {
    private ParameterFactory _parameterFactory = null;

    public VariationTreeResolver(ParameterFactory parameterFactory) {
        this._parameterFactory = parameterFactory;
    }

    public VisParentParameter resolveVariation(String key, VariationTree variationTree, InputManager inputManager) throws VisCoachException {
        variationTree.setToVariationKey(key);
        VisScopeParentParameter resolvedRoot = new VisScopeParentParameter(variationTree.getRoot(), true);
        resolvedRoot.addChildParameters(this.resolveVariationTreeChildren(variationTree.getRoot()));
        this.resolveAllDependentParameters(resolvedRoot, resolvedRoot, resolvedRoot.getScope(null));
        return resolvedRoot;
    }

    private List<VisParameter> resolveVariationTreeChildren(VisParentParameter parentParameter) throws VisCoachParameterCreationException {
        List<VisParameter> parameters = parentParameter.getParameters();
        ArrayList<VisParameter> resolvedParameters = new ArrayList<VisParameter>();
        if (parameters != null) {
            Iterator<VisParameter> i$ = parameters.iterator();
            while (i$.hasNext()) {
                VisParameter parameter;
                VisParameter currentParameter = parameter = i$.next();
                VisParameter currentCopy = null;
                if (VisVariableParameter.class.isInstance(parameter) && ((VisVariableParameter)parameter).isTransient()) {
                    if (!VisMultiVariableParameter.class.isInstance(parameter)) {
                        currentParameter = ((VisVariableParameter)parameter).getCurrentVariation();
                    } else {
                        VisLoopParameter loopParam = (VisLoopParameter)this._parameterFactory.createParameter("loop", parameter.getName());
                        loopParam.addChildParameters(((VisMultiVariableParameter)parameter).getCurrentVariations());
                        currentParameter = loopParam;
                    }
                }
                if (VisParentParameter.class.isInstance(currentParameter)) {
                    currentCopy = VisParentParameter.getCopyOfParameter(currentParameter, true);
                    VisParentParameter currentParentParameter = (VisParentParameter)currentParameter;
                    if (currentParentParameter.getNumChildren() != 0) {
                        ((VisParentParameter)currentCopy).addChildParameters(this.resolveVariationTreeChildren(currentParentParameter));
                    }
                } else {
                    currentCopy = VisParameter.getCopyOfParameter(currentParameter);
                }
                resolvedParameters.add(currentCopy);
            }
        }
        return resolvedParameters;
    }

    private void resolveAllDependentParameters(VisParentParameter parameter, VisParentParameter scopeParent, InputScopeObject currentInputScope) throws VisCoachException {
        if (parameter.hasChildren()) {
            for (VisParameter param : parameter.getParameters()) {
                if (VisDependentValueParameter.class.isInstance(param)) {
                    VisDependentValueParameter dependentParam = (VisDependentValueParameter)param;
                    dependentParam.setDependentParameters(this.getParametersByName(dependentParam.getDependentParametersNames(), scopeParent));
                    if (IResolvableParameter.class.isInstance(param)) {
                        ((IResolvableParameter)((Object)param)).resolve(currentInputScope);
                    }
                }
                if (!VisParentParameter.class.isInstance(param)) continue;
                if (IScopeParameter.class.isInstance(param)) {
                    this.resolveAllDependentParameters((VisParentParameter)param, (VisParentParameter)param, ((IScopeParameter)((Object)param)).getScope(currentInputScope));
                    continue;
                }
                this.resolveAllDependentParameters((VisParentParameter)param, scopeParent, currentInputScope);
            }
        }
    }

    private List<VisParameter> getParametersByName(List<String> parameterNames, VisParentParameter scopeRoot) {
        ArrayList<VisParameter> visParameters = new ArrayList<VisParameter>();
        for (String parameterName : parameterNames) {
            List<VisParameter> paramReferences = this.getParameterDescedents(parameterName, scopeRoot);
            if (paramReferences == null) continue;
            visParameters.addAll(paramReferences);
        }
        return visParameters;
    }

    private List<VisParameter> getParameterDescedents(String parameterPath, VisParentParameter parentParameter) {
        List<Object> parameters = null;
        if (parameterPath != null) {
            String paramName = parameterPath;
            String remainingPath = null;
            if (paramName.indexOf(46) != -1) {
                paramName = parameterPath.substring(0, parameterPath.indexOf(46));
                remainingPath = parameterPath.substring(parameterPath.indexOf(46) + 1);
            }
            VisParameter currentParameter = parentParameter.getChildParameter(paramName);
            if (remainingPath != null) {
                if (VisParentParameter.class.isInstance(currentParameter) && ((VisParentParameter)currentParameter).hasChildren()) {
                    if (VisLoopParameter.class.isInstance(currentParameter)) {
                        parameters = new ArrayList();
                        for (VisParameter childParameter : ((VisLoopParameter)currentParameter).getParameters()) {
                            if (!VisParentParameter.class.isInstance(childParameter)) continue;
                            parameters.addAll(this.getParameterDescedents(remainingPath, (VisParentParameter)childParameter));
                        }
                    } else {
                        parameters = this.getParameterDescedents(remainingPath, (VisParentParameter)currentParameter);
                    }
                }
            } else {
                parameters = new ArrayList<VisParameter>();
                parameters.add(currentParameter);
            }
        }
        return parameters;
    }
}

