/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.variationengine;

import com.ibm.aurora.visCoach.core.parameter.VisMultiVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolutionGroupMember;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.visCoach.core.variationengine.GroupedVariationDescriptor;
import com.ibm.aurora.visCoach.core.variationengine.VariationDescriptor;
import com.ibm.aurora.visCoach.core.variationengine.VisCoachVariationSerializationException;
import com.ibm.aurora.visCoach.core.variationengine.utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VariationsSerializationsEnumerator {
    public static List<String> getVariationKeys(VisParentParameter rootParameter) throws VisCoachVariationSerializationException {
        ArrayList<String> varationKeys = new ArrayList<String>();
        List<VariationDescriptor> varationDescriptors = VariationsSerializationsEnumerator.generateParentVariationKeys(rootParameter, null);
        if (!varationDescriptors.isEmpty()) {
            for (VariationDescriptor variationDescriptor : varationDescriptors) {
                varationKeys.add(variationDescriptor.variationKey);
            }
        } else {
            varationKeys.add("");
        }
        return varationKeys;
    }

    private static List<VariationDescriptor> getVariationKeysFromVarationParameterList(List<VisParameter> parameters, Map<String, GroupedVariationDescriptor> groupDescriptorSoFar) throws VisCoachVariationSerializationException {
        List<VariationDescriptor> varationDescriptors = new ArrayList<VariationDescriptor>();
        List<VisParentParameter> parentParameters = utils.getParentParametersFromParameterList(parameters);
        if (!parentParameters.isEmpty()) {
            int numParameters = parentParameters.size();
            VariationDescriptor variationDescriptor = new VariationDescriptor("", groupDescriptorSoFar);
            if (variationDescriptor.groupDescriptor == null) {
                variationDescriptor.groupDescriptor = utils.createEmptyGroupedVariationMap(parameters);
            }
            varationDescriptors.add(variationDescriptor);
            for (int i = 0; i < numParameters; ++i) {
                VisParentParameter parentParameter = parentParameters.get(i);
                varationDescriptors = VariationsSerializationsEnumerator.addCurrentParentParameterVariations(parentParameter, varationDescriptors, i == 0);
            }
            for (VariationDescriptor descriptor : varationDescriptors) {
                if (utils.isUnambiguousVariationSerializaion(descriptor.variationKey)) {
                    descriptor.variationKey = "";
                }
                if (descriptor.variationKey.length() <= 0) continue;
                descriptor.variationKey = "(" + descriptor.variationKey + ")";
            }
        }
        return varationDescriptors;
    }

    private static List<VariationDescriptor> addCurrentParentParameterVariations(VisParentParameter parentParameter, List<VariationDescriptor> variationsSoFar, boolean firstPass) throws VisCoachVariationSerializationException {
        ArrayList<VariationDescriptor> varationKeys = new ArrayList<VariationDescriptor>();
        for (VariationDescriptor variationSoFar : variationsSoFar) {
            List<VariationDescriptor> varationKeysFromParameter = VariationsSerializationsEnumerator.generateParentVariationKeys(parentParameter, variationSoFar.groupDescriptor);
            String keySoFar = variationSoFar.variationKey;
            if (!firstPass) {
                keySoFar = keySoFar + ",";
            }
            if (varationKeysFromParameter.isEmpty()) {
                varationKeys.add(new VariationDescriptor(keySoFar, variationSoFar.groupDescriptor));
                continue;
            }
            for (VariationDescriptor variationFromParent : varationKeysFromParameter) {
                varationKeys.add(new VariationDescriptor(keySoFar + variationFromParent.variationKey, variationFromParent.groupDescriptor));
            }
        }
        return varationKeys;
    }

    private static List<VariationDescriptor> generateParentVariationKeys(VisParentParameter parentParameter, Map<String, GroupedVariationDescriptor> groupVariationDescriptors) throws VisCoachVariationSerializationException {
        List<VariationDescriptor> varationKeys = new ArrayList<VariationDescriptor>();
        if (parentParameter.hasChildren()) {
            if (VisMultiVariableParameter.class.isInstance(parentParameter)) {
                varationKeys = VariationsSerializationsEnumerator.generateMultiVariableParameterVariationKeys((VisMultiVariableParameter)parentParameter, groupVariationDescriptors);
            } else if (VisVariableParameter.class.isInstance(parentParameter)) {
                varationKeys = VariationsSerializationsEnumerator.generateVariableParameterVariationKeys((VisVariableParameter)parentParameter, groupVariationDescriptors);
            } else if (IScopeParameter.class.isInstance(parentParameter)) {
                varationKeys = VariationsSerializationsEnumerator.getVariationKeysFromVarationParameterList(parentParameter.getParameters(), null);
                for (VariationDescriptor subVariationDescriptor : varationKeys) {
                    subVariationDescriptor.groupDescriptor = groupVariationDescriptors;
                }
            } else {
                varationKeys = VariationsSerializationsEnumerator.getVariationKeysFromVarationParameterList(parentParameter.getParameters(), groupVariationDescriptors);
            }
        }
        return varationKeys;
    }

    private static List<VariationDescriptor> generateMultiVariableParameterVariationKeys(VisMultiVariableParameter multiVarParm, Map<String, GroupedVariationDescriptor> groupVariationDescriptors) throws VisCoachVariationSerializationException {
        ArrayList<VariationDescriptor> varationKeys = new ArrayList<VariationDescriptor>();
        GroupedVariationDescriptor currentGroupDescriptor = VariationsSerializationsEnumerator.getCurrentGroupDescriptor(multiVarParm, groupVariationDescriptors);
        List<int[]> varationOrderings = VariationsSerializationsEnumerator.getOrderingsFromMultiVariableParameter(multiVarParm, currentGroupDescriptor);
        if (!varationOrderings.isEmpty()) {
            for (int[] varationOrdering : varationOrderings) {
                int i;
                if (currentGroupDescriptor != null) {
                    for (i = 0; i < varationOrdering.length; ++i) {
                        currentGroupDescriptor.reservedVariations[varationOrdering[i]] = true;
                    }
                }
                multiVarParm.setAllVariationsInnactive();
                for (i = 0; i < varationOrdering.length; ++i) {
                    multiVarParm.setVariationActive(varationOrdering[i], true);
                }
                List<VisParameter> currentVariations = multiVarParm.getCurrentVariations();
                List<VariationDescriptor> subVarationDescriptors = VariationsSerializationsEnumerator.getVariationKeysFromVarationParameterList(currentVariations, groupVariationDescriptors);
                if (subVarationDescriptors.isEmpty()) {
                    varationKeys.add(new VariationDescriptor(multiVarParm.serializeVariationChoices(), groupVariationDescriptors));
                } else {
                    for (VariationDescriptor subVariationDescriptor : subVarationDescriptors) {
                        varationKeys.add(new VariationDescriptor(multiVarParm.serializeVariationChoices() + subVariationDescriptor.variationKey, subVariationDescriptor.groupDescriptor));
                    }
                }
                if (currentGroupDescriptor == null) continue;
                for (i = 0; i < varationOrdering.length; ++i) {
                    currentGroupDescriptor.reservedVariations[varationOrdering[i]] = false;
                }
            }
        }
        if (varationKeys.isEmpty()) {
            multiVarParm.setAllVariationsInnactive();
            varationKeys.add(new VariationDescriptor(multiVarParm.serializeVariationChoices(), groupVariationDescriptors));
        }
        return varationKeys;
    }

    private static List<VariationDescriptor> generateVariableParameterVariationKeys(VisVariableParameter varParam, Map<String, GroupedVariationDescriptor> groupVariationDescriptors) throws VisCoachVariationSerializationException {
        ArrayList<VariationDescriptor> varationKeys = new ArrayList<VariationDescriptor>();
        GroupedVariationDescriptor currentGroupDescriptor = VariationsSerializationsEnumerator.getCurrentGroupDescriptor(varParam, groupVariationDescriptors);
        List<Integer> allowedsubVariations = VariationsSerializationsEnumerator.getAllowedVariationIndexesFromVariableParameter(varParam, currentGroupDescriptor);
        for (Integer variationIndex : allowedsubVariations) {
            if (currentGroupDescriptor != null) {
                currentGroupDescriptor.reservedVariations[variationIndex.intValue()] = true;
            }
            varParam.setcurrentVariation(variationIndex);
            VisParameter currentVariation = varParam.getCurrentVariation();
            List<VariationDescriptor> subVarationDescriptors = null;
            if (VisParentParameter.class.isInstance(currentVariation)) {
                subVarationDescriptors = VariationsSerializationsEnumerator.generateParentVariationKeys((VisParentParameter)currentVariation, groupVariationDescriptors);
            }
            if (subVarationDescriptors == null || subVarationDescriptors.isEmpty()) {
                varationKeys.add(new VariationDescriptor(varParam.serializeVariationChoices(), groupVariationDescriptors));
            } else {
                for (VariationDescriptor subVariationDescriptor : subVarationDescriptors) {
                    varationKeys.add(new VariationDescriptor(varParam.serializeVariationChoices() + "(" + subVariationDescriptor.variationKey + ")", subVariationDescriptor.groupDescriptor));
                }
            }
            if (currentGroupDescriptor == null) continue;
            currentGroupDescriptor.reservedVariations[variationIndex.intValue()] = false;
        }
        return varationKeys;
    }

    private static GroupedVariationDescriptor getCurrentGroupDescriptor(IResolutionGroupMember resolutionGroupMember, Map<String, GroupedVariationDescriptor> groupVariationDescriptors) {
        if (groupVariationDescriptors.containsKey(resolutionGroupMember.getResolutionGroupName())) {
            return groupVariationDescriptors.get(resolutionGroupMember.getResolutionGroupName());
        }
        return null;
    }

    private static List<Integer> getAllowedVariationIndexesFromVariableParameter(VisVariableParameter varParameter, GroupedVariationDescriptor currentGroupDescriptor) {
        ArrayList<Integer> allowedVariations = new ArrayList<Integer>();
        boolean allowMultipleVariations = varParameter.enumerateAllVariationsActive();
        for (int i = 0; i < varParameter.getNumVariations() && (allowMultipleVariations || allowedVariations.isEmpty()); ++i) {
            VisParameter childParam;
            if (currentGroupDescriptor != null && currentGroupDescriptor.reservedVariations[i] || IConditionalParameter.class.isInstance(childParam = varParameter.getParameters().get(i)) && !((IConditionalParameter)((Object)childParam)).isValid()) continue;
            allowedVariations.add(new Integer(i));
        }
        return allowedVariations;
    }

    private static List<int[]> getOrderingsFromMultiVariableParameter(VisMultiVariableParameter multiVarParameter, GroupedVariationDescriptor currentGroupDescriptor) throws VisCoachVariationSerializationException {
        int i;
        int sizeOfSets = multiVarParameter.getNumVariations();
        boolean[] reservedVariations = new boolean[sizeOfSets];
        if (currentGroupDescriptor != null) {
            System.arraycopy(currentGroupDescriptor.reservedVariations, 0, reservedVariations, 0, sizeOfSets);
            sizeOfSets -= currentGroupDescriptor.numParameters - 1;
        } else {
            for (i = 0; i < reservedVariations.length; ++i) {
                reservedVariations[i] = false;
            }
        }
        for (i = 0; i < reservedVariations.length; ++i) {
            VisParameter childParam;
            if (reservedVariations[i] || !IConditionalParameter.class.isInstance(childParam = multiVarParameter.getParameters().get(i)) || ((IConditionalParameter)((Object)childParam)).isValid()) continue;
            reservedVariations[i] = true;
            --sizeOfSets;
        }
        return utils.generatePossibleOrderingsForMultiGroup(reservedVariations, sizeOfSets, multiVarParameter.enumerateAllVariationsActive());
    }
}

