/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.variationengine;

import com.ibm.aurora.visCoach.core.parameter.VisMultiVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IResolutionGroupMember;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IScopeParameter;
import com.ibm.aurora.visCoach.core.variationengine.GroupedVariationDescriptor;
import com.ibm.aurora.visCoach.core.variationengine.VisCoachVariationSerializationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class utils {
    private utils() {
    }

    public static List<VisParentParameter> getParentParametersFromParameterList(List<VisParameter> parameters) {
        ArrayList<VisParentParameter> parentParameters = new ArrayList<VisParentParameter>();
        if (parameters != null) {
            for (VisParameter param : parameters) {
                if (!VisParentParameter.class.isInstance(param) || !((VisParentParameter)param).hasChildren()) continue;
                parentParameters.add((VisParentParameter)param);
            }
        }
        return parentParameters;
    }

    public static Map<String, GroupedVariationDescriptor> createEmptyGroupedVariationMap(List<VisParameter> parameters) throws VisCoachVariationSerializationException {
        HashMap<String, GroupedVariationDescriptor> groupedVariationParameters = new HashMap<String, GroupedVariationDescriptor>();
        utils.createEmptyGroupedVariationMap(parameters, groupedVariationParameters);
        return groupedVariationParameters;
    }

    private static void createEmptyGroupedVariationMap(List<VisParameter> parameters, Map<String, GroupedVariationDescriptor> groupedVariationParameters) throws VisCoachVariationSerializationException {
        for (VisParameter parameter : parameters) {
            if (IResolutionGroupMember.class.isInstance(parameter) && ((IResolutionGroupMember)((Object)parameter)).getResolutionGroupName() != null) {
                IResolutionGroupMember resolutionGroupParam = (IResolutionGroupMember)((Object)parameter);
                GroupedVariationDescriptor currentGroupDescriptor = null;
                if (groupedVariationParameters.containsKey(resolutionGroupParam.getResolutionGroupName())) {
                    currentGroupDescriptor = groupedVariationParameters.get(resolutionGroupParam.getResolutionGroupName());
                } else {
                    currentGroupDescriptor = new GroupedVariationDescriptor();
                    currentGroupDescriptor.numParameters = 0;
                    int numChildren = 1;
                    if (VisVariableParameter.class.isInstance(parameter)) {
                        numChildren = ((VisParentParameter)parameter).getNumChildren();
                    }
                    currentGroupDescriptor.reservedVariations = new boolean[numChildren];
                    groupedVariationParameters.put(resolutionGroupParam.getResolutionGroupName(), currentGroupDescriptor);
                }
                if (VisMultiVariableParameter.class.isInstance(parameter)) {
                    if (currentGroupDescriptor.multiVariationInGroup) {
                        throw new VisCoachVariationSerializationException("More than one multivariation parameter in resolution grouping " + resolutionGroupParam.getResolutionGroupName());
                    }
                    currentGroupDescriptor.multiVariationInGroup = true;
                }
                ++currentGroupDescriptor.numParameters;
                continue;
            }
            if (!VisParentParameter.class.isInstance(parameter) || !((VisParentParameter)parameter).hasChildren() || IScopeParameter.class.isInstance(parameter)) continue;
            utils.createEmptyGroupedVariationMap(((VisParentParameter)parameter).getParameters(), groupedVariationParameters);
        }
    }

    public static List<int[]> generatePossibleOrderingsForMultiGroup(boolean[] innactiveVariations, int sizeOfSets, boolean allowMultipleOrderings) throws VisCoachVariationSerializationException {
        int i;
        int validVariationsCounter = 0;
        for (i = 0; i < innactiveVariations.length; ++i) {
            if (innactiveVariations[i]) continue;
            ++validVariationsCounter;
        }
        if (validVariationsCounter < sizeOfSets) {
            throw new VisCoachVariationSerializationException("Impossible to generate necessary multi-group orderings, only " + validVariationsCounter + " possible choices but " + sizeOfSets + " are desired");
        }
        int currentArrayIndex = 0;
        int[] validIndexes = new int[validVariationsCounter];
        boolean[] arrayMask = new boolean[validVariationsCounter];
        for (i = 0; i < innactiveVariations.length; ++i) {
            if (innactiveVariations[i]) continue;
            validIndexes[currentArrayIndex++] = i;
        }
        if (allowMultipleOrderings) {
            return utils.generatePossibleOrderingsForMultiGroup(validIndexes, sizeOfSets, arrayMask);
        }
        int[] singleVariation = new int[sizeOfSets];
        for (i = 0; i < sizeOfSets; ++i) {
            singleVariation[i] = validIndexes[i];
        }
        ArrayList<int[]> singleOrdering = new ArrayList<int[]>();
        singleOrdering.add(singleVariation);
        return singleOrdering;
    }

    private static List<int[]> generatePossibleOrderingsForMultiGroup(int[] arrayMembers, int desiredArraySize, boolean[] arrayMask) {
        ArrayList<int[]> orderings = new ArrayList<int[]>();
        if (desiredArraySize > 0) {
            for (int i = 0; i < arrayMembers.length; ++i) {
                if (arrayMask[i]) continue;
                if (desiredArraySize == 1) {
                    int[] currentOrder = new int[]{arrayMembers[i]};
                    orderings.add(currentOrder);
                    continue;
                }
                arrayMask[i] = true;
                List<int[]> subArrays = utils.generatePossibleOrderingsForMultiGroup(arrayMembers, desiredArraySize - 1, arrayMask);
                arrayMask[i] = false;
                for (int[] subArray : subArrays) {
                    int[] currentOrder = new int[desiredArraySize];
                    currentOrder[0] = arrayMembers[i];
                    System.arraycopy(subArray, 0, currentOrder, 1, subArray.length);
                    orderings.add(currentOrder);
                }
            }
        }
        return orderings;
    }

    public static boolean isUnambiguousVariationSerializaion(String serialization) {
        for (int i = 0; i < serialization.length(); ++i) {
            if (serialization.charAt(i) == ',') continue;
            return false;
        }
        return true;
    }
}

