/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.visTemplate;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class IndexListParser {
    private ArrayList<String> _indexes = new ArrayList();
    private int _length;

    public IndexListParser(String indexes, int length) {
        this._length = length;
        StringTokenizer indexTokenizer = new StringTokenizer(indexes, ",", false);
        while (indexTokenizer.hasMoreElements()) {
            this._indexes.add(indexTokenizer.nextToken());
        }
    }

    public int[] getIndexList() {
        int estimatedSize = this.countIndexes();
        int[] indexList = new int[estimatedSize];
        int idx = 0;
        for (String index : this._indexes) {
            int currentIndex;
            if (index.charAt(0) == '[') {
                for (currentIndex = this.getFirstIndexFromRange(index); currentIndex <= this.getLastIndexFromRange(index); ++currentIndex) {
                    if (currentIndex < 0 || currentIndex >= this._length) continue;
                    indexList[idx++] = currentIndex;
                }
                continue;
            }
            currentIndex = this.parseIndex(index);
            if (currentIndex < 0 || currentIndex >= this._length) continue;
            indexList[idx++] = currentIndex;
        }
        if (estimatedSize != idx) {
            int[] sizedIndexList = new int[idx];
            System.arraycopy(indexList, 0, sizedIndexList, 0, idx);
            indexList = sizedIndexList;
        }
        return indexList;
    }

    private int countIndexes() {
        int numIndexes = 0;
        for (String index : this._indexes) {
            if (index.charAt(0) == '[') {
                numIndexes += this.getLastIndexFromRange(index) - this.getFirstIndexFromRange(index) + 1;
                continue;
            }
            ++numIndexes;
        }
        return numIndexes;
    }

    private int getFirstIndexFromRange(String range) {
        return this.parseIndex(range.substring(1, range.indexOf(58)));
    }

    private int getLastIndexFromRange(String range) {
        return this.parseIndex(range.substring(range.indexOf(58) + 1, range.length() - 1));
    }

    private int parseIndex(String index) {
        int parsedIndex = Integer.valueOf(index, 10);
        if (parsedIndex < 0) {
            parsedIndex = this._length + parsedIndex;
        }
        return parsedIndex;
    }
}

