/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.visTemplate;

import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.parameter.VisLoopParameter;
import com.ibm.aurora.visCoach.core.parameter.VisMultiVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParameter;
import com.ibm.aurora.visCoach.core.parameter.VisParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisScopeParentParameter;
import com.ibm.aurora.visCoach.core.parameter.VisValueParameter;
import com.ibm.aurora.visCoach.core.parameter.VisVariableParameter;
import com.ibm.aurora.visCoach.core.parameter.interfaces.IConditionalParameter;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.utils.JsonHelper;
import com.ibm.aurora.visCoach.core.utils.xmlHelper;
import com.ibm.aurora.visCoach.core.visTemplate.IInfoParameterResolver;
import com.ibm.aurora.visCoach.core.visTemplate.IndexListParser;
import com.ibm.aurora.visCoach.core.visTemplate.VisCoachTemplateParameterParsingException;
import com.ibm.aurora.visCoach.core.visTemplate.VisCoachTemplateParsingException;
import com.ibm.aurora.visCoach.core.visTemplate.VisCoachTemplateResolutionException;
import com.ibm.aurora.visCoach.core.visTemplate.VisCoachTemplateServiceException;
import com.ibm.aurora.visCoach.core.visTemplate.VisParameterScopeRecord;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateService;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateSourceParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Node;

public class VisTemplate
implements IInfoParameterResolver {
    public static final String ROOT_SCOPE = "root";
    private static final String TEMPLATE_NODE_NAME_PAYLOAD = "payload";
    private static final String TEMPLATE_NODE_NAME_PARAMETERS = "parameters";
    private static final String TEMPLATE_NODE_NAME_SCORE_VARIATION = "scoreVariation";
    private static final String TEMPLATE_NODE_NAME_VALIDATE_VARIATION = "validateVariation";
    private static final String TEMPLATE_NODE_NAME_INFO = "info";
    private static final String TEMPLATE_NODE_NAME_SUB_TEMPLATES = "subtemplates";
    private static final String TEMPLATE_NODE_NAME_PARAMETER = "param";
    private static final String TEMPLATE_NODE_NAME_CALL_SUB_TEMPLATE = "callSubTemplate";
    private static final String TEMPLATE_NODE_NAME_WITH_PARAM = "withParam";
    private static final String TEMPLATE_NODE_PROPERTY_NAME = "name";
    private static final String TEMPLATE_NODE_PROPERTY_SCOPE = "scope";
    private static final String TEMPLATE_NODE_PROPERTY_TYPE = "type";
    private static final String TEMPLATE_NODE_PROPERTY_DELIMETER = "delimeter";
    private static final String TEMPLATE_NODE_PROPERTY_SKIP_EMPTY = "skipEmpty";
    private static final String TEMPLATE_NODE_PROPERTY_INDEXES = "indexes";
    private static final String TEMPLATE_NODE_PROPERTY_ALLOW_EMTPY = "allowEmpty";
    private static final String TEMPLATE_NODE_PROPERTY_ENCODING = "encoding";
    private static final String TEMPLATE_NODE_PROPERTY_ENCODING_XML = "xmlEncoded";
    private static final String TEMPLATE_NODE_PROPERTY_ENCODING_JSON = "JSON";
    private static final String TEMPLATE_NODE_PROPERTY_REFERENCED = "referenced";
    private static final String TEMPLATE_NODE_PROPERTY_AS = "as";
    private static final String TEMPLATE_NODE_PROPERTY_REVERSED = "reversed";
    private static final String TEMPLATE_VALUE_FALSE = "false";
    private final String _id;
    private final VisTemplateSourceParser _sourceParser;
    private final Node _ntemplateRoot;
    private final ParameterFactory _parameterFactory;
    private final VisTemplateService _templateService;
    private final VisTemplate _baseTemplate;
    private final Map<String, SubTemplateHandle> _subTemplates;
    private volatile boolean _parsingComplete = false;
    private volatile VisParentParameter _rootParameter = null;
    private volatile boolean _isResolvable = false;

    public VisTemplate(String theId, VisTemplateSourceParser sourceParser, ParameterFactory parameterFactory, VisTemplateService templateService, VisTemplate baseTemplate) throws VisCoachException {
        this._id = theId;
        this._sourceParser = sourceParser;
        this._ntemplateRoot = this._sourceParser.getTemplateRootNode();
        this._parameterFactory = parameterFactory;
        this._templateService = templateService;
        this._baseTemplate = baseTemplate;
        this._subTemplates = this.loadSubTemplates();
    }

    public String getId() {
        return this._id;
    }

    public boolean isResolvable() throws VisCoachException {
        this.completeParsing();
        return this._isResolvable;
    }

    public VisParentParameter getVisParameterTree() throws VisCoachException {
        this.completeParsing();
        return this._rootParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeParsing() throws VisCoachException {
        if (!this._parsingComplete) {
            VisTemplate visTemplate = this;
            synchronized (visTemplate) {
                if (this._baseTemplate != null) {
                    this._rootParameter = new VisParentParameter(this._baseTemplate.getVisParameterTree());
                } else {
                    String name = null;
                    this._rootParameter = new VisParentParameter(name);
                }
                Node templateRoot = this.getTemplateRoot();
                this.parseTemplateRoot(templateRoot, this._rootParameter, null, new HashMap<String, VisScopeParentParameter>(), null);
                this._parsingComplete = true;
            }
        }
    }

    public String resolveTemplate(VisParentParameter resolvedParameterTree) throws VisCoachTemplateResolutionException {
        Node payload = xmlHelper.resolveNodeXpath(this.getTemplateRoot(), TEMPLATE_NODE_NAME_PAYLOAD);
        return this.resolveTemplateNode(resolvedParameterTree, payload);
    }

    @Override
    public String resolveTemplateInfoParameter(VisParentParameter resolvedParameterTree, String infoParam) throws VisCoachTemplateResolutionException {
        Node infoParamNode;
        Node info = xmlHelper.resolveNodeXpath(this.getTemplateRoot(), TEMPLATE_NODE_NAME_INFO);
        if (info != null && (infoParamNode = xmlHelper.resolveNodeXpath(info, infoParam)) != null) {
            return this.resolveTemplateNode(resolvedParameterTree, infoParamNode);
        }
        return null;
    }

    public boolean validateVariation(VisParentParameter resolvedParameterTree) throws VisCoachTemplateResolutionException {
        Node validation = xmlHelper.resolveNodeXpath(this.getTemplateRoot(), TEMPLATE_NODE_NAME_VALIDATE_VARIATION);
        if (this._baseTemplate != null && !this._baseTemplate.validateVariation(resolvedParameterTree)) {
            return false;
        }
        if (validation != null) {
            return !this.resolveTemplateNode(resolvedParameterTree, validation).equals(TEMPLATE_VALUE_FALSE);
        }
        return true;
    }

    @Override
    public ArrayList<String> resolveTemplateArrayInfoParameter(VisParentParameter resolvedParameterTree, String infoParam) throws VisCoachTemplateResolutionException {
        Node infoParamNode;
        Node info = xmlHelper.resolveNodeXpath(this.getTemplateRoot(), TEMPLATE_NODE_NAME_INFO);
        ArrayList<String> resolvedValues = new ArrayList<String>();
        if (info != null && (infoParamNode = xmlHelper.resolveNodeXpath(info, infoParam)) != null) {
            for (Node childNode = infoParamNode.getFirstChild(); null != childNode; childNode = childNode.getNextSibling()) {
                if (childNode.getNodeType() != 1) continue;
                String resolvedContents = this.resolveTemplateNode(resolvedParameterTree, childNode).trim();
                if (TEMPLATE_VALUE_FALSE.equals(xmlHelper.getAttribute(childNode, TEMPLATE_NODE_PROPERTY_ALLOW_EMTPY)) && resolvedContents.length() == 0) continue;
                resolvedValues.add(resolvedContents);
            }
        }
        return resolvedValues;
    }

    private String resolveTemplateNode(VisParentParameter resolvedParameterTree, Node templateNode) throws VisCoachTemplateResolutionException {
        String resolvedTemplate = this.resolveTemplateNodeChildren(resolvedParameterTree, templateNode, new HashMap<String, VisScopeParentParameter>(), null);
        return resolvedTemplate;
    }

    private void parseTemplateRoot(Node templateRoot, VisParentParameter parentParameter, SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachException {
        Node parameters = xmlHelper.resolveNodeXpath(templateRoot, TEMPLATE_NODE_NAME_PARAMETERS);
        if (parameters != null) {
            Node info;
            Node payload;
            Node validation;
            this.parseParameters(parameters, parentParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
            Node score = xmlHelper.resolveNodeXpath(templateRoot, TEMPLATE_NODE_NAME_SCORE_VARIATION);
            if (score != null) {
                this.parseParameters(score, parentParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
            }
            if ((validation = xmlHelper.resolveNodeXpath(templateRoot, TEMPLATE_NODE_NAME_VALIDATE_VARIATION)) != null) {
                this.parseParameters(validation, parentParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
            }
            if ((payload = xmlHelper.resolveNodeXpath(templateRoot, TEMPLATE_NODE_NAME_PAYLOAD)) != null) {
                this.parseParameters(payload, parentParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
                this._isResolvable = true;
            }
            if ((info = xmlHelper.resolveNodeXpath(templateRoot, TEMPLATE_NODE_NAME_INFO)) != null) {
                this.parseParameters(info, parentParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
            }
        } else {
            this.parseParameters(templateRoot, parentParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
            this._isResolvable = true;
        }
    }

    private void parseParameters(Node node, VisParentParameter parentParameter, SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachException {
        ArrayList<VisParameterScopeRecord> orphanedParameters = new ArrayList<VisParameterScopeRecord>();
        this.parseParameterList(node, parentParameter, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        this.addAllOrphanedParameters(orphanedParameters, parentParameter);
    }

    private void parseParameterList(Node node, VisParentParameter parentParam, List<VisParameterScopeRecord> orphanedParameters, SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachException {
        for (Node templateChildNode = node.getFirstChild(); null != templateChildNode; templateChildNode = templateChildNode.getNextSibling()) {
            if (templateChildNode.getNodeName().equals(TEMPLATE_NODE_NAME_PARAMETER)) {
                Node paramNode = templateChildNode;
                List<String> paramNames = this.getPropertyListFromNodeAttribute(paramNode, TEMPLATE_NODE_PROPERTY_NAME);
                for (String paramName : paramNames) {
                    Map<String, String> paramNodeAttributes = xmlHelper.getAttributesFromNode(paramNode);
                    String type = paramNodeAttributes.get(TEMPLATE_NODE_PROPERTY_TYPE);
                    String scope = xmlHelper.getAttribute(paramNode, TEMPLATE_NODE_PROPERTY_SCOPE);
                    VisParameter param = null;
                    VisScopeParentParameter templateRootParameter = this.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters);
                    param = this.getParameterFromScope(scope, paramName, parentParam, this._rootParameter, templateRootParameter);
                    if (param == null) {
                        param = this.getReferencedParameterFromScope(scope, paramName, parentParam, templateRootParameter, templateReferencedParameters);
                    }
                    if (param == null) {
                        if ("true".equals(paramNodeAttributes.get(TEMPLATE_NODE_PROPERTY_REFERENCED))) {
                            throw new VisCoachTemplateParameterParsingException(paramNodeAttributes, "Referenced parameter cannot exist in the calling template!");
                        }
                        param = this._parameterFactory.createParameter(type, paramName, paramNodeAttributes);
                        this.addParameterToScope(scope, parentParam, param, orphanedParameters, templateRootParameter);
                    } else if (!param.validateMatchesAttributes(paramNodeAttributes)) {
                        throw new VisCoachTemplateParameterParsingException(paramNodeAttributes, "Parameter attributes clash with existing parameter of the same name and scope!");
                    }
                    if (!VisParentParameter.class.isInstance(param)) continue;
                    this.parseParameterList(paramNode, (VisParentParameter)param, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
                }
                continue;
            }
            if (templateChildNode.getNodeName().equals(TEMPLATE_NODE_NAME_CALL_SUB_TEMPLATE)) {
                this.parseSubTemplate(templateChildNode, parentParam, currentTemplate, templateRootParameters, templateReferencedParameters);
                continue;
            }
            if (templateChildNode.getNodeType() != 1) continue;
            this.parseParameterList(templateChildNode, parentParam, orphanedParameters, currentTemplate, templateRootParameters, templateReferencedParameters);
        }
    }

    private VisScopeParentParameter getRootParameterFromTemplateHandle(SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters) {
        if (currentTemplate == null || templateRootParameters == null) {
            return null;
        }
        return templateRootParameters.get(currentTemplate.getName());
    }

    private void parseSubTemplate(Node subTemplateNode, VisParentParameter param, SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachException {
        boolean templateParsed;
        String subTemplateName = xmlHelper.getAttribute(subTemplateNode, TEMPLATE_NODE_PROPERTY_NAME);
        SubTemplateHandle subTemplateHandle = this.getSubTemplate(subTemplateName = this.getFullSubTemplateName(subTemplateName, currentTemplate));
        if (subTemplateHandle == null) {
            throw new VisCoachTemplateParsingException("CallTemplate node references invalid template: " + subTemplateName, this._id);
        }
        Map<String, VisParameter> subTemplateReferencedParameters = this.getReferencedTemplateParameters(subTemplateNode, param, this._rootParameter, this.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters);
        String subTemplateLookupKey = subTemplateHandle.getName() + "-";
        for (VisParameter referencedParam : subTemplateReferencedParameters.values()) {
            subTemplateLookupKey = subTemplateLookupKey + referencedParam.hashCode() + ",";
        }
        String templateName = subTemplateHandle.getName();
        VisScopeParentParameter templateRootParameter = templateRootParameters.get(templateName);
        boolean bl = templateParsed = templateRootParameter != null && templateRootParameters.get(subTemplateLookupKey) != null;
        if (!templateParsed) {
            templateRootParameter = new VisScopeParentParameter(templateName);
            templateRootParameters.put(templateName, templateRootParameter);
            templateRootParameters.put(subTemplateLookupKey, templateRootParameter);
        }
        if (!templateParsed) {
            this.parseTemplateRoot(subTemplateHandle.subTemplateRoot, templateRootParameter, subTemplateHandle, templateRootParameters, subTemplateReferencedParameters);
        }
        param.addChildParameter(templateRootParameter);
    }

    private String resolveTemplateNodeChildren(VisParentParameter resolvedParameterTree, Node node, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachTemplateResolutionException {
        return this.resolveTemplateNodeList(node, resolvedParameterTree, resolvedParameterTree, null, templateRootParameters, templateReferencedParameters);
    }

    private String resolveTemplateNodeList(Node templateNode, VisParentParameter parentParam, VisParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachTemplateResolutionException {
        String resolvedContent = "";
        for (Node templateChildNode = templateNode.getFirstChild(); null != templateChildNode; templateChildNode = templateChildNode.getNextSibling()) {
            if (templateChildNode.getNodeType() == 1) {
                if (templateChildNode.getNodeName().equals(TEMPLATE_NODE_NAME_PARAMETER)) {
                    Node paramNode = templateChildNode;
                    List<String> paramNames = this.getPropertyListFromNodeAttribute(paramNode, TEMPLATE_NODE_PROPERTY_NAME);
                    for (String paramName : paramNames) {
                        String scope = xmlHelper.getAttribute(paramNode, TEMPLATE_NODE_PROPERTY_SCOPE);
                        VisParameter param = this.getParameterFromScope(scope, paramName, parentParam, rootParameter, this.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters));
                        if (param == null) {
                            param = this.getReferencedParameterFromScope(scope, paramName, parentParam, this.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters);
                        }
                        if (param == null) {
                            if (scope != null) {
                                throw new VisCoachTemplateResolutionException("Parameter(" + paramName + ") at scope (" + scope + ") does not exist in the parameterTree", this._id);
                            }
                            throw new VisCoachTemplateResolutionException("Parameter(" + paramName + ") under parent parameter(" + parentParam.getName() + "), does not exist in the parameterTree", this._id);
                        }
                        resolvedContent = resolvedContent + this.resolveTemplateParameter(templateChildNode, param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
                    }
                    continue;
                }
                if (templateChildNode.getNodeName().equals(TEMPLATE_NODE_NAME_CALL_SUB_TEMPLATE)) {
                    Map<String, VisParameter> subTemplateReferencedParameters;
                    String subTemplateName = xmlHelper.getAttribute(templateChildNode, TEMPLATE_NODE_PROPERTY_NAME);
                    SubTemplateHandle subTemplateChildHandle = this.getSubTemplate(subTemplateName = this.getFullSubTemplateName(subTemplateName, currentTemplate));
                    if (subTemplateChildHandle == null) {
                        throw new VisCoachTemplateResolutionException("Invalid subTemplate reference " + subTemplateName, this._id);
                    }
                    try {
                        subTemplateReferencedParameters = this.getReferencedTemplateParameters(templateChildNode, parentParam, rootParameter, this.getRootParameterFromTemplateHandle(currentTemplate, templateRootParameters), templateReferencedParameters);
                    }
                    catch (VisCoachException e) {
                        throw new VisCoachTemplateResolutionException(e.getMessage(), this._id);
                    }
                    Node subTemplateRootNode = subTemplateChildHandle.subTemplateRoot;
                    Node subTemplatePayloadNode = xmlHelper.resolveNodeXpath(subTemplateRootNode, TEMPLATE_NODE_NAME_PAYLOAD);
                    if (subTemplatePayloadNode != null) {
                        subTemplateRootNode = subTemplatePayloadNode;
                    }
                    VisScopeParentParameter storedTemplateRootParameter = templateRootParameters.get(subTemplateName);
                    VisScopeParentParameter templateRootParameter = (VisScopeParentParameter)parentParam.getChildParameter(subTemplateName);
                    templateRootParameters.put(subTemplateName, templateRootParameter);
                    if (templateRootParameter == null || !VisParentParameter.class.isInstance(templateRootParameter)) {
                        throw new VisCoachTemplateResolutionException("Parameter " + parentParam.getName() + " calls template " + subTemplateName + " but contains no reference to it", this._id);
                    }
                    resolvedContent = resolvedContent + this.resolveTemplateNodeList(subTemplateRootNode, templateRootParameter, rootParameter, subTemplateChildHandle, templateRootParameters, subTemplateReferencedParameters);
                    templateRootParameters.put(subTemplateName, storedTemplateRootParameter);
                    continue;
                }
                throw new VisCoachTemplateResolutionException("Invalid ELEMENT_NODE with name: " + templateChildNode.getNodeName(), this._id);
            }
            if (templateChildNode.getNodeType() != 3) continue;
            resolvedContent = resolvedContent + templateChildNode.getTextContent();
        }
        return resolvedContent;
    }

    private Map<String, VisParameter> getReferencedTemplateParameters(Node subTemplateNode, VisParentParameter parentParam, VisParentParameter rootParameter, VisScopeParentParameter templateRootParameter, Map<String, VisParameter> templateReferencedParameters) throws VisCoachException {
        HashMap<String, VisParameter> templateCallerReferences = new HashMap<String, VisParameter>();
        for (Node withParamChildNode = subTemplateNode.getFirstChild(); null != withParamChildNode; withParamChildNode = withParamChildNode.getNextSibling()) {
            if (withParamChildNode.getNodeType() != 1) continue;
            if (withParamChildNode.getNodeName().equals(TEMPLATE_NODE_NAME_WITH_PARAM)) {
                String as;
                String paramName = xmlHelper.getAttribute(withParamChildNode, TEMPLATE_NODE_PROPERTY_NAME);
                String scope = xmlHelper.getAttribute(withParamChildNode, TEMPLATE_NODE_PROPERTY_SCOPE);
                VisParameter referencedParam = this.getParameterFromScope(scope, paramName, parentParam, rootParameter, templateRootParameter);
                if (referencedParam == null) {
                    referencedParam = this.getReferencedParameterFromScope(scope, paramName, parentParam, templateRootParameter, templateReferencedParameters);
                }
                if (referencedParam == null) {
                    Map<String, String> paramNodeAttributes = xmlHelper.getAttributesFromNode(withParamChildNode);
                    String type = paramNodeAttributes.get(TEMPLATE_NODE_PROPERTY_TYPE);
                    if (type == null) {
                        throw new VisCoachTemplateParsingException("CallTemplate references invalid parameter: " + paramName + (scope != null ? " at scope " + scope : ""), this._id);
                    }
                    referencedParam = this._parameterFactory.createParameter(type, paramName, paramNodeAttributes);
                    this.addParameterToScope(scope, parentParam, referencedParam, null, templateRootParameter);
                }
                if ((as = xmlHelper.getAttribute(withParamChildNode, TEMPLATE_NODE_PROPERTY_AS)) != null) {
                    paramName = as;
                }
                templateCallerReferences.put(paramName, referencedParam);
                continue;
            }
            throw new VisCoachTemplateParsingException("CallTemplate node contains invalid Element: " + withParamChildNode.getNodeName(), this._id);
        }
        return templateCallerReferences;
    }

    private String resolveValueParameter(Node templateNode, VisValueParameter param) {
        String textEncoding = xmlHelper.getAttribute(templateNode, TEMPLATE_NODE_PROPERTY_ENCODING);
        if (TEMPLATE_NODE_PROPERTY_ENCODING_XML.equals(textEncoding)) {
            return xmlHelper.encode(param.valueToString());
        }
        if (TEMPLATE_NODE_PROPERTY_ENCODING_JSON.equals(textEncoding)) {
            return JsonHelper.encodeString(param.valueToString());
        }
        return param.valueToString();
    }

    private String resolveTemplateParameter(Node templateNode, VisParameter param, VisParentParameter rootParameter, SubTemplateHandle currentTemplate, Map<String, VisScopeParentParameter> templateRootParameters, Map<String, VisParameter> templateReferencedParameters) throws VisCoachTemplateResolutionException {
        String resolvedContent = "";
        if (param != null) {
            if (VisValueParameter.class.isInstance(param)) {
                resolvedContent = resolvedContent + this.resolveValueParameter(templateNode, (VisValueParameter)param);
            } else if (VisVariableParameter.class.isInstance(param)) {
                if (VisMultiVariableParameter.class.isInstance(param)) {
                    throw new VisCoachTemplateResolutionException("MultiVariation parameters cannot be resolved by the template resolver, parameter: " + param.getName(), this._id);
                }
                VisParameter optionParam = ((VisVariableParameter)param).getCurrentVariation();
                for (Node currentOptionNode = templateNode.getFirstChild(); null != currentOptionNode; currentOptionNode = currentOptionNode.getNextSibling()) {
                    if (!currentOptionNode.getNodeName().equals(TEMPLATE_NODE_NAME_PARAMETER) || !this.containsName(currentOptionNode, optionParam.getName())) continue;
                    resolvedContent = resolvedContent + this.resolveTemplateParameter(currentOptionNode, optionParam, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
                }
            } else if (VisLoopParameter.class.isInstance(param)) {
                String delimeter = xmlHelper.getAttribute(templateNode, TEMPLATE_NODE_PROPERTY_DELIMETER);
                boolean skipEmpty = "true".equals(xmlHelper.getAttribute(templateNode, TEMPLATE_NODE_PROPERTY_SKIP_EMPTY));
                VisLoopParameter loopParam = (VisLoopParameter)param;
                if (loopParam.hasChildren()) {
                    int[] indexList;
                    String indexes = xmlHelper.getAttribute(templateNode, TEMPLATE_NODE_PROPERTY_INDEXES);
                    if (indexes != null) {
                        indexList = new IndexListParser(indexes, loopParam.getNumChildren()).getIndexList();
                    } else {
                        indexList = new int[loopParam.getNumChildren()];
                        for (int i = 0; i < indexList.length; ++i) {
                            indexList[i] = i;
                        }
                    }
                    boolean reversed = "true".equals(xmlHelper.getAttribute(templateNode, TEMPLATE_NODE_PROPERTY_REVERSED));
                    boolean first = true;
                    if (reversed) {
                        int[] reversedList = new int[indexList.length];
                        for (int i = 0; i < indexList.length; ++i) {
                            reversedList[i] = indexList[indexList.length - 1 - i];
                        }
                        indexList = reversedList;
                    }
                    for (int i = 0; i < indexList.length; ++i) {
                        String iterationContent = this.resolveTemplateParameter(templateNode, loopParam.getParameters().get(indexList[i]), rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
                        if (!skipEmpty || !iterationContent.trim().isEmpty()) {
                            if (!first) {
                                if (delimeter != null) {
                                    resolvedContent = resolvedContent + delimeter;
                                }
                            } else {
                                first = false;
                            }
                        }
                        resolvedContent = resolvedContent + iterationContent;
                    }
                }
            } else if (VisParentParameter.class.isInstance(param) && (!IConditionalParameter.class.isInstance(param) || ((IConditionalParameter)((Object)param)).isValid())) {
                resolvedContent = resolvedContent + this.resolveTemplateNodeList(templateNode, (VisParentParameter)param, rootParameter, currentTemplate, templateRootParameters, templateReferencedParameters);
            }
        }
        return resolvedContent;
    }

    private VisParentParameter getParentParameterFromScope(String scope, VisParentParameter parentParam, VisParentParameter rootParam) {
        if (scope != null) {
            StringTokenizer scopeTokenizer = new StringTokenizer(scope, ".", false);
            VisParentParameter currentParentParameter = rootParam;
            while (scopeTokenizer.hasMoreElements() && currentParentParameter != null) {
                String token = scopeTokenizer.nextToken();
                if (ROOT_SCOPE.equals(token)) {
                    currentParentParameter = rootParam;
                    continue;
                }
                VisParameter nextParameter = currentParentParameter.getChildParameter(token);
                currentParentParameter = null;
                if (!VisParentParameter.class.isInstance(nextParameter)) continue;
                currentParentParameter = (VisParentParameter)nextParameter;
            }
            return currentParentParameter;
        }
        return parentParam;
    }

    private void addParameterToScope(String scope, VisParentParameter parentParam, VisParameter param, List<VisParameterScopeRecord> orphanedParameters, VisScopeParentParameter templateRootParameter) {
        VisParentParameter rootParam = templateRootParameter != null ? templateRootParameter : this._rootParameter;
        VisParentParameter parentParameter = this.getParentParameterFromScope(scope, parentParam, rootParam);
        if (parentParameter != null) {
            parentParameter.addChildParameter(param);
        } else if (orphanedParameters != null) {
            orphanedParameters.add(new VisParameterScopeRecord(param, scope));
        }
    }

    private VisParameter getReferencedParameterFromScope(String scope, String name, VisParentParameter parentParam, VisScopeParentParameter templateRootParameter, Map<String, VisParameter> templateReferencedParameters) {
        VisParameter referencedParameter = null;
        if (templateRootParameter != null && templateReferencedParameters != null) {
            if (scope != null) {
                if (scope.equals(ROOT_SCOPE)) {
                    referencedParameter = templateReferencedParameters.get(name);
                } else {
                    VisParameter referencedScopeParameter;
                    String referencedName = scope;
                    int sepPos = scope.indexOf(46);
                    if (sepPos != -1) {
                        referencedName = scope.substring(0, sepPos);
                    }
                    if ((referencedScopeParameter = templateReferencedParameters.get(referencedName)) != null && sepPos != -1) {
                        String remainingScope = scope.substring(sepPos + 1);
                        if (VisParentParameter.class.isInstance(referencedScopeParameter)) {
                            referencedScopeParameter = this.getParameterFromRoot(remainingScope, name, (VisParentParameter)referencedScopeParameter, templateRootParameter);
                        }
                    }
                    if (referencedScopeParameter != null && VisParentParameter.class.isInstance(referencedScopeParameter)) {
                        referencedParameter = ((VisParentParameter)referencedScopeParameter).getChildParameter(name);
                    }
                }
            } else if (parentParam == templateRootParameter) {
                referencedParameter = templateReferencedParameters.get(name);
            }
        }
        return referencedParameter;
    }

    private VisParameter getParameterFromScope(String scope, String name, VisParentParameter parentParam, VisParentParameter templateRoot, VisScopeParentParameter templateRootParameter) {
        VisParentParameter rootParam = templateRootParameter != null ? templateRootParameter : templateRoot;
        return this.getParameterFromRoot(scope, name, parentParam, rootParam);
    }

    private VisParameter getParameterFromRoot(String scope, String name, VisParentParameter parentParam, VisParentParameter rootParam) {
        VisParentParameter parentParameter = this.getParentParameterFromScope(scope, parentParam, rootParam);
        if (parentParameter != null) {
            return parentParameter.getChildParameter(name);
        }
        return null;
    }

    private void addAllOrphanedParameters(List<VisParameterScopeRecord> orphanedParameters, VisParentParameter rootParam) {
        boolean processedSome = true;
        while (!orphanedParameters.isEmpty() && processedSome) {
            processedSome = false;
            ArrayList<VisParameterScopeRecord> remainingOrphanedParameters = new ArrayList<VisParameterScopeRecord>();
            for (VisParameterScopeRecord paramScopeRec : orphanedParameters) {
                VisParentParameter parentParameter = this.getParentParameterFromScope(paramScopeRec.scope, null, rootParam);
                if (parentParameter != null) {
                    parentParameter.addChildParameter(paramScopeRec.parameter);
                    processedSome = true;
                    continue;
                }
                remainingOrphanedParameters.add(paramScopeRec);
            }
            orphanedParameters = remainingOrphanedParameters;
        }
    }

    private List<String> getPropertyListFromNodeAttribute(Node node, String attribute) {
        String propString = xmlHelper.getAttribute(node, attribute);
        if (propString != null) {
            StringTokenizer nameTokenizer = new StringTokenizer(propString, ",", false);
            ArrayList<String> props = new ArrayList<String>();
            while (nameTokenizer.hasMoreElements()) {
                props.add(nameTokenizer.nextToken());
            }
            return props;
        }
        return null;
    }

    private boolean containsName(Node node, String name) {
        boolean containsName = false;
        List<String> names = this.getPropertyListFromNodeAttribute(node, TEMPLATE_NODE_PROPERTY_NAME);
        for (String currentName : names) {
            if (!currentName.equals(name)) continue;
            containsName = true;
            break;
        }
        return containsName;
    }

    public String toString() {
        return this._id;
    }

    private Node getTemplateRoot() {
        return this._ntemplateRoot;
    }

    private String getFullSubTemplateName(String name, SubTemplateHandle currentTemplate) {
        if (name.indexOf(58) == -1) {
            if (currentTemplate == null) {
                return this.getThisTemplateId() + ':' + name;
            }
            return currentTemplate.templateId + ':' + name;
        }
        return name;
    }

    private SubTemplateHandle getSubTemplate(String name) {
        int indexOfSeparator = name.indexOf(58);
        String templateName = name.substring(0, indexOfSeparator);
        String subTemplateName = name.substring(indexOfSeparator + 1);
        if (!templateName.equals(this.getThisTemplateId())) {
            VisTemplate referencedTemplate = null;
            String templateId = templateName + ".xml";
            if (this._templateService.containsTemplate(templateId)) {
                try {
                    referencedTemplate = this._templateService.getTemplateById(templateName + ".xml");
                }
                catch (VisCoachTemplateServiceException vctse) {
                    vctse.printStackTrace();
                }
            }
            if (referencedTemplate != null) {
                return super.getSubTemplate(name);
            }
        } else {
            return this._subTemplates.get(subTemplateName);
        }
        return null;
    }

    private String getThisTemplateId() {
        return this._id.substring(0, this._id.length() - 4);
    }

    private Map<String, SubTemplateHandle> loadSubTemplates() throws VisCoachTemplateParsingException {
        HashMap<String, SubTemplateHandle> subTemplates = new HashMap<String, SubTemplateHandle>();
        Node subTemplatesNode = xmlHelper.resolveNodeXpath(this.getTemplateRoot(), TEMPLATE_NODE_NAME_SUB_TEMPLATES);
        if (subTemplatesNode != null) {
            for (Node subtemplateChildNode = subTemplatesNode.getFirstChild(); null != subtemplateChildNode; subtemplateChildNode = subtemplateChildNode.getNextSibling()) {
                if (subtemplateChildNode.getNodeType() != 1) continue;
                String subTemplateName = xmlHelper.getAttribute(subtemplateChildNode, TEMPLATE_NODE_PROPERTY_NAME);
                if (subTemplates.containsKey(subTemplateName)) {
                    throw new VisCoachTemplateParsingException("Multiple SubTemplates with name " + subTemplateName, this._id);
                }
                subTemplates.put(subTemplateName, new SubTemplateHandle(this.getThisTemplateId(), subTemplateName, subtemplateChildNode));
            }
        }
        return subTemplates;
    }

    private class SubTemplateHandle {
        private String templateId;
        private String subTemplateName;
        public Node subTemplateRoot;

        public SubTemplateHandle(String templateId, String subTemplateName, Node subTemplateRoot) {
            this.templateId = templateId;
            this.subTemplateName = subTemplateName;
            this.subTemplateRoot = subTemplateRoot;
        }

        public String getName() {
            return this.templateId + ":" + this.subTemplateName;
        }
    }
}

