/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aurora.visCoach.core.visTemplate;

import com.ibm.aurora.visCoach.core.VisCoachException;
import com.ibm.aurora.visCoach.core.parameter.parameterFactory.ParameterFactory;
import com.ibm.aurora.visCoach.core.rules.RulesManager;
import com.ibm.aurora.visCoach.core.rules.VisRule;
import com.ibm.aurora.visCoach.core.visTemplate.VisCoachTemplateServiceException;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplate;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateFileParser;
import com.ibm.aurora.visCoach.core.visTemplate.VisTemplateSourceParser;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class VisTemplateService {
    private Map<String, File> _files = null;
    private Map<String, VisTemplate> _templates = null;
    private ParameterFactory _parameterFactory = null;
    private RulesManager<? extends VisRule> _rulesManager = null;

    public VisTemplateService(String filePath, ParameterFactory parameterFactory, RulesManager<? extends VisRule> rulesManager) {
        this._parameterFactory = parameterFactory;
        this._rulesManager = rulesManager;
        String[] paths = new String[]{filePath};
        this.loadTemplates(paths);
    }

    public VisTemplateService(String[] filePaths, ParameterFactory parameterFactory, RulesManager<? extends VisRule> rulesManager) {
        this._parameterFactory = parameterFactory;
        this._rulesManager = rulesManager;
        this.loadTemplates(filePaths);
    }

    public boolean containsTemplate(String id) {
        return this._files.containsKey(id);
    }

    public VisTemplate getTemplateById(String id) throws VisCoachTemplateServiceException {
        if (!this.containsTemplate(id)) {
            throw new VisCoachTemplateServiceException("Invalid template reference " + id);
        }
        this.loadTemplate(id);
        return this._templates.get(id);
    }

    private synchronized void loadTemplate(String id) {
        VisTemplateSourceParser sourceParser;
        VisTemplate template;
        if (!this._templates.containsKey(id) && (template = this.loadTemplate(id, sourceParser = this.getSourceParser(id))) != null) {
            this._templates.put(id, template);
        }
    }

    public Collection<VisTemplate> getTemplates() {
        return this._templates.values();
    }

    private void addFile(String fileName, File file) {
        if (this._files == null) {
            this._files = new HashMap<String, File>();
        }
        this._files.put(fileName, file);
    }

    protected VisTemplateSourceParser getSourceParser(String name) {
        File file = this._files.get(name);
        if (file != null) {
            return new VisTemplateFileParser(file.getPath());
        }
        return null;
    }

    private void loadTemplates(String[] paths) {
        this._templates = new HashMap<String, VisTemplate>();
        for (int i = 0; i < paths.length; ++i) {
            File[] files;
            File dir = new File(paths[i]);
            if (!dir.isDirectory()) continue;
            for (File file : files = dir.listFiles()) {
                String fileName = file.getName();
                if (!file.isFile() || !fileName.endsWith(".xml")) continue;
                this.addFile(fileName, file);
            }
        }
    }

    private VisTemplate loadTemplate(String name, VisTemplateSourceParser templateSourceParser) {
        VisTemplate template = null;
        try {
            String baseTemplateId = this._rulesManager.getTemplateProperty(name, "extends");
            VisTemplate baseTemplate = null;
            if (baseTemplateId != null) {
                baseTemplate = this.getTemplateById(baseTemplateId);
            }
            template = new VisTemplate(name, templateSourceParser, this._parameterFactory, this, baseTemplate);
            this._templates.put(name, template);
        }
        catch (VisCoachException vce) {
            vce.printStackTrace();
        }
        return template;
    }
}

