/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common;

import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.library.framework.CustomFormatInfo;
import com.ibm.vida.rave.library.framework.CustomFormatter;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSFormatter;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import java.util.List;

public class CommonUtils {
    public static final Double LINEAR_AXIS_TICK_GAP = 50.0;

    private CommonUtils() {
    }

    public static double optimizeMarkerSize(double _minMarkerSize, double _maxMarkerSize, double _distanceBetweenTicks) {
        return Math.min(Math.max(Math.pow(_distanceBetweenTicks / 2.0, 2.0), _minMarkerSize), _maxMarkerSize);
    }

    public static CustomFormatter tickFormat(List<IRSDataItem> _dataItems, Boolean _logarithmic) {
        IRSContDataItem contDataItem = (IRSContDataItem)_dataItems.get(0);
        final IRSFormatter formatter = contDataItem.getFormatter(RSFormatKind.Label);
        if (formatter == null) {
            return null;
        }
        if (_logarithmic.booleanValue()) {
            return new CustomFormatter(){

                public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                    if (Math.log10(Math.abs(ObjectConverter.toInt((Object)_value))) % 1.0 == 0.0) {
                        return formatter.format(_value);
                    }
                    return "";
                }
            };
        }
        return new CustomFormatter(){

            public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                return formatter.format(_value);
            }
        };
    }
}

