/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common;

import com.ibm.vipr.renderingservice.property.IRSStringProperty;
import java.util.function.Consumer;

public class DataBoundProperty {
    private final IRSStringProperty property;
    private final Consumer<Object> setter;
    private final ITransform transform;
    private Object data;
    private boolean dataDirty;

    public DataBoundProperty(IRSStringProperty _property, Consumer<Object> _setter, ITransform _transform) {
        this.property = _property;
        this.setter = _setter;
        this.transform = _transform;
        this.data = null;
    }

    public void setData(Object _data) {
        this.data = _data;
        this.dataDirty = true;
    }

    public void update() {
        if (this.property.isDirty() || this.dataDirty && this.property.getValue() == null) {
            this.setter.accept(this.getValue());
            this.dataDirty = false;
        }
    }

    private Object getValue() {
        Object value = this.property.getValue();
        if (value == null || ((String)value).length() < 1) {
            value = this.data;
            if (this.transform != null) {
                value = this.transform.transform(value);
            }
        }
        return value;
    }

    @FunctionalInterface
    public static interface ITransform {
        public Object transform(Object var1);
    }
}

