/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common;

import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.core.scales.LogScale;
import com.ibm.vida.vizbundles.common.CommonUtils;
import com.ibm.vida.vizbundles.common.groupproperties.AxisScaleProperty;
import com.ibm.vipr.renderingservice.data.IRSContDomain;
import com.ibm.vipr.renderingservice.util.RSContDomain;
import java.util.Arrays;
import java.util.List;

public class ScaleUtil {
    private static void applyLinearDomain(AbstractScale<Object, Object> _scale, IRSContDomain _dataDomain, Number _minValue, Number _maxValue, boolean _applyNiceScaling, boolean _applyPadding, boolean _zeroOrigin) {
        if (_minValue != null && _maxValue != null) {
            _scale.domain(Arrays.asList(_minValue, _maxValue));
            return;
        }
        boolean applyNiceScaling = _applyNiceScaling;
        if (_dataDomain != null && _dataDomain.isExplicit()) {
            applyNiceScaling = false;
        }
        RSContDomain dataDomain = ScaleUtil.determineContinuousDataDomain(_scale, _dataDomain, applyNiceScaling, _applyPadding, _zeroOrigin);
        _scale.domain(Arrays.asList(dataDomain.getMin(), dataDomain.getMax()));
        if (applyNiceScaling) {
            List range = _scale.range();
            Double rangeExtent = Math.abs(ObjectConverter.toDouble(range.get(0)) - ObjectConverter.toDouble(range.get(1)));
            if (rangeExtent > CommonUtils.LINEAR_AXIS_TICK_GAP) {
                long tickCount = Math.min(10L, Math.max(2L, Math.round(rangeExtent / CommonUtils.LINEAR_AXIS_TICK_GAP)));
                ((LinearScale)_scale).nice((Number)tickCount);
            } else {
                ((LinearScale)_scale).nice();
            }
        }
        if (_minValue != null) {
            _scale.domain(Arrays.asList(_minValue, _scale.domain().get(1)));
        }
        if (_maxValue != null) {
            _scale.domain(Arrays.asList(_scale.domain().get(0), _maxValue));
        }
    }

    private static RSContDomain determineContinuousDataDomain(AbstractScale<Object, Object> _scale, IRSContDomain _dataDomain, boolean _applyNiceScaling, boolean _applyPadding, boolean _zeroOrigin) {
        RSContDomain domain = new RSContDomain(_dataDomain.getMin(), _dataDomain.getMax(), _dataDomain.isExplicit());
        if (_dataDomain.isExplicit()) {
            return domain;
        }
        double min = domain.getMin();
        double max = domain.getMax();
        if (_zeroOrigin) {
            if (min > 0.0) {
                min = 0.0;
            } else if (max < 0.0) {
                max = 0.0;
            }
        }
        if (min == max) {
            if (min == 0.0) {
                min = 0.0;
                max = 1.0;
            } else {
                min = 0.9 * max;
                max = 1.1 * max;
            }
        } else if (_applyPadding) {
            double domainPadding = 0.1 * (max - min);
            LinearScale scale = (LinearScale)_scale;
            if (_applyNiceScaling) {
                scale.domain(Arrays.asList(min, max)).nice();
            } else {
                scale.domain(Arrays.asList(min, max));
            }
            if ((Double)scale.domain().get(0) != 0.0) {
                min -= domainPadding;
            }
            if ((Double)scale.domain().get(1) != 0.0) {
                max += domainPadding;
            }
        }
        return new RSContDomain(min, max, domain.isExplicit());
    }

    private static boolean canApplyLogarithmicScale(IRSContDomain _dataDomain) {
        return _dataDomain != null && (Math.signum(_dataDomain.getMin()) == 1.0 || Math.signum(_dataDomain.getMin()) == -1.0) && Math.signum(_dataDomain.getMin()) == Math.signum(_dataDomain.getMax());
    }

    public static void applyLogarithmicDomain(AbstractScale<Object, Object> _scale, IRSContDomain _dataDomain, AxisScaleProperty _axisScaleProperty) {
        double max;
        RSContDomain domain = new RSContDomain(_dataDomain.getMin(), _dataDomain.getMax(), _dataDomain.isExplicit());
        if (!ScaleUtil.canApplyLogarithmicScale(_dataDomain)) {
            return;
        }
        Number minValue = _axisScaleProperty.minValue();
        Number maxValue = _axisScaleProperty.maxValue();
        boolean applyNiceScaling = _axisScaleProperty.niceScale();
        double min = domain.getMin();
        if (min == (max = domain.getMax())) {
            boolean isNegative = Math.signum(min) == -1.0;
            min = Math.pow(10.0, Math.floor(Math.log10(Math.abs(max))));
            max = Math.pow(10.0, Math.ceil(Math.log10(Math.abs(max))));
            if (isNegative) {
                min *= -1.0;
                max *= -1.0;
            }
        }
        LogScale scale = (LogScale)_scale;
        if (applyNiceScaling) {
            scale.domain(Arrays.asList(min, max)).nice();
        } else {
            scale.domain(Arrays.asList(min, max));
        }
        if (minValue != null && Math.signum(minValue.doubleValue()) == Math.signum((Double)scale.domain().get(0))) {
            scale.domain(Arrays.asList(minValue, scale.domain().get(1)));
        }
        if (maxValue != null && Math.signum(maxValue.doubleValue()) == Math.signum((Double)scale.domain().get(0))) {
            scale.domain(Arrays.asList(scale.domain().get(0), maxValue));
        }
    }

    public static void applyContinuousAxisDomain(AbstractScale<Object, Object> _scale, IRSContDomain _dataDomain, AxisScaleProperty _axisScaleProperty) {
        if (_axisScaleProperty.logarithmic()) {
            ScaleUtil.applyLogarithmicDomain(_scale, _dataDomain, _axisScaleProperty);
        } else {
            ScaleUtil.applyLinearDomain(_scale, _dataDomain, _axisScaleProperty.minValue(), _axisScaleProperty.maxValue(), _axisScaleProperty.niceScale(), _axisScaleProperty.niceScale(), _axisScaleProperty.zeroOrigin());
        }
    }

    public static void applyContinuousDomain(AbstractScale<Object, Object> _scale, IRSContDomain _dataDomain, Number _minValue, Number _maxValue, boolean _niceScale) {
        ScaleUtil.applyLinearDomain(_scale, _dataDomain, _minValue, _maxValue, _niceScale, false, false);
    }
}

