/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.groupproperties;

import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.property.IRSValueProperty;
import com.ibm.vipr.renderingservice.property.Length;

public class PaddingProperty {
    private final IRSValueProperty<Length> left;
    private final IRSValueProperty<Length> right;
    private final IRSValueProperty<Length> top;
    private final IRSValueProperty<Length> bottom;

    public PaddingProperty(IRSProperties _properties) {
        this.left = _properties.getLength("visualization.padding.left");
        this.right = _properties.getLength("visualization.padding.right");
        this.top = _properties.getLength("visualization.padding.top");
        this.bottom = _properties.getLength("visualization.padding.bottom");
    }

    public double left(double _width) {
        return this.lengthToPx((Length)this.left.getValue(), _width);
    }

    public double right(double _width) {
        return this.lengthToPx((Length)this.right.getValue(), _width);
    }

    public double top(double _height) {
        return this.lengthToPx((Length)this.top.getValue(), _height);
    }

    public double bottom(double _height) {
        return this.lengthToPx((Length)this.bottom.getValue(), _height);
    }

    public String toCssString() {
        Length topPadding = (Length)this.top.getValue();
        Length rightPadding = (Length)this.right.getValue();
        Length leftPadding = (Length)this.left.getValue();
        Length bottomPadding = (Length)this.bottom.getValue();
        return "padding-top: " + topPadding.toString() + "; padding-right: " + rightPadding.toString() + "; padding-bottom: " + bottomPadding.toString() + "; padding-left: " + leftPadding.toString();
    }

    double lengthToPx(Length _value, double _extent) {
        if (_value == null) {
            return 0.0;
        }
        return _value.calculatePx(_extent, 10.0);
    }
}

