/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.color.Color;
import com.ibm.vida.rave.core.color.HSL;
import com.ibm.vida.rave.core.color.RGB;
import com.ibm.vida.rave.core.css.CSSStyleSheet;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.library.framework.CustomFormatInfo;
import com.ibm.vida.rave.library.framework.CustomFormatter;
import com.ibm.vida.rave.library.framework.internal.CSSConverter;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSColorStop;
import com.ibm.vipr.renderingservice.api.IRSContStops;
import com.ibm.vipr.renderingservice.data.IRSCatDataItem;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSDecorated;
import com.ibm.vipr.renderingservice.data.IRSFormatter;
import com.ibm.vipr.renderingservice.data.IRSItemClassSet;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.IRSTuple;
import com.ibm.vipr.renderingservice.data.IRSValue;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.data.RSValueType;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSCatPaletteProperty;
import com.ibm.vipr.renderingservice.property.IRSContPaletteProperty;
import com.ibm.vipr.renderingservice.property.Length;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Rave2Common {
    private static final AtomicInteger lastId = new AtomicInteger(0);
    public static final double fontSizePx = 10.0;
    private static final SingleValueFunction<Object, Object> dataPointKeyFn = new SingleValueFunction<Object, Object>(){

        public Object getValue(Object _dataPoint) {
            if (_dataPoint instanceof IRSDataPoint) {
                return ((IRSDataPoint)_dataPoint).getKey();
            }
            return null;
        }
    };

    public static int createUniqueId() {
        return lastId.incrementAndGet();
    }

    public static Double getValue(IRSDataPoint _point, String _slot) {
        IRSDatum datum = _point.get(_slot);
        if (!(datum instanceof IRSValue)) {
            return null;
        }
        IRSValue value = (IRSValue)datum;
        if (value.getValueType() == RSValueType.Missing) {
            return null;
        }
        Object rawValue = value.getValue();
        if (rawValue == null) {
            return null;
        }
        if (rawValue instanceof Number) {
            return ((Number)rawValue).doubleValue();
        }
        return Double.parseDouble(rawValue.toString());
    }

    public static SingleValueFunction<Object, Object> createValueFn(final String _slot) {
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object _data) {
                if (_data instanceof IRSDataPoint) {
                    return Rave2Common.getValue((IRSDataPoint)_data, _slot);
                }
                return null;
            }
        };
    }

    public static SingleValueFunction<Object, Object> createStaticValueFn(final Object _value) {
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object row) {
                return _value;
            }
        };
    }

    public static SingleValueFunction<Object, Object> createKeyFn(final String _slot) {
        if (_slot == null) {
            return dataPointKeyFn;
        }
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object _dataPoint) {
                IRSDatum datum;
                if (_dataPoint instanceof IRSDataPoint && (datum = ((IRSDataPoint)_dataPoint).get(_slot)) instanceof IRSTuple) {
                    return ((IRSTuple)datum).getKey();
                }
                return null;
            }
        };
    }

    public static SingleValueFunction<Object, Object> createCaptionFn(final String _slot) {
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object data) {
                if (data instanceof IRSDataPoint) {
                    IRSValue val;
                    IRSDatum datum = ((IRSDataPoint)data).get(_slot);
                    if (datum instanceof IRSTuple) {
                        return ((IRSTuple)datum).getCaption(RSFormatKind.Label);
                    }
                    if (datum instanceof IRSValue && (val = (IRSValue)datum).getValueType() != RSValueType.Missing) {
                        return val.getValue();
                    }
                    return null;
                }
                if (data instanceof IRSTuple) {
                    return ((IRSTuple)data).getCaption(RSFormatKind.Label);
                }
                if (data instanceof IRSItemClassSet) {
                    return ((IRSItemClassSet)data).getCaption(RSFormatKind.Label);
                }
                return null;
            }
        };
    }

    public static SingleValueFunction<Object, Object> createIndexFn(final IRSSlot _slot) {
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object _data) {
                IRSDatum datum;
                if (_data instanceof IRSDataPoint && (datum = ((IRSDataPoint)_data).get(_slot)) instanceof IRSTuple) {
                    return String.valueOf(((IRSTuple)datum).getIndex());
                }
                return null;
            }
        };
    }

    public static SingleValueFunction<Object, Object> createIndexFn(final String _slotName) {
        return new SingleValueFunction<Object, Object>(){

            public Object getValue(Object _data) {
                IRSDatum datum;
                if (_data instanceof IRSDataPoint && (datum = ((IRSDataPoint)_data).get(_slotName)) instanceof IRSTuple) {
                    return String.valueOf(((IRSTuple)datum).getIndex());
                }
                return null;
            }
        };
    }

    public static List<Object> createCatDomain(IRSSlot _slot) {
        return Rave2Common.mapTuples(_slot, tup -> String.valueOf(tup.getIndex()));
    }

    public static List<Object> mapTuples(IRSSlot _slot, Function<IRSTuple, Object> _mapFunc) {
        IRSDataItem dataItem = _slot.getDataItem();
        if (dataItem == null) {
            return null;
        }
        IRSCatDataItem catDataItem = dataItem.asCat();
        if (catDataItem == null) {
            return null;
        }
        return catDataItem.getTuples().stream().map(_mapFunc).collect(Collectors.toList());
    }

    public static CustomFormatter createTupleFormatter(IRSSlot _slot) {
        final IRSCatDataItem dataItem = _slot.getDataItem().asCat();
        return new CustomFormatter(){

            public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                if (_value instanceof String) {
                    try {
                        int tupleIndex = Integer.parseInt((String)_value);
                        IRSTuple tuple = dataItem.getTuple(tupleIndex);
                        if (tuple != null) {
                            return tuple.getCaption(RSFormatKind.Label);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return "";
            }
        };
    }

    public static CustomFormatter createTupleFormatterByKey(IRSSlot _slot) {
        final IRSCatDataItem dataItem = _slot.getDataItem().asCat();
        return new CustomFormatter(){

            public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                if (_value instanceof String) {
                    IRSTuple matchingTuple = null;
                    List tuples = dataItem.getTuples();
                    int l = tuples.size();
                    for (int i = 0; i < l; ++i) {
                        IRSTuple tuple = (IRSTuple)tuples.get(i);
                        if (!tuple.getKey().equals(_value)) continue;
                        matchingTuple = tuple;
                        break;
                    }
                    if (matchingTuple != null) {
                        return matchingTuple.getCaption(RSFormatKind.Label);
                    }
                }
                return "";
            }
        };
    }

    public static boolean getDecorationBool(IRSDecorated _d, String _name) {
        if (_d == null) {
            return false;
        }
        Object result = _d.getDecoration(_name, (Object)false);
        return result instanceof Boolean ? (Boolean)result : false;
    }

    public static String colorToString(Object _color) {
        if (_color == null) {
            return "";
        }
        return _color.toString();
    }

    public static AbstractScale<Object, Object> contPaletteToScale(IRSContPaletteProperty _contPalette, IRSContDataItem _dataItem) {
        ArrayList<Number> domain = new ArrayList<Number>();
        ArrayList<String> range = new ArrayList<String>();
        IRSContStops stops = _contPalette.getColorStops(_dataItem);
        for (IRSColorStop stop : stops.getAligned()) {
            domain.add(stop.getValue());
            range.add(stop.getColor().toString());
        }
        if (stops.mustInterpolate()) {
            return Rave.scale.linear().range(range).domain(domain);
        }
        return Rave.scale.quantize().range(range).domain(domain);
    }

    public static AbstractScale<Object, Object> catPaletteToScale(IRSCatPaletteProperty _catPalette, IRSCatDataItem _dataItem) {
        if (_dataItem == null || _dataItem.getTupleCount() == 0) {
            return Rave.scale.ordinal().range(Arrays.asList(_catPalette.getColor(null)));
        }
        ArrayList<String> domain = new ArrayList<String>();
        ArrayList<String> range = new ArrayList<String>();
        for (IRSTuple tuple : _dataItem.getTuples()) {
            domain.add(tuple.getKey());
            range.add(_catPalette.getColor(tuple).toString());
        }
        return Rave.scale.ordinal().range(range).domain(domain);
    }

    public static PercentageFormatter createPercentageFormatter(int _minFractionDigits, int _maxFractionDigits, Locale _locale) {
        if (_minFractionDigits < 0 || _maxFractionDigits < 0) {
            throw new IllegalArgumentException("Fraction digits have to be zero or positive.");
        }
        return new PercentageFormatter(_minFractionDigits, _maxFractionDigits, _locale);
    }

    public static CustomFormatter createValueFormatter(IRSSlot _slot, RSFormatKind _format) {
        IRSDataItem dataItem = _slot.getDataItem();
        if (dataItem == null) {
            return null;
        }
        IRSContDataItem contDataItem = dataItem.asCont();
        if (contDataItem == null) {
            return null;
        }
        final IRSFormatter formatter = contDataItem.getFormatter(_format);
        return new CustomFormatter(){

            public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
                return formatter.format(_value);
            }
        };
    }

    public static Double calculatePixelSize(Object _cssValue, double _extent) {
        return CSSConverter.convertCSSSizeToPixelNumber((Object)_cssValue, (double)_extent, (double)10.0);
    }

    public static String translate(double _x, double _y) {
        return "translate(" + _x + ", " + _y + ")";
    }

    private static Double cssSizeToPixel(String _size) {
        return CSSConverter.convertCSSSizeToPixelNumber((Object)_size, (double)100.0, (double)16.0);
    }

    public static OMap<String, Object> composeFontStyleProperty(Font _font, IRSColor _color) {
        OMap object = new OMap();
        if (_font != null) {
            if (_font.family != null) {
                object.put((Object)"font-family", (Object)_font.familyCss());
            }
            if (_font.size != null) {
                object.put((Object)"font-size", (Object)Rave2Common.cssSizeToPixel(_font.sizeCss()));
            }
            if (_font.style != null) {
                object.put((Object)"font-style", (Object)_font.styleCss());
            }
            if (_font.weight != null) {
                object.put((Object)"font-weight", (Object)_font.weightCss());
            }
        }
        if (_color != null) {
            object.put((Object)"fill", (Object)_color.toString());
        }
        return object;
    }

    public static String composeFontStylePropertyString(Font _font, IRSColor _color) {
        StringBuilder styleFont = new StringBuilder();
        if (_font != null) {
            String cssPart = _font.familyCss();
            if (cssPart.length() > 0) {
                styleFont.append("font-family:");
                styleFont.append(cssPart);
                styleFont.append(";");
            }
            if ((cssPart = _font.sizeCss()).length() > 0) {
                styleFont.append("font-size:");
                styleFont.append(Rave2Common.cssSizeToPixel(cssPart));
                styleFont.append(";");
            }
            if ((cssPart = _font.styleCss()).length() > 0) {
                styleFont.append("font-style:");
                styleFont.append(cssPart);
                styleFont.append(";");
            }
            if ((cssPart = _font.weightCss()).length() > 0) {
                styleFont.append("font-weight:");
                styleFont.append(cssPart);
                styleFont.append(";");
            }
        }
        if (_color != null) {
            styleFont.append("fill:");
            styleFont.append(_color.toString());
            styleFont.append(";");
        }
        return styleFont.toString();
    }

    public static RunFunction<Selector> createLabelStyleFn(Font _defaultFont, Font _mergeFont) {
        Font mergedFont = Font.merge((Font)_defaultFont, (Font)_mergeFont);
        final OMap<String, Object> styles = Rave2Common.composeFontStyleProperty(mergedFont, null);
        return new RunFunction<Selector>(){

            public Object run(Selector _selection, Object ... args) {
                _selection.style(styles);
                return null;
            }
        };
    }

    public static String svgRef(String _id) {
        return "url(#" + _id + ")";
    }

    public static RunFunction<Selector> textShadow(final int _offsetX, final int _offsetY, final int _blur, final Color _color) {
        return new RunFunction<Selector>(){

            public Object run(Selector context, Object ... args) {
                context.style("text-shadow", (Object)(_offsetX + "px " + _offsetY + "px " + _blur + "px " + _color.toString()));
                return null;
            }
        };
    }

    public static Color desaturateColor(Color _color) {
        if (_color == null) {
            return null;
        }
        HSL hsl = Rave.hsl((Object)_color);
        return Rave.hsl((double)hsl.getH(), (double)0.0, (double)hsl.getL());
    }

    public static Color applyLightnessToColor(Color _color, float _percentage) {
        if (_color == null) {
            return null;
        }
        HSL hsl = Rave.hsl((Object)_color);
        return Rave.hsl((double)hsl.getH(), (double)hsl.getS(), (double)(hsl.getL() * (double)_percentage));
    }

    public static double calculateContrastRatio(Color _foreground, Color _background) {
        double backgroundLuminance;
        double foregroundLuminance = _foreground.getLuminance();
        return foregroundLuminance >= (backgroundLuminance = _background.getLuminance()) ? (foregroundLuminance + 0.05) / (backgroundLuminance + 0.05) : (backgroundLuminance + 0.05) / (foregroundLuminance + 0.05);
    }

    public static Color contrastColorAccessibility(Color _color, Color _background) {
        double contrastRatio = Rave2Common.calculateContrastRatio(_color, _background);
        if (contrastRatio < 4.5) {
            return Rave2Common.contrastColor(_color, _background, 4.5);
        }
        return _color;
    }

    public static Color contrastColor(Color _color, Color _background, double _contrastRatio) {
        return Rave.rgb((Object)_background).contrastShift((Object)_color, _contrastRatio);
    }

    public static List<String> labelFormat(String _string, int _maxLength, int _maxLines) {
        if (_string.length() > _maxLength) {
            String[] split = _string.split(" ");
            int curline = 0;
            ArrayList<String> multiline = new ArrayList<String>();
            boolean numberOfLinesExceeded = false;
            multiline.add("");
            for (int i = 0; i < split.length; ++i) {
                if (((String)multiline.get(curline)).length() + split[i].length() > _maxLength) {
                    if (curline == _maxLines - 1) {
                        multiline.set(curline, (String)multiline.get(curline) + (((String)multiline.get(curline)).length() == 0 ? "" : " ") + split[i]);
                        numberOfLinesExceeded = true;
                        break;
                    }
                    ++curline;
                    multiline.add("");
                }
                multiline.set(curline, (String)multiline.get(curline) + (((String)multiline.get(curline)).length() == 0 ? "" : " ") + split[i]);
            }
            if (((String)multiline.get(multiline.size() - 1)).length() > _maxLength) {
                multiline.set(multiline.size() - 1, ((String)multiline.get(multiline.size() - 1)).substring(0, _maxLength - 1) + "\u2026");
            } else if (numberOfLinesExceeded) {
                multiline.set(multiline.size() - 1, ((String)multiline.get(multiline.size() - 1)).substring(0, ((String)multiline.get(multiline.size() - 1)).length() - 1) + "\u2026");
            }
            return multiline;
        }
        return Arrays.asList(_string);
    }

    public static double evaluateSize(String _cssValue, double _extent) {
        double pixelSize = Rave2Common.calculatePixelSize(_cssValue, _extent);
        return Math.max(0.0, Math.min(pixelSize, _extent));
    }

    public static double calculatePixelSize(String _cssValue, double _extent) {
        Length length = Length.parse((String)_cssValue);
        return length.calculatePx(_extent, 10.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CSSStyleSheet loadCss(String _css, ClassLoader _classLoader) {
        try (Scanner scanner = null;){
            InputStream stream = _classLoader.getResourceAsStream(_css);
            if (stream != null && (scanner = new Scanner(stream).useDelimiter("$^")).hasNext()) {
                CSSStyleSheet cSSStyleSheet = Rave.css.importCSS(scanner.next());
                return cSSStyleSheet;
            }
        }
        return null;
    }

    public static void removeCss(CSSStyleSheet _styleSheet) {
        if (_styleSheet != null) {
            Rave.css.removeStyleSheet(_styleSheet);
        }
    }

    public static IRSTuple findTuple(IRSSlot _slot, Object _key) {
        for (IRSTuple tuple : _slot.getDataItem().asCat().getTuples()) {
            if (!tuple.getKey().equals(_key)) continue;
            return tuple;
        }
        return null;
    }

    private static FontSize parseFontString(String _fontSize) {
        int l;
        if (_fontSize == null || "".equals(_fontSize)) {
            return null;
        }
        int unitStart = l = _fontSize.length();
        for (int i = 0; i < l; ++i) {
            char ch = _fontSize.charAt(i);
            if (Character.isDigit(ch) || ch == '.') continue;
            unitStart = i;
            break;
        }
        double value = 0.0;
        try {
            value = Double.parseDouble(_fontSize.substring(0, unitStart));
        }
        catch (NumberFormatException e) {
            return null;
        }
        String unit = _fontSize.substring(unitStart);
        if ("".equals(unit)) {
            unit = "px";
        }
        return new FontSize(value, unit);
    }

    public static String getAbsoluteFontSize(String _baseFontSize, String _fontSize, String _remSize) {
        FontSize baseFontSize = Rave2Common.parseFontString(_baseFontSize);
        FontSize fontSize = Rave2Common.parseFontString(_fontSize);
        FontSize remSize = Rave2Common.parseFontString(_remSize);
        baseFontSize = baseFontSize == null ? remSize : remSize.apply(baseFontSize, remSize);
        if (fontSize == null) {
            return baseFontSize.toString();
        }
        return baseFontSize.apply(fontSize, remSize).toString();
    }

    public static String getAbsoluteFontSize(String _baseFontSize, String _fontSize) {
        return Rave2Common.getAbsoluteFontSize(_baseFontSize, _fontSize, "10px");
    }

    public static boolean isDarkColor(Color _color) {
        return Rave2Common.isDarkColor(_color, 0.5);
    }

    public static boolean isDarkColor(Color _color, double _cutOffPoint) {
        if (_color == null) {
            return false;
        }
        RGB rgb = Rave.rgb((Object)_color);
        if (rgb.getA() == 0.0) {
            return false;
        }
        double brightness = 0.33 * (double)(rgb.getR() / 255) + 0.5 * (double)(rgb.getG() / 255) + 0.16 * (double)(rgb.getB() / 255);
        return brightness < _cutOffPoint;
    }

    private static class FontSize {
        final double value;
        final String unit;
        final boolean absolute;

        FontSize(double _value, String _unit) {
            this.value = _value;
            this.unit = _unit.toLowerCase();
            this.absolute = !_unit.equals("em") && !_unit.equals("%") && !_unit.equals("rem");
        }

        FontSize apply(FontSize _size, FontSize _remSize) {
            if (_size == null) {
                return this;
            }
            if (_size.absolute) {
                return _size;
            }
            FontSize base = _size.unit.equals("rem") ? _remSize : this;
            double factor = _size.unit.equals("em") || _size.unit.equals("rem") ? _size.value : _size.value / 100.0;
            return new FontSize(base.value * factor, base.unit);
        }

        public String toString() {
            return this.value + this.unit;
        }
    }

    private static class PercentageFormatter
    extends CustomFormatter
    implements IRSFormatter {
        private final NumberFormat formatter;

        public PercentageFormatter(int _minFractionDigits, int _maxFractionDigits, Locale _locale) {
            this.formatter = NumberFormat.getPercentInstance(_locale);
            this.formatter.setMinimumFractionDigits(_minFractionDigits);
            this.formatter.setMaximumFractionDigits(_maxFractionDigits);
        }

        public String getValue(Object _context, Object _value, int _index, int _groupIndex, CustomFormatInfo _info, boolean _simplified) {
            return this.formatter.format((Double)_value);
        }

        public String format(Object _value) {
            return this.formatter.format(_value);
        }
    }
}

