/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2;

import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.vida.rave.bundles.RaveBundle;
import com.ibm.vida.rave.bundles.nativeImpl.BundleLookup;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.core.functions.TwoParamValueFunction;
import com.ibm.vida.rave.core.layout.Node;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selection;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.ext.axis.RaveAxis;
import com.ibm.vida.rave.ext.position.RavePosition;
import com.ibm.vida.rave.ext.symbol.RaveSymbol;
import com.ibm.vida.rave.ext.text.TextExtensions;
import com.ibm.vida.rave.library.Library;
import com.ibm.vida.rave.library.action.Action;
import com.ibm.vida.rave.library.framework.Controller;
import com.ibm.vida.rave.library.framework.CoordinateScale;
import com.ibm.vida.rave.library.framework.CustomFormatter;
import com.ibm.vida.rave.library.framework.RenderCompleteCallback;
import com.ibm.vida.vizbundles.common.AxisRole;
import com.ibm.vida.vizbundles.common.groupproperties.AxisProperty;
import com.ibm.vida.vizbundles.common.groupproperties.AxisScaleProperty;
import com.ibm.vida.vizbundles.common.rave2.VidaRenderingServiceLegendBase;
import com.ibm.vida.vizbundles.common.rave2bundle.DataHandlingEnum;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleCustomFormatterTarget;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleDataModel;
import com.ibm.vipr.renderingservice.api.IInteractivity;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSColorStop;
import com.ibm.vipr.renderingservice.api.IRSDataContext;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.api.IRSInitializationParameters;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.IRenderingService;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class VidaRaveBundleRenderingServiceBase
extends VidaRenderingServiceLegendBase {
    private static final double MIN_VISUALIZATION_WIDTH = 180.0;
    private static final double MIN_VISUALIZATION_HEIGHT = 90.0;
    private final String raveBundleName;
    private final String dataModelName;
    private final String cssClass;
    private final String cssFileName;
    protected IRave2BundleWrapper raveBundle;
    private Rave2BundleDataModel dataModel;
    private HashMap<String, List<SingleValueFunction<?, IRSDataNode>>> hittesters;
    private HashMap<String, List<TwoParamValueFunction<?, IRSDataNode, Node>>> decorators;
    private HashSet<String> palettes;
    protected IRSProperties _properties;
    protected IRSDataContext _dataContext;

    protected VidaRaveBundleRenderingServiceBase(String _raveBundleName, String _dataModelName, String _cssClass, String _cssFileName) {
        this.raveBundleName = _raveBundleName;
        this.dataModelName = _dataModelName;
        this.cssClass = _cssClass;
        this.cssFileName = _cssFileName;
    }

    public final void init(IRSInitializationParameters _params, IRSHostAPI _hostApi, Map<String, Object> _resources, IRenderingService.IInitCompleteCallback _initComplete, IRenderingService.IInitFailedCallback _initFailed) {
        try {
            this._properties = _params.getProperties();
            this._dataContext = _params.getDataContext();
            ArrayList<String> cssFiles = new ArrayList<String>();
            if (this.cssFileName != null) {
                cssFiles.add(this.cssFileName);
            }
            this.initRaveSurface(_params.getRenderSurface(), _params.getFormat(), cssFiles);
            RaveBundle raveBundle = BundleLookup.getBundle((String)this.raveBundleName);
            if (raveBundle == null) {
                throw new Exception("Cannot load bundle " + this.raveBundleName);
            }
            this.raveBundle = new VidaRave2BundleWrapper(raveBundle.create());
            this.raveBundle.getBundle().node(this.getBundleRoot().attr("class", (Object)this.cssClass));
            this.dataModel = Rave2BundleDataModel.create(this.raveBundle.getBundle().createDataModel(this.dataModelName));
            this.raveBundle.setProperty("legend.display", false);
            this.hittesters = new HashMap();
            this.decorators = new HashMap();
            this.palettes = new HashSet();
            this._init(_params, _hostApi, _resources);
            _initComplete.call();
        }
        catch (Throwable thr) {
            _initFailed.call(thr);
        }
    }

    @Override
    protected void _initRaveExtensions() {
        RaveAxis.init();
        RavePosition.init();
        TextExtensions.init();
        RaveSymbol.init();
    }

    protected void postProcessSceneTree(RenderCompleteCallback _notification) throws Exception {
        _notification.renderComplete();
    }

    public abstract void _init(IRSInitializationParameters var1, IRSHostAPI var2, Map<String, Object> var3) throws Exception;

    @Override
    public void _destroy() {
        if (this.raveBundle != null) {
            this.raveBundle.destroy();
            this.raveBundle = null;
        }
    }

    @Override
    protected IRSProperties getProperties() {
        return this._properties;
    }

    @Override
    protected double getMinimalVisualizationWidth() {
        return 180.0;
    }

    @Override
    protected double getMinimalVisualizationHeight() {
        return 90.0;
    }

    @Override
    protected boolean mustCreateDefaultBundleClipPath() {
        return false;
    }

    public class VidaRave2BundleWrapper
    implements IRave2BundleWrapper {
        final Controller controller;

        VidaRave2BundleWrapper(Controller _controller) {
            this.controller = _controller;
        }

        @Override
        public void destroy() {
            this.controller.dispose();
        }

        @Override
        public Controller getBundle() {
            return this.controller;
        }

        @Override
        public Bounds getBounds() {
            Selector rootSelector = VidaRaveBundleRenderingServiceBase.this.getBundleRoot();
            return Bounds.fromXYWH((Number)((Number)rootSelector.attr("x")), (Number)((Number)rootSelector.attr("y")), (Number)((Number)rootSelector.attr("width")), (Number)((Number)rootSelector.attr("height")));
        }

        @Override
        public Bounds getSize() {
            Dimension dim = VidaRaveBundleRenderingServiceBase.this.getDimension();
            return Bounds.fromXYWH((double)0.0, (double)0.0, (double)dim.getWidth(), (double)dim.getHeight());
        }

        @Override
        public void setAttribute(String _name, Object _value) {
            this.controller.node().attr(_name, _value);
        }

        @Override
        public Rave2BundleDataModel getDataModel() {
            return VidaRaveBundleRenderingServiceBase.this.dataModel;
        }

        @Override
        public boolean hasSelection() {
            return VidaRaveBundleRenderingServiceBase.this.dataModel.hasSelection();
        }

        @Override
        public List<IRSDataPoint> getSelection() {
            return VidaRaveBundleRenderingServiceBase.this.dataModel.getSelection();
        }

        @Override
        public void setCustomFormatter(Rave2BundleCustomFormatterTarget _target, CustomFormatter _formatter) {
            String targetName = _target.name();
            if (_formatter == null) {
                this.controller.removeCustomFormatter(targetName);
            } else {
                this.controller.setCustomFormatter(targetName, _formatter);
            }
        }

        @Override
        public void removeCustomFormatter(Rave2BundleCustomFormatterTarget _target) {
            this.controller.removeCustomFormatter(_target.name());
        }

        @Override
        public void render(IRSProperties _properties, IRSRenderNotification _notification) {
            try {
                Selector rootSelector = VidaRaveBundleRenderingServiceBase.this.getBundleRoot();
                Bounds size = this.getSize();
                rootSelector.attr("width", (Object)size.getWidth()).attr("height", (Object)size.getHeight());
                this.getBundle().render(() -> {
                    try {
                        VidaRaveBundleRenderingServiceBase.this.postProcessSceneTree(() -> _notification.complete());
                    }
                    catch (Exception e) {
                        _notification.error((Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                _notification.error((Throwable)e);
            }
        }

        @Override
        public void setProperty(String _name, Object _value) {
            this.controller.property(_name, _value);
        }

        @Override
        public void disableAction(String _name) {
            this.controller.action(_name).autoBind(false);
        }

        @Override
        public Action getAction(String _name) {
            return this.controller.action(_name);
        }

        @Override
        public void createCatPalette(String _id, List<IRSColor> _colorValues) {
            JSONObject palette = new JSONObject();
            JSONArray fills = new JSONArray();
            for (IRSColor color : _colorValues) {
                fills.add((Object)color.toString());
            }
            palette.put((Object)"id", (Object)_id);
            palette.put((Object)"label", (Object)"Bundle Palette");
            palette.put((Object)"description", (Object)"A bundle palette");
            palette.put((Object)"icon", null);
            palette.put((Object)"fillType", (Object)"simple");
            palette.put((Object)"fills", (Object)fills);
            Library.palettes.addPalette(palette);
            if (!VidaRaveBundleRenderingServiceBase.this.palettes.contains(_id)) {
                VidaRaveBundleRenderingServiceBase.this.palettes.add(_id);
            }
        }

        @Override
        public void createContPalette(String _id, List<IRSColorStop> _stops) {
            JSONArray fills = new JSONArray();
            for (IRSColorStop colorStop : _stops) {
                JSONObject stop = new JSONObject();
                stop.put((Object)"at", (Object)colorStop.getAt().doubleValue());
                stop.put((Object)"fill", (Object)colorStop.getColor().toString());
                fills.add((Object)stop);
            }
            JSONObject palette = new JSONObject();
            palette.put((Object)"id", (Object)_id);
            palette.put((Object)"label", (Object)"Bundle Palette");
            palette.put((Object)"description", (Object)"A bundle palette");
            palette.put((Object)"icon", null);
            palette.put((Object)"fillType", (Object)"continuous");
            palette.put((Object)"valueType", (Object)"normalized");
            palette.put((Object)"fills", (Object)fills);
            Library.palettes.addPalette(palette);
            if (!VidaRaveBundleRenderingServiceBase.this.palettes.contains(_id)) {
                VidaRaveBundleRenderingServiceBase.this.palettes.add(_id);
            }
        }

        @Override
        public void mapAxisScaleProperties(AxisRole _axisRole, AxisScaleProperty _axisScaleProperty) {
            String axisName = this.getAxisPrefix(_axisRole);
            String prefix = "axis." + axisName + ".scale";
            this.setProperty(prefix + ".tickInterval", _axisScaleProperty.tickInterval());
            this.setProperty(prefix + ".min", _axisScaleProperty.minValue());
            this.setProperty(prefix + ".max", _axisScaleProperty.maxValue());
            this.setProperty(prefix + ".nice", _axisScaleProperty.niceScale());
            this.setProperty(prefix + ".includeZero", _axisScaleProperty.zeroOrigin());
            this.setProperty(prefix + ".log", _axisScaleProperty.logarithmic());
        }

        @Override
        public void mapAxisProperties(AxisRole _axisRole, AxisProperty _axisProperty) {
            String axisName = this.getAxisPrefix(_axisRole);
            String prefix = "axis." + axisName;
            this.setProperty(prefix + ".labels.layoutMode", _axisProperty.tickLabelMode());
            if (_axisRole == AxisRole.X1) {
                this.setProperty(prefix + ".labels.rotateAngle", _axisProperty.tickLabelRotateAngle());
            }
            this.setProperty(prefix + ".line.display", _axisProperty.showLine());
            this.setProperty(prefix + ".line.style.stroke", _axisProperty.lineColor());
            this.setProperty(prefix + ".gridlines.display", _axisProperty.showGridLines());
            this.setProperty(prefix + ".gridlines.style.stroke", _axisProperty.gridLineColor());
            this.setProperty(prefix + ".gridlines.style.stroke-dasharray", _axisProperty.gridPattern());
            this.setProperty(prefix + ".ticks.display", _axisProperty.showTicks());
            this.setProperty(prefix + ".ticks.style.stroke", _axisProperty.tickColor());
            this.setProperty(prefix + ".title.style.font", _axisProperty.titleFontCssString());
            this.setProperty(prefix + ".labels.style.font", _axisProperty.tickLabelFontCssString());
            this.setProperty(prefix + ".title.text", _axisProperty.title());
            this.setProperty(prefix + ".title.display", _axisProperty.showTitle());
            this.setProperty(prefix + ".labels.display", _axisProperty.showTickLabels());
        }

        private String getAxisPrefix(AxisRole _axisRole) {
            switch (_axisRole) {
                case X1: {
                    return "x";
                }
                case X2: {
                    return "x2";
                }
                case Y1: {
                    return "y";
                }
                case Y2: {
                    return "y2";
                }
            }
            return "";
        }

        @Override
        public void addHittester(String _cssSelector, SingleValueFunction<?, IRSDataNode> _function) {
            if (!VidaRaveBundleRenderingServiceBase.this.hittesters.containsKey(_cssSelector)) {
                ((List)VidaRaveBundleRenderingServiceBase.this.hittesters.get(_cssSelector)).add(_function);
            } else {
                VidaRaveBundleRenderingServiceBase.this.hittesters.put(_cssSelector, Arrays.asList(_function));
            }
        }

        @Override
        public void clearHittesters() {
            VidaRaveBundleRenderingServiceBase.this.hittesters.clear();
        }

        @Override
        public void addDecorator(String _cssSelector, TwoParamValueFunction<?, IRSDataNode, Node> _function) {
            if (VidaRaveBundleRenderingServiceBase.this.decorators.containsKey(_cssSelector)) {
                ((List)VidaRaveBundleRenderingServiceBase.this.decorators.get(_cssSelector)).add(_function);
            } else {
                VidaRaveBundleRenderingServiceBase.this.decorators.put(_cssSelector, Arrays.asList(_function));
            }
        }

        @Override
        public void addRenderCallback(RunFunction<Selection<?>> _callback) {
            this.controller.renderCallback(_callback);
        }

        @Override
        public IInteractivity getInteractivity() {
            return null;
        }

        @Override
        public Selector getItemsByCssSelector(String _cssSelector) {
            return this.controller.node().selectAll(_cssSelector);
        }

        @Override
        public void updateDecorations() {
        }

        @Override
        public void setDataModel(DataHandlingEnum _dataHandling) {
            VidaRaveBundleRenderingServiceBase.this.dataModel.setDataModel(this.controller.createDataModel(_dataHandling.toString()));
        }

        @Override
        public CoordinateScale getCoordinateScale(String _role) {
            return this.controller.getCoordinateScale(_role);
        }
    }
}

