/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2;

import com.ibm.vida.rave.awt.RavePanel;
import com.ibm.vida.rave.awt.internal.service.context.AWTRaveImageServiceContextManager;
import com.ibm.vida.rave.awt.service.AWTRaveImageServiceRootProvider;
import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.context.RaveOperationalMode;
import com.ibm.vida.rave.core.css.CSSStyleSheet;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.render.internal.nodes.RootProvider;
import com.ibm.vida.vizbundles.common.rave2.BundleImageService;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vipr.renderingservice.api.IInteractivity;
import com.ibm.vipr.renderingservice.api.IRSCapability;
import com.ibm.vipr.renderingservice.api.IRSEncoding;
import com.ibm.vipr.renderingservice.api.IRSPoint;
import com.ibm.vipr.renderingservice.api.IRSRenderInvalidation;
import com.ibm.vipr.renderingservice.api.IRSRenderNotification;
import com.ibm.vipr.renderingservice.api.IRenderSurface;
import com.ibm.vipr.renderingservice.api.IRenderingService;
import com.ibm.vipr.renderingservice.property.IRSPropertyApi;
import com.ibm.vipr.renderingservice.util.Region;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class VidaRenderingServiceBase
implements IRenderingService {
    private static final String INVALID_IMAGE_RENDERING_STATE = "Rave cannot render client after being set to image mode";
    private static final String FORMAT_ERROR = "Invalid format";
    private static final String INVALID_FORMAT = "Initialized format does not match rendered format";
    private final long uniqueBundleId = Rave2Common.createUniqueId();
    private SceneNode node;
    private List<CSSStyleSheet> styleSheets;
    protected RootProvider rootProvider;
    protected final Map<String, Region> regions = new HashMap<String, Region>();
    protected String format;
    protected IRenderSurface surface;
    private Container _container;
    private RavePanel _ravePanel;

    public VidaRenderingServiceBase() {
        this.styleSheets = new ArrayList<CSSStyleSheet>();
    }

    public final void destroy() {
        this._destroy();
        if (this._container != null && this._ravePanel != null) {
            this._container.remove((Component)this._ravePanel);
            this._ravePanel.dispose();
        }
        this.styleSheets.forEach(Rave2Common::removeCss);
        if (RaveOperationalMode.MODE == 1) {
            AWTRaveImageServiceRootProvider provider = (AWTRaveImageServiceRootProvider)this.rootProvider;
            if (provider != null) {
                provider.dispose();
            }
            this.rootProvider = null;
            AWTRaveImageServiceContextManager.getInstance().disposeContext();
        }
    }

    public long getUniqueBundleId() {
        return this.uniqueBundleId;
    }

    protected Selector initRaveSurface(IRenderSurface _surface, String _format, List<String> _cssFiles) throws Exception {
        this.surface = _surface;
        this.format = _format;
        if (_format.equals("image")) {
            RaveOperationalMode.MODE = 1;
            AWTRaveImageServiceContextManager.getInstance().createContext();
            this.rootProvider = new AWTRaveImageServiceRootProvider("root" + this.getUniqueBundleId(), _surface.getWidth(), _surface.getHeight());
            this.node = this.rootProvider.getRoot();
        } else {
            if (RaveOperationalMode.MODE == 1) {
                throw new Exception(INVALID_IMAGE_RENDERING_STATE);
            }
            this._ravePanel = new RavePanel("bundle", _surface.getWidth(), _surface.getHeight());
            this._ravePanel.setBackground(Color.WHITE);
            this._ravePanel.setFocusable(true);
            this._ravePanel.setFocusTraversalKeysEnabled(false);
            this._container = (Container)_surface.getSurface();
            this._container.setLayout(new BorderLayout());
            this._container.add((Component)this._ravePanel, "Center");
            this._container.validate();
            this.node = this._ravePanel.getRootNode();
            this.rootProvider = null;
        }
        this._loadCss(_cssFiles);
        this._initRaveExtensions();
        return Rave.select((SceneNode)this.node);
    }

    public Selector getBundleRoot() {
        return Rave.select((SceneNode)this.node);
    }

    protected Dimension getDimension() {
        return new Dimension(this.surface.getWidth(), this.surface.getHeight());
    }

    private void _loadCss(List<String> _cssFiles) {
        ClassLoader loader = this.getClass().getClassLoader();
        this.styleSheets.add(Rave2Common.loadCss("vidabundle.css", loader));
        for (String cssFile : _cssFiles) {
            this.styleSheets.add(Rave2Common.loadCss(cssFile, loader));
        }
    }

    public final void render(String _format, IRSRenderInvalidation _invalidation, IRSRenderNotification _notification) {
        if (!_format.equals(this.format)) {
            _notification.fail(FORMAT_ERROR, INVALID_FORMAT, null);
            return;
        }
        switch (_format) {
            case "client": {
                Rave.timer.addEvent(_elapsed -> {
                    try {
                        this.beforeRender(_invalidation, this.surface.getWidth(), this.surface.getHeight());
                        this.render(_invalidation, _notification);
                    }
                    catch (Exception ex) {
                        _notification.error((Throwable)ex);
                    }
                    return true;
                });
                break;
            }
            case "image": {
                this.beforeRender(_invalidation, this.surface.getWidth(), this.surface.getHeight());
                this.render(_invalidation, new BundleImageService(this.rootProvider, _notification));
                AWTRaveImageServiceContextManager.getInstance().flushAllTimerEvents();
                break;
            }
            default: {
                _notification.error((Throwable)new Error(FORMAT_ERROR));
            }
        }
    }

    public IRSPropertyApi getPropertyApi() {
        return null;
    }

    public List<IRSEncoding> getEncodings() {
        return Collections.emptyList();
    }

    public List<IRSCapability> getCapabilities() {
        return Collections.emptyList();
    }

    public IInteractivity getInteractivity() {
        return null;
    }

    protected void beforeRender(IRSRenderInvalidation _invalidation, double _width, double _height) {
        Rave.select((SceneNode)this.node).attr("width", (Object)_width);
        Rave.select((SceneNode)this.node).attr("height", (Object)_height);
    }

    public abstract void render(IRSRenderInvalidation var1, IRSRenderNotification var2);

    protected abstract void _initRaveExtensions();

    protected abstract void _destroy();

    public List<Region> getRegionAtPoint(IRSPoint _viewPortPoint) {
        ArrayList<Region> result = new ArrayList<Region>();
        for (Region region : this.regions.values()) {
            if (!region.getBounds().containsPointXY(_viewPortPoint.getX(), _viewPortPoint.getY())) continue;
            result.add(region);
        }
        return result;
    }

    public Region createRegion(String _name, List<String> _slots) {
        Region region = new Region(_name, _slots);
        this.regions.put(_name, region);
        return region;
    }

    public Region getRegion(String _name) {
        return this.regions.get(_name);
    }
}

