/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2.legend;

import com.ibm.vida.rave.core.geom.Dim;
import com.ibm.vida.rave.core.geom.Insets;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.ext.legend.AbstractLegend;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2.legend.ILegend;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendOrientation;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.FontWeight;
import com.ibm.vipr.renderingservice.property.Length;
import com.ibm.vipr.renderingservice.util.ColorUtil;

public abstract class RaveLegend
implements ILegend {
    public static final Font defaultTitleFont = Font.create(null, (Length)Length.parse((String)"12px"), null, (FontWeight)FontWeight.Bold);
    public static final IRSColor defaultTitleFontColor = ColorUtil.rgb((int)106, (int)115, (int)115);
    public static final Font defaultEntryFont = Font.create(null, (Length)Length.parse((String)"0.75em"), null, null);
    public static final IRSColor defaultEntryFontColor = ColorUtil.rgb((int)106, (int)115, (int)115);
    protected Insets titleInsets = new Insets();
    protected Insets legendInsets;
    protected Insets entryInsets;
    protected LegendOrientation orientation;
    protected String title;
    protected OMap<String, Object> titleStyle;
    protected OMap<String, Object> entryStyle;
    protected double tX;
    protected double tY;

    public RaveLegend() {
        this.titleInsets.bottom = 0;
        this.titleInsets.top = 0;
        this.titleInsets.left = 0;
        this.titleInsets.right = 0;
        this.legendInsets = new Insets();
        this.entryInsets = new Insets();
        this.entryInsets.left = 0;
        this.entryInsets.top = 0;
        this.entryInsets.right = 4;
        this.entryInsets.bottom = 2;
        this.titleStyle = Rave2Common.composeFontStyleProperty(defaultTitleFont, defaultTitleFontColor);
        this.entryStyle = Rave2Common.composeFontStyleProperty(defaultEntryFont, defaultEntryFontColor);
    }

    public ILegend setOrientation(LegendOrientation _orientation) {
        if (_orientation == LegendOrientation.Horizontal) {
            this.legendInsets.left = 8;
            this.legendInsets.right = 8;
            this.legendInsets.bottom = 0;
            this.legendInsets.top = 1;
        } else {
            this.legendInsets.top = 8;
            this.legendInsets.bottom = 8;
            this.legendInsets.left = 0;
            this.legendInsets.right = 0;
        }
        return this;
    }

    @Override
    public ILegend setDimensions(double _width, double _height) {
        AbstractLegend<?> legend = this.getRaveImpl();
        if (legend != null) {
            legend.size(new Dim(_width, _height));
        }
        return this;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public ILegend setOrigin(double _x, double _y) {
        this.tX = _x;
        this.tY = _y;
        return this;
    }

    @Override
    public void render(Selector _node) {
        _node.attr("transform", (Object)Rave2Common.translate(this.tX, this.tY));
        if (this.getRaveImpl() != null) {
            this.applyProperties();
            _node.call(this.getRaveImpl(), new Object[0]);
        }
    }

    public void applyProperties() {
        this.getRaveImpl().titleFontStyle(this.titleStyle);
        this.getRaveImpl().entryFontStyle(this.entryStyle);
        this.getRaveImpl().title(this.title);
        if (this.entryStyle != null && this.entryStyle.get((Object)"font-size") != null) {
            Length fontSize = Length.parse((String)this.entryStyle.get((Object)"font-size").toString());
            double fontSizePx = fontSize.calculatePx(100.0, 10.0);
            this.entryInsets.bottom = ObjectConverter.toInt((Object)(fontSizePx * 0.3));
            this.entryInsets.right = ObjectConverter.toInt((Object)(fontSizePx * 0.3));
        }
        this.getRaveImpl().entryInsets(this.entryInsets);
    }

    public RaveLegend titleFont(Font _titleFont, IRSColor _titleColor) {
        this.titleStyle = Rave2Common.composeFontStyleProperty(Font.merge((Font)defaultTitleFont, (Font)_titleFont), _titleColor == null ? defaultTitleFontColor : _titleColor);
        return this;
    }

    public RaveLegend font(Font _entryFont, IRSColor _entryColor) {
        this.entryStyle = Rave2Common.composeFontStyleProperty(Font.merge((Font)defaultEntryFont, (Font)_entryFont), _entryColor == null ? defaultEntryFontColor : _entryColor);
        return this;
    }

    public RaveLegend title(String _title) {
        this.title = _title;
        return this;
    }

    public abstract AbstractLegend<?> getRaveImpl();
}

