/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2.legend;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.legend.AbstractLegend;
import com.ibm.vida.rave.ext.legend.size.NestedSizeLegend;
import com.ibm.vida.rave.ext.legend.swatch.SwatchLegend;
import com.ibm.vida.vizbundles.common.rave2.legend.ILegend;
import com.ibm.vida.vizbundles.common.rave2.legend.LegendOrientation;
import com.ibm.vida.vizbundles.common.rave2.legend.RaveLegend;
import com.ibm.vida.vizbundles.common.rave2.legend.VidaSizeRangeLegendImpl;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSContEncoding;
import com.ibm.vipr.renderingservice.data.IRSContDataItem;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.util.ColorUtil;
import java.util.Arrays;

public class RaveSizeLegend
extends RaveLegend {
    public static final String MODE_SWATCH = "categorical";
    public static final String MODE_NESTED = "nested";
    private static final int MIN_SWATCH_SIZE = 10;
    private static final int MAX_SWATCH_SIZE = 30;
    protected static IRSColor defaultStrokeColor = ColorUtil.Named.black.color;
    protected static IRSColor defaultFillColor = ColorUtil.Named.gray.color;
    protected IRSColor fillColor = defaultFillColor;
    protected IRSColor strokeColor = defaultStrokeColor;
    protected NestedSizeLegend nestedLegend;
    protected SwatchLegend swatchLegend;
    protected String mode = "categorical";

    protected static AbstractScale<Object, Object> _createLinearScale(IRSContEncoding _encoding) {
        return Rave.scale.linear().domain(Arrays.asList(_encoding.getDomain().getMin(), _encoding.getDomain().getMax())).range(Arrays.asList(100, 900));
    }

    protected static AbstractScale<Object, Object> _createSwatchScale(IRSContEncoding _encoding) {
        return Rave.scale.ordinal().domain(Arrays.asList(_encoding.getDomain().getMin(), _encoding.getDomain().getMax())).range(Arrays.asList(100, 900));
    }

    protected static ValueFunction<SceneNode, String> _createLabelFunction(final IRSContEncoding _encoding) {
        return new ValueFunction<SceneNode, String>(){

            public String getValue(SceneNode context, Object data, int index, int groupIndex) {
                if (_encoding.getRef() instanceof IRSContDataItem) {
                    IRSContDataItem item = (IRSContDataItem)_encoding.getRef();
                    return item.getFormatter(RSFormatKind.Label).format(data);
                }
                return "";
            }
        };
    }

    public RaveSizeLegend(IRSContEncoding _encoding) {
        this.create(_encoding);
    }

    public IRSColor fillColor() {
        return this.fillColor;
    }

    public RaveSizeLegend fillColor(IRSColor _fillColor) {
        this.fillColor = _fillColor;
        return this;
    }

    public IRSColor strokeColor() {
        return this.strokeColor;
    }

    public RaveSizeLegend strokeColor(IRSColor _fillColor) {
        this.strokeColor = _fillColor;
        return this;
    }

    public RaveSizeLegend mode(String _mode) {
        this.mode = _mode;
        return this;
    }

    @Override
    public AbstractLegend<?> getRaveImpl() {
        return this.mode.equals(MODE_SWATCH) ? this.swatchLegend : this.nestedLegend;
    }

    @Override
    public double getUsedSize() {
        return this.getRaveImpl().getUsedSize();
    }

    protected void create(IRSContEncoding _encoding) {
        this.nestedLegend = (NestedSizeLegend)((NestedSizeLegend)((NestedSizeLegend)((NestedSizeLegend)((NestedSizeLegend)((NestedSizeLegend)((NestedSizeLegend)((NestedSizeLegend)new NestedSizeLegend().scale(RaveSizeLegend._createLinearScale(_encoding))).title(_encoding.getCaption())).labelFormat(RaveSizeLegend._createLabelFunction(_encoding))).shapeBorderColor((Object)this.strokeColor)).titleAlignment("start")).titleInsets(this.titleInsets)).titleFontStyle(this.titleStyle)).entryFontStyle(this.entryStyle);
        this.swatchLegend = (SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)((SwatchLegend)new VidaSizeRangeLegendImpl().subCaption(_encoding.getSubCaption()).labelPadding(8)).columns((Object)2).rows((Object)2).labelFormat(RaveSizeLegend._createLabelFunction(_encoding))).scale((AbstractScale)Rave.scale.ordinal().domain(Arrays.asList(_encoding.getDomain().getMin(), _encoding.getDomain().getMax())).range(Arrays.asList(this.fillColor.toString())))).shape((Object)"circle").title(_encoding.getCaption())).titleAlignment("start")).titleInsets(this.titleInsets)).titleFontStyle(this.titleStyle)).entryFontStyle(this.entryStyle);
        this.swatchLegend.swatchSize(RaveSizeLegend._createLinearScale(_encoding));
    }

    @Override
    public ILegend setOrientation(LegendOrientation _orientation) {
        super.setOrientation(_orientation);
        if (this.nestedLegend != null) {
            this.nestedLegend.orient(_orientation.getName());
        }
        if (this.swatchLegend != null) {
            this.swatchLegend.orient(_orientation.getName());
        }
        return this;
    }
}

