/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2.legend;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.geom.Insets;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.LinearScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.legend.continuous.ContinuousLegend;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSColorStop;
import com.ibm.vipr.renderingservice.property.Length;
import java.util.List;

public class VidaContinuousLegendImpl
extends ContinuousLegend {
    private static final double MIN_GRADIENT_RECT_LONG_SIDE = 100.0;
    private static final double GRADIENT_RECT_SHORT_SIDE = 18.0;
    private static int gradientNr = 0;
    private String _subCaption = null;
    private List<IRSColorStop> _colorStops = null;

    public VidaContinuousLegendImpl subCaption(String _subCaption) {
        this._subCaption = _subCaption;
        return this;
    }

    public VidaContinuousLegendImpl colorStops(List<IRSColorStop> _colorStops) {
        this._colorStops = _colorStops;
        return this;
    }

    public void legend(Selector _parent) {
        VidaContinuousLegendImpl self = this;
        Insets entryPadding = new Insets();
        if (this.entryFontStyle() == null) {
            OMap fontMap = new OMap();
            fontMap.put((Object)"font-size", (Object)"9px");
            this.entryFontStyle(fontMap);
        }
        if (this.entryFontStyle().get((Object)"font-size") != null) {
            Length fontSize = Length.parse((String)this.entryFontStyle().get((Object)"font-size").toString());
            double fontSizePx = fontSize.calculatePx(100.0, 10.0);
            entryPadding.top = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
            entryPadding.bottom = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
            entryPadding.right = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
            entryPadding.left = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
        }
        _parent.each((context, data, index, groupIndex) -> {
            boolean isHorizontal = "horizontal".equals(self.orient());
            self._spaceUsed = 0.0;
            double availableWidth = self.size().getWidth() - (double)entryPadding.left.intValue() - (double)entryPadding.right.intValue();
            double availableHeight = self.size().getHeight() - (double)entryPadding.top.intValue() - (double)entryPadding.bottom.intValue();
            if (availableHeight <= 0.0 || availableWidth <= 0.0) {
                return;
            }
            double verticalSpaceUsed = self.insets().top.intValue();
            double horizontalSpaceUsed = self.insets().left.intValue();
            Selector gSelection = self.prepareLegendGroup((SceneNode)context);
            TextFlow textFlow = self.createTextFlowComponent().wrap(false);
            Selector gTitle = gSelection.append("g");
            if (this.title() != null && !this.title().isEmpty()) {
                Selector titleSelector = self.prepareLegendTitle(gTitle, textFlow);
                if (titleSelector != null && titleSelector.node().getParentNode() == null) {
                    return;
                }
                double titleVerticalShift = self.calculateTitleVerticalShift(titleSelector);
                verticalSpaceUsed += titleVerticalShift;
                horizontalSpaceUsed += titleSelector != null ? Rave.util.getBBox((SceneNode)titleSelector.node()).width : 0.0;
                if ((availableHeight -= verticalSpaceUsed) <= 0.0 || availableWidth <= 0.0) {
                    return;
                }
                Selector subCaption = null;
                if (this._subCaption != null && !this._subCaption.isEmpty()) {
                    subCaption = (Selector)gSelection.append("text").text((Object)this._subCaption).attr("y", (Object)(verticalSpaceUsed + (double)entryPadding.top.intValue())).attr("class", (Object)"legendLabel").style(this.entryFontStyle());
                    RaveRect subCaptionBbox = Rave.util.getBBox(subCaption.node());
                    horizontalSpaceUsed = Math.max(subCaptionBbox.width, horizontalSpaceUsed);
                    verticalSpaceUsed += (double)(entryPadding.bottom + entryPadding.top);
                }
            }
            ArrayEx domain = ((LinearScale)this.scale()).domain();
            Selector textGroup = gSelection.append("g");
            Selector fromLabel = (Selector)textGroup.append("text").datum(domain.get(0)).attr("class", (Object)"legendLabel").style(this.entryFontStyle());
            Selector toLabel = ((Selector)textGroup.append("text").datum(domain.get(domain.size() - 1)).attr("class", (Object)"legendLabel").style(this.entryFontStyle())).attr("text-anchor", (Object)(isHorizontal ? "end" : null));
            Object labelFormat = self.getLabelFormat();
            if (labelFormat instanceof ValueFunction) {
                fromLabel.text((Object)((ValueFunction)labelFormat));
                toLabel.text((Object)((ValueFunction)labelFormat));
            } else {
                fromLabel.text(labelFormat);
                toLabel.text(labelFormat);
            }
            RaveRect fromLabelRect = Rave.util.getBBox(fromLabel.node());
            RaveRect toLabelRect = Rave.util.getBBox(toLabel.node());
            double sizeShapeShortSide = Math.max(fromLabelRect.height * 1.5, 18.0);
            double sizeShapeAvailable = isHorizontal ? availableWidth : availableHeight;
            double sizeShapeLongSide = Math.max(6.0 * sizeShapeShortSide, 100.0);
            sizeShapeLongSide = Math.min(sizeShapeLongSide, sizeShapeAvailable - fromLabelRect.height);
            String gradientRef = this.defineGradient(gSelection, isHorizontal);
            Selector gradientRect = gSelection.append("rect").attr("y", (Object)(verticalSpaceUsed + (double)(entryPadding.top * 2)));
            verticalSpaceUsed += (double)(entryPadding.top * 2);
            double gradientWidth = 0.0;
            double gradientHeight = 0.0;
            if (isHorizontal) {
                gradientWidth = sizeShapeLongSide;
                gradientHeight = sizeShapeShortSide;
                gradientRect.attr("width", (Object)gradientWidth).attr("height", (Object)sizeShapeShortSide).style("fill", (Object)gradientRef);
            } else {
                gradientWidth = sizeShapeShortSide;
                gradientHeight = sizeShapeLongSide;
                gradientRect.attr("width", (Object)sizeShapeShortSide).attr("height", (Object)gradientHeight).style("fill", (Object)gradientRef);
            }
            horizontalSpaceUsed = Math.max(gradientWidth, horizontalSpaceUsed);
            verticalSpaceUsed += gradientHeight;
            if (isHorizontal) {
                fromLabel.attr("y", (Object)(verticalSpaceUsed + fromLabelRect.height + (double)entryPadding.top.intValue()));
                toLabel.attr("y", (Object)(verticalSpaceUsed + toLabelRect.height + (double)entryPadding.top.intValue())).attr("x", (Object)gradientWidth);
                if (fromLabelRect.width + toLabelRect.width >= sizeShapeLongSide) {
                    toLabel.attr("dy", (Object)"1em").attr("dx", (Object)entryPadding.left);
                    textFlow.extent(ObjectConverter.toInt((Object)sizeShapeLongSide), ObjectConverter.toInt((Object)fromLabelRect.height));
                    verticalSpaceUsed += fromLabelRect.height * 2.0;
                } else {
                    verticalSpaceUsed += fromLabelRect.height;
                }
            } else {
                fromLabel.attr("x", (Object)(sizeShapeShortSide + (double)entryPadding.left.intValue())).attr("y", (Object)(verticalSpaceUsed + fromLabelRect.height * 0.5)).attr("dx", (Object)entryPadding.left);
                toLabel.attr("x", (Object)(sizeShapeShortSide + (double)entryPadding.left.intValue())).attr("y", (Object)(verticalSpaceUsed - gradientHeight + toLabelRect.height * 0.5 + (double)entryPadding.top.intValue())).attr("dx", (Object)entryPadding.left);
                verticalSpaceUsed += fromLabelRect.height * 0.5;
                horizontalSpaceUsed += Math.max(toLabelRect.width, fromLabelRect.width);
                textFlow.extent(ObjectConverter.toInt((Object)(availableWidth - sizeShapeShortSide * 1.5)), ObjectConverter.toInt((Object)fromLabelRect.height));
            }
            fromLabel.call((RunFunction)textFlow, new Object[0]);
            toLabel.call((RunFunction)textFlow, new Object[0]);
            this._spaceUsed = isHorizontal ? verticalSpaceUsed : horizontalSpaceUsed;
        });
    }

    private String defineGradient(Selector gSelection, boolean isHorizontal) {
        String gradientStart = isHorizontal ? "x1" : "y2";
        String gradientEnd = isHorizontal ? "x2" : "y1";
        String nonGradientStart = isHorizontal ? "y1" : "x2";
        String nonGradientEnd = isHorizontal ? "y2" : "x1";
        String gradientId = "contLegendGradient" + gradientNr;
        Selector defs = gSelection.select((Object)">defs");
        if (defs.empty()) {
            defs = gSelection.append("defs");
        }
        Selector gradient = defs.append("linearGradient").attr("id", (Object)gradientId).attr(gradientStart, (Object)"0%").attr(gradientEnd, (Object)"100%").attr(nonGradientStart, (Object)"0%").attr(nonGradientEnd, (Object)"0%").attr("spreadMethod", (Object)"pad");
        boolean interpolate = true;
        int colorStopLength = this._colorStops.size();
        double factor = interpolate ? 1.0 : (double)((colorStopLength - 1) / colorStopLength);
        IRSColor previousColor = null;
        for (int i = 0; i < colorStopLength; ++i) {
            IRSColorStop colorStop = this._colorStops.get(i);
            double at = colorStop.getAt().doubleValue();
            if (previousColor != null) {
                this.addColorStop(gradient, factor * at, previousColor);
            }
            this.addColorStop(gradient, factor * at, colorStop.getColor());
            if (interpolate) continue;
            previousColor = colorStop.getColor();
        }
        if (previousColor != null) {
            this.addColorStop(gradient, 1.0, previousColor);
        }
        return "url(#" + gradientId + ")";
    }

    private void addColorStop(Selector _gradient, double _ratio, IRSColor _color) {
        _gradient.append("stop").attr("offset", (Object)(_ratio * 100.0 + "%")).attr("stop-opacity", (Object)"1").attr("stop-color", (Object)_color.toString());
    }
}

