/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2.legend;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.geom.Insets;
import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.rave.core.internal.collections.OMap;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.OrdinalScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.RunFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.ext.legend.swatch.SwatchLegend;
import com.ibm.vida.rave.ext.text.wrap.TextFlow;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vipr.renderingservice.property.Length;
import java.util.List;

public class VidaSizeRangeLegendImpl
extends SwatchLegend {
    private static final String SHAPE_COLOR = "rgb(167, 170, 172)";
    private static final String SLOPE_COLOR = "rgb(224, 225, 225)";
    private static final double SHAPES_LENGTH = 100.0;
    private static final double BIG_RADIUS = 9.0;
    private String _subCaption = null;

    public VidaSizeRangeLegendImpl subCaption(String _subCaption) {
        this._subCaption = _subCaption;
        return this;
    }

    public void legend(Selector g) {
        VidaSizeRangeLegendImpl self = this;
        Insets entryPadding = new Insets();
        if (this.entryFontStyle() == null) {
            OMap fontMap = new OMap();
            fontMap.put((Object)"font-size", (Object)"9px");
            this.entryFontStyle(fontMap);
        }
        if (this.entryFontStyle().get((Object)"font-size") != null) {
            Length fontSize = Length.parse((String)this.entryFontStyle().get((Object)"font-size").toString());
            double fontSizePx = fontSize.calculatePx(100.0, 10.0);
            entryPadding.top = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
            entryPadding.bottom = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
            entryPadding.right = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
            entryPadding.left = ObjectConverter.toInt((Object)(fontSizePx * 0.2));
        }
        g.each((context, data, index, groupIndex) -> {
            double labelMaxX;
            double labelMinX;
            double bigCy;
            double bigCx;
            double[] slope;
            double smallCy;
            double smallCx;
            boolean isHorizontal = "horizontal".equals(self.orient());
            double availableWidth = self.size().getWidth() - (double)entryPadding.left.intValue() - (double)entryPadding.right.intValue();
            double availableHeight = self.size().getHeight() - (double)entryPadding.top.intValue() - (double)entryPadding.bottom.intValue();
            if (availableHeight <= 0.0 || availableWidth <= 0.0) {
                return;
            }
            double verticalSpaceUsed = self.insets().top.intValue();
            double horizontalSpaceUsed = self.insets().left.intValue();
            Selector gSelection = self.prepareLegendGroup((SceneNode)context);
            TextFlow textFlow = self.createTextFlowComponent().wrap(false);
            if (this.title() != null && !this.title().isEmpty()) {
                Selector titleSelector = self.prepareLegendTitle(gSelection, textFlow);
                if (titleSelector != null && titleSelector.node().getParentNode() == null) {
                    return;
                }
                double titleVerticalShift = self.calculateTitleVerticalShift(titleSelector);
                verticalSpaceUsed += titleVerticalShift;
                horizontalSpaceUsed += titleSelector != null ? Rave.util.getBBox((SceneNode)titleSelector.node()).width : 0.0;
                if ((availableHeight -= verticalSpaceUsed) <= 0.0 || availableWidth <= 0.0) {
                    return;
                }
                Selector subCaption = null;
                if (this._subCaption != null && !this._subCaption.isEmpty()) {
                    subCaption = (Selector)gSelection.append("text").text((Object)this._subCaption).attr("y", (Object)(verticalSpaceUsed + (double)entryPadding.top.intValue())).attr("class", (Object)"legendLabel").style(this.entryFontStyle());
                    RaveRect subCaptionBbox = Rave.util.getBBox(subCaption.node());
                    horizontalSpaceUsed = Math.max(subCaptionBbox.width, horizontalSpaceUsed);
                    verticalSpaceUsed += (double)(entryPadding.bottom + entryPadding.top);
                }
            }
            Selector gShapes = gSelection.append("g").attr("transform", (Object)Rave2Common.translate(0.0, verticalSpaceUsed));
            Selector gLegendLabels = ((Selector)gSelection.append("g").style(this.entryFontStyle())).attr("transform", (Object)Rave2Common.translate(0.0, verticalSpaceUsed));
            Object labelFormat = self.getLabelFormat();
            OrdinalScale ordScale = (OrdinalScale)this.scale();
            List domain = ordScale.domain();
            Double[] domainExtremes = new Double[]{(Double)domain.get(0), (Double)domain.get(domain.size() - 1)};
            Selector labelMin = gLegendLabels.append("text").attr("class", (Object)"legendLabel").datum((Object)domainExtremes[0]);
            Selector labelMax = gLegendLabels.append("text").attr("class", (Object)"legendLabel").datum((Object)domainExtremes[1]).attr("text-anchor", (Object)(isHorizontal ? "end" : null));
            if (labelFormat instanceof ValueFunction) {
                labelMin.text((Object)((ValueFunction)labelFormat));
                labelMax.text((Object)((ValueFunction)labelFormat));
            } else {
                labelMin.text(labelFormat);
                labelMax.text(labelFormat);
            }
            RaveRect labelMinRect = Rave.util.getBBox(labelMin.node());
            RaveRect labelMaxRect = Rave.util.getBBox(labelMax.node());
            double sizeShapeRadius = Math.max(labelMinRect.height * 0.75, 9.0);
            double sizeShapeAvailable = isHorizontal ? availableWidth : availableHeight;
            double sizeShapeLongSide = Math.max(12.0 * sizeShapeRadius, 100.0);
            sizeShapeLongSide = Math.min(sizeShapeLongSide, sizeShapeAvailable - labelMinRect.height);
            if (isHorizontal) {
                smallCx = sizeShapeRadius / 2.0;
                smallCy = sizeShapeRadius;
                slope = new double[]{sizeShapeRadius / 2.0, sizeShapeRadius / 2.0, sizeShapeLongSide - sizeShapeRadius, 0.0, sizeShapeLongSide - sizeShapeRadius, 2.0 * sizeShapeRadius, sizeShapeRadius / 2.0, sizeShapeRadius * 1.5, sizeShapeRadius / 2.0, sizeShapeRadius / 2.0};
                bigCx = sizeShapeLongSide - sizeShapeRadius;
                bigCy = sizeShapeRadius;
                labelMinX = 0.0;
                labelMaxX = sizeShapeLongSide;
                verticalSpaceUsed += sizeShapeRadius;
            } else {
                smallCx = sizeShapeRadius;
                smallCy = sizeShapeLongSide - sizeShapeRadius / 4.0;
                slope = new double[]{0.0, sizeShapeRadius, 2.0 * sizeShapeRadius, sizeShapeRadius, sizeShapeRadius * 1.5, sizeShapeLongSide, sizeShapeRadius / 2.0, sizeShapeLongSide, 0.0, sizeShapeRadius};
                bigCx = sizeShapeRadius;
                bigCy = sizeShapeRadius;
                labelMinX = sizeShapeRadius * 2.0 + (double)entryPadding.left.intValue();
                labelMaxX = sizeShapeRadius * 2.0 + (double)entryPadding.left.intValue();
                horizontalSpaceUsed = Math.max(2.0 * sizeShapeRadius, horizontalSpaceUsed);
            }
            gShapes.append("polygon").attr("points", (Object)VidaSizeRangeLegendImpl.pointsAttr(slope)).style("stroke", (Object)SLOPE_COLOR).style("fill", (Object)SLOPE_COLOR);
            gShapes.append("circle").attr("cx", (Object)smallCx).attr("cy", (Object)smallCy).attr("r", (Object)(sizeShapeRadius / 2.0)).style("stroke", (Object)SHAPE_COLOR).style("fill", (Object)SHAPE_COLOR);
            gShapes.append("circle").attr("cx", (Object)bigCx).attr("cy", (Object)bigCy).attr("r", (Object)sizeShapeRadius).style("stroke", (Object)SHAPE_COLOR).style("fill", (Object)SHAPE_COLOR);
            labelMin.attr("x", (Object)labelMinX);
            labelMax.attr("x", (Object)labelMaxX);
            if (isHorizontal) {
                labelMin.attr("y", (Object)(sizeShapeRadius * 2.0 + (double)entryPadding.top.intValue() + labelMinRect.height));
                labelMax.attr("y", (Object)(sizeShapeRadius * 2.0 + (double)entryPadding.top.intValue() + labelMaxRect.height));
                if (labelMinRect.width + labelMaxRect.width >= sizeShapeLongSide) {
                    labelMax.attr("dy", (Object)"1em").attr("dx", (Object)entryPadding.left);
                    verticalSpaceUsed += labelMaxRect.height * 2.0;
                } else {
                    verticalSpaceUsed += labelMaxRect.height;
                }
                verticalSpaceUsed += (double)(entryPadding.bottom + entryPadding.top);
                textFlow.extent(ObjectConverter.toInt((Object)sizeShapeLongSide), ObjectConverter.toInt((Object)labelMinRect.height));
            } else {
                labelMin.attr("y", (Object)(sizeShapeLongSide + labelMinRect.height * 0.5)).attr("dx", (Object)entryPadding.left);
                labelMax.attr("y", (Object)sizeShapeRadius).attr("dx", (Object)entryPadding.left);
                horizontalSpaceUsed += Math.max(labelMinRect.width, labelMaxRect.width);
                textFlow.extent(ObjectConverter.toInt((Object)(availableWidth - (sizeShapeRadius * 2.0 + (double)entryPadding.left.intValue()))), ObjectConverter.toInt((Object)labelMaxRect.height));
            }
            labelMin.call((RunFunction)textFlow, new Object[0]);
            labelMax.call((RunFunction)textFlow, new Object[0]);
            this._spaceUsed = isHorizontal ? verticalSpaceUsed : horizontalSpaceUsed;
        });
    }

    private static String pointsAttr(double[] polygon) {
        StringBuilder sb = new StringBuilder();
        int l = polygon.length;
        for (int i = 0; i < l; i += 2) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(polygon[i]);
            sb.append(',');
            sb.append(polygon[i + 1]);
        }
        return sb.toString();
    }
}

