/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rave2bundle;

import com.ibm.vida.rave.core.collections.ArrayEx;
import com.ibm.vida.rave.core.functions.SingleValueFunction;
import com.ibm.vida.rave.library.datamodel.DataModel;
import com.ibm.vida.rave.library.datamodel.DataSet;
import com.ibm.vida.rave.library.datamodel.DataSlotEntry;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rave2bundle.Rave2BundleDataSlot;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDecorated;
import java.util.ArrayList;
import java.util.List;

public class Rave2BundleDataModel {
    protected DataModel _rave2DataModel;

    public static Rave2BundleDataModel create(DataModel _raveDataModel) {
        return new Rave2BundleDataModel(_raveDataModel);
    }

    private Rave2BundleDataModel(DataModel _raveDataModel) {
        this._rave2DataModel = _raveDataModel;
    }

    public Rave2BundleDataSlot setDataSlot(String _dataSetId, String _dataSlotId, String _type, SingleValueFunction<Object, Object> _accessor) {
        DataSlotEntry rave2DataSlot = this._rave2DataModel.dataset(_dataSetId).slot(_dataSlotId).push();
        rave2DataSlot.type(_type);
        rave2DataSlot.accessor(_accessor);
        return Rave2BundleDataSlot.create(rave2DataSlot);
    }

    public Rave2BundleDataSlot getDataSlot(String _dataSetId, String _dataSlotId) {
        DataSlotEntry dataSlotEntry = this._rave2DataModel.dataset(_dataSetId).slot(_dataSlotId).entry();
        if (dataSlotEntry == null) {
            return null;
        }
        return Rave2BundleDataSlot.create(dataSlotEntry);
    }

    public void clearDataSet(String _dataSetId) {
        DataSet dataSet = this._rave2DataModel.dataset(_dataSetId);
        dataSet.clear();
        dataSet.slots().forEach(_slot -> _slot.clear());
    }

    public void clearDataSlot(String _dataSetId, String _dataSlotId) {
        this._rave2DataModel.dataset(_dataSetId).slot(_dataSlotId).clear();
    }

    public void setData(String _dataSetId, Object _data) {
        DataSet dataSet = this._rave2DataModel.dataset(_dataSetId);
        if (dataSet != null) {
            dataSet.data(_data);
        }
    }

    public boolean hasData() {
        ArrayEx arr = this._rave2DataModel.datasets();
        int len = arr.size();
        for (int i = 0; i < len; ++i) {
            if (((DataSet)arr.get(i)).data() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasSelection() {
        String dataModelType = this._rave2DataModel.getDescriptor().id();
        return this._rave2DataModel.datasets().stream().anyMatch(_dataSet -> {
            Object data = _dataSet.data();
            switch (dataModelType) {
                case "tabular": {
                    if (data == null) {
                        return false;
                    }
                    List rsData = (List)data;
                    return rsData.stream().anyMatch(_data -> (Boolean)_data.getDecoration("selected", (Object)false));
                }
                case "hierarchical": {
                    return true;
                }
            }
            return false;
        });
    }

    public List<IRSDataPoint> getSelection() {
        ArrayList<IRSDataPoint> selection = new ArrayList<IRSDataPoint>();
        if (!this.hasSelection()) {
            return selection;
        }
        for (DataSet dataSet : this._rave2DataModel.datasets()) {
            List data = (List)dataSet.data();
            for (IRSDataPoint dataItem : data) {
                if (!Rave2Common.getDecorationBool((IRSDecorated)dataItem, "selected")) continue;
                selection.add(dataItem);
            }
        }
        return selection;
    }

    public void setDataModel(DataModel _dataModel) {
        this._rave2DataModel = _dataModel;
    }
}

