/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.SymbolCreator;
import com.ibm.vida.vizbundles.common.decoration.Decoration;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IDataItem;
import com.ibm.vida.vizbundles.common.rendering.decorations.IDecorationsController;
import com.ibm.vida.vizbundles.common.rendering.decorations.ILineDecorationsControllerRenderers;
import com.ibm.vida.vizbundles.common.rendering.decorations.INotifyHandler;
import com.ibm.vida.vizbundles.common.rendering.decorations.LineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.NotifyHandler;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.PolyFitLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.TrendLine;
import com.ibm.vipr.renderingservice.api.IRSCatEncodingEntry;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.data.IRSDataItem;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.util.CatEncodingEntry;
import java.util.ArrayList;
import java.util.List;

public class LineDecorationsController
implements IDecorationsController<IDataItem[]> {
    private ILineDecorationsControllerRenderers renderers;
    private String className;
    private INotifyHandler notify;
    private static final String shapeLineDashed = "line-dashed";
    private static final String shapeLine = "line";
    private List<String> baseLineSlots;
    private List<String> trendLineSlots;
    private List<String> polyFitLineSlots;

    public static void registerShapeSymbols() {
        Rave.svg.symbolCreator(shapeLine, new SymbolCreator(){

            public String create(double size) {
                double r = Math.sqrt(size) / 2.0;
                double width = r * 2.0;
                double thickness = r * 0.2;
                StringBuilder pattern = new StringBuilder();
                pattern.append("M").append(-r).append(",").append(-thickness);
                pattern.append("h").append(width);
                pattern.append("v").append(thickness);
                pattern.append("h").append(-width);
                pattern.append("v").append(-thickness);
                pattern.append("Z");
                return pattern.toString();
            }
        });
        Rave.svg.symbolCreator(shapeLineDashed, new SymbolCreator(){

            public String create(double size) {
                double r = Math.sqrt(size) / 2.0;
                double thickness = r * 0.2;
                double part = r / 7.0;
                StringBuilder pattern = new StringBuilder();
                pattern.append("M").append(-r).append(",").append(-thickness);
                for (int i = 0; i < 4; ++i) {
                    if (i > 0) {
                        pattern.append(" m").append(part * (double)(i + 1)).append(",0");
                    }
                    pattern.append(" h").append(part).append("v").append(thickness).append("h").append(-part).append("v" + -thickness);
                }
                return pattern.toString();
            }
        });
    }

    public LineDecorationsController(ILineDecorationsControllerRenderers _renderers, IRSHostAPI _hostAPI) {
        this.renderers = _renderers;
        this.className = String.format("lineDecorations_%d", Rave2Common.createUniqueId());
        this.notify = new NotifyHandler(_hostAPI);
        this.baseLineSlots = new ArrayList<String>();
        this.trendLineSlots = new ArrayList<String>();
        this.polyFitLineSlots = new ArrayList<String>();
    }

    @Override
    public void update(Selector _overlayLayer, IDataItem[] _dataItems) {
        try {
            final LineDecorationsController self = this;
            Object[] lines = this.extractAllLineData(_dataItems);
            Selector elements = _overlayLayer.selectAll("." + this.className).data(lines, (ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    LineData item = (LineData)data;
                    return String.format("%s_%s", item.axis, item.decoration.getId());
                }
            });
            elements.exit().remove();
            elements.enter().append("g").attr("class", (Object)this.className);
            elements.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    try {
                        self.renderDecoration(context, (LineData)data);
                    }
                    catch (DecorationError _e) {
                        self.notify.error(_e);
                    }
                }
            });
        }
        catch (Exception _e) {
            this.notify.error(new DecorationError(_e.getMessage()));
        }
    }

    @Override
    public List<IRSCatEncodingEntry> getEncodingEntries(IDataItem[] _dataItems) {
        LineData[] lines;
        ArrayList<IRSCatEncodingEntry> entries = new ArrayList<IRSCatEncodingEntry>();
        for (LineData lineData : lines = this.extractAllLineData(_dataItems)) {
            if (!lineData.decoration.getShowInLegend()) continue;
            AbstractLine line = lineData.decoration;
            String shape = line.getDashStyle() != null && line.getDashStyle().length > 0 ? shapeLineDashed : shapeLine;
            CatEncodingEntry entry = new CatEncodingEntry(line.getTitle(), line.getColor(), shape, line.getSelected(), false, (IRSDataNode)lineData.getDataSlot());
            entries.add((IRSCatEncodingEntry)entry);
        }
        return entries;
    }

    private void renderDecoration(SceneNode _nodeElement, LineData _lineData) throws DecorationError {
        AbstractLine decoration = _lineData.decoration;
        if (this.renderers.getBaseLineRenderer() != null && decoration instanceof BaseLine) {
            this.renderers.getBaseLineRenderer().render(_nodeElement, _lineData);
        }
        if (this.renderers.getPolyLineRenderer() != null && decoration instanceof PolyFitLine) {
            this.renderers.getPolyLineRenderer().render(_nodeElement, _lineData);
        }
        if (this.renderers.getTrendLineRenderer() != null && decoration instanceof TrendLine) {
            this.renderers.getTrendLineRenderer().render(_nodeElement, _lineData);
        }
    }

    public void registerSlots(Decoration _decoration, List<String> _slotNames) {
        switch (_decoration) {
            case baseLines: {
                this.baseLineSlots = _slotNames;
                break;
            }
            case trendLines: {
                this.trendLineSlots = _slotNames;
                break;
            }
            case polyFitLines: {
                this.polyFitLineSlots = _slotNames;
                break;
            }
            default: {
                this.notify.info(String.format("Not supported Decoration \"%s\" used to register slots.", _decoration.toString()));
            }
        }
    }

    private LineData[] extractAllLineData(IDataItem[] _dataItems) {
        ArrayList<LineData> linesData = new ArrayList<LineData>();
        if (!this.baseLineSlots.isEmpty()) {
            this.baseLineSlots.forEach(_slotName -> linesData.addAll(this.extractLines(_dataItems, Decoration.baseLines, (String)_slotName)));
        }
        if (!this.trendLineSlots.isEmpty()) {
            this.trendLineSlots.forEach(_slotName -> linesData.addAll(this.extractLines(_dataItems, Decoration.trendLines, (String)_slotName)));
        }
        if (!this.polyFitLineSlots.isEmpty()) {
            this.polyFitLineSlots.forEach(_slotName -> linesData.addAll(this.extractLines(_dataItems, Decoration.polyFitLines, (String)_slotName)));
        }
        linesData.addAll(this.extract(_dataItems));
        return linesData.toArray(new LineData[0]);
    }

    private List<LineData> extractLines(IDataItem[] _data, Decoration _decoration, String _targetSlot) {
        ArrayList<LineData> toRender = new ArrayList<LineData>();
        String decorationName = _decoration.toString();
        for (IDataItem dataItem : _data) {
            String refSlot;
            String axis = dataItem.getAxis();
            IRSSlot slot = dataItem.getData();
            String string = refSlot = dataItem.getRefSlot() != null ? dataItem.getRefSlot().getName() : "";
            if (slot == null || !slot.getName().equals(_targetSlot)) continue;
            for (IRSDataItem rsDataItem : slot.getDataItems()) {
                List arrLines = (List)rsDataItem.getDecoration(decorationName, new ArrayList());
                for (AbstractLine line : arrLines) {
                    toRender.add(new LineData(line, axis, slot, _targetSlot, refSlot));
                }
            }
        }
        return toRender;
    }

    private List<LineData> extract(IDataItem[] _data) {
        ArrayList<LineData> toRender = new ArrayList<LineData>();
        for (IDataItem dataItem : _data) {
            String refSlot;
            String axis = dataItem.getAxis();
            IRSSlot slot = dataItem.getData();
            String string = refSlot = dataItem.getRefSlot() != null ? dataItem.getRefSlot().getName() : "";
            if (slot == null) continue;
            String targetSlot = dataItem.getRefSlot().getName();
            for (IRSDataItem rsDataItem : slot.getDataItems()) {
                List arrLines = (List)rsDataItem.getDecoration("lines", new ArrayList());
                for (AbstractLine line : arrLines) {
                    toRender.add(new LineData(line, axis, slot, targetSlot, refSlot));
                }
            }
        }
        return toRender;
    }
}

