/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations;

import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.vizbundles.common.rave2.Rave2Common;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.DefaultMarkerExtractor;
import com.ibm.vida.vizbundles.common.rendering.decorations.IDecorationsController;
import com.ibm.vida.vizbundles.common.rendering.decorations.IExtractor;
import com.ibm.vida.vizbundles.common.rendering.decorations.IMarkerDecorationsControllerRenderers;
import com.ibm.vida.vizbundles.common.rendering.decorations.INotifyHandler;
import com.ibm.vida.vizbundles.common.rendering.decorations.MarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.NotifyHandler;
import com.ibm.vida.vizbundles.common.rendering.decorations.PositionTypeError;
import com.ibm.vida.vizbundles.extensions.decorations.markers.AbstractMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.DataMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.DataPointMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.FreeMarker;
import com.ibm.vipr.renderingservice.api.IRSCatEncodingEntry;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.api.IRSHostAPI;
import com.ibm.vipr.renderingservice.data.IRSDataNode;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.util.CatEncodingEntry;
import com.ibm.vipr.renderingservice.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;

public class MarkerDecorationsController
implements IDecorationsController<IRSDataSet> {
    private final IMarkerDecorationsControllerRenderers renderers;
    private final IExtractor<IRSDataSet, MarkerData[]> extractor;
    private final String className;
    private final INotifyHandler notify;

    public MarkerDecorationsController(IMarkerDecorationsControllerRenderers _renderers, IRSHostAPI _hostAPI) {
        this.renderers = _renderers;
        this.className = String.format("markerDecorations_%d", Rave2Common.createUniqueId());
        this.extractor = new DefaultMarkerExtractor();
        this.notify = new NotifyHandler(_hostAPI);
    }

    @Override
    public void update(Selector _overlayLayer, IRSDataSet _dataSet) {
        try {
            final MarkerDecorationsController self = this;
            Object[] markers = this.extractor.extract(_dataSet, this.notify);
            Selector elements = _overlayLayer.selectAll("." + this.className).data(markers, (ValueFunction)new ValueFunction<Object, Object>(){

                public Object getValue(Object context, Object data, int index, int groupIndex) {
                    MarkerData item = (MarkerData)data;
                    return item.getDecoration().getId();
                }
            });
            elements.exit().remove();
            Selector enterSelector = elements.enter();
            Selector gElement = enterSelector.append("g");
            gElement.attr("class", (Object)this.className);
            elements.each((CallbackFunction)new CallbackFunction<SceneNode>(){

                public void run(SceneNode context, Object data, int index, int groupIndex) {
                    try {
                        self.renderDecoration(context, (MarkerData)data);
                    }
                    catch (DecorationError _e) {
                        self.notify.error(_e);
                    }
                }
            });
        }
        catch (Exception _e) {
            this.notify.error(new DecorationError(_e.getMessage()));
        }
    }

    @Override
    public List<IRSCatEncodingEntry> getEncodingEntries(IRSDataSet _dataSet) {
        MarkerData[] markers;
        ArrayList<IRSCatEncodingEntry> entries = new ArrayList<IRSCatEncodingEntry>();
        for (MarkerData markerData : markers = this.extractor.extract(_dataSet, this.notify)) {
            AbstractMarker decoration = markerData.getDecoration();
            if (!decoration.getShowInLegend()) continue;
            IRSColor color = decoration.getShape() != null ? decoration.getFillColor() : ColorUtil.Named.transparent.color;
            String shape = decoration.getShape() != null ? decoration.getShape().value() : null;
            IRSDataSet rsDataNode = markerData.getDataSet() != null ? markerData.getDataSet() : markerData.getDataPoint();
            CatEncodingEntry entry = new CatEncodingEntry(decoration.getTitle(), color, shape, decoration.getSelected(), false, (IRSDataNode)rsDataNode);
            entries.add((IRSCatEncodingEntry)entry);
        }
        return entries;
    }

    private void renderDecoration(SceneNode _nodeElement, MarkerData _markerData) throws PositionTypeError, DecorationError {
        AbstractMarker decoration = _markerData.getDecoration();
        if (this.renderers.getDataMarkerRenderer() != null && decoration instanceof DataMarker) {
            this.renderers.getDataMarkerRenderer().render(_nodeElement, _markerData);
        }
        if (this.renderers.getFreeMarkerRenderer() != null && decoration instanceof FreeMarker) {
            this.renderers.getFreeMarkerRenderer().render(_nodeElement, _markerData);
        }
        if (this.renderers.getPointDataMarkerRenderer() != null && decoration instanceof DataPointMarker) {
            this.renderers.getPointDataMarkerRenderer().render(_nodeElement, _markerData);
        }
    }
}

