/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations;

import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.library.framework.CoordinateScale;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.Helpers;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import java.util.List;

public class Scale {
    private final AbstractScale<?, Object> _scale;
    private final CoordinateScale _coordScale;

    public Scale(AbstractScale<?, Object> _scale) {
        this._scale = _scale;
        this._coordScale = null;
    }

    public Scale(CoordinateScale _coordScale) {
        this._coordScale = _coordScale;
        this._scale = this._coordScale.scale();
    }

    public AbstractScale<?, Object> getScale() {
        return this._scale;
    }

    public boolean isCategorical() {
        if (this._coordScale != null) {
            return this._coordScale.isOrdinal() || this._coordScale.isClustered();
        }
        return this._scale.getRangeExtent() != null;
    }

    public boolean isInRange(double _val) {
        AbstractScale<?, Object> scale = this.getScale();
        List range = scale.getRangeExtent() != null ? scale.getRangeExtent().getValue() : scale.range();
        double rangeFirst = ObjectConverter.toDouble(range.get(0));
        double rangeLast = ObjectConverter.toDouble(range.get(range.size() - 1));
        double min = Math.min(rangeFirst, rangeLast);
        double max = Math.max(rangeFirst, rangeLast);
        return !(_val < min) && !(_val > max);
    }

    public double getScaleValue(int _data) throws DecorationError {
        boolean isCategorical = this.isCategorical();
        List domain = this._scale.domain();
        if (isCategorical && !Helpers.indexInBounds(domain, _data)) {
            throw new InvalidInputError("invalid index for ");
        }
        if (isCategorical) {
            double scaleValue = this.getDoubleValue(domain.get(_data));
            return scaleValue + this._scale.getRangeBand().getValue().doubleValue() * 0.5;
        }
        return this.getDoubleValue(_data);
    }

    public double getScaleValue(IRSDatum _datum) {
        boolean isCategorical = this.isCategorical();
        if (isCategorical) {
            double scaleValue = this.getDoubleValue(_datum.asCat().getKey());
            return scaleValue + this._scale.getRangeBand().getValue().doubleValue() * 0.5;
        }
        return this.getDoubleValue(_datum.asCont().getValue());
    }

    public double getDoubleValue(Object _data) {
        return ObjectConverter.toDouble((Object)this._scale.getValue(null, _data, 0, 0));
    }
}

