/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.rave.core.geom.RaveRect;
import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.Rave2BundleDecorationsData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.ITrendLineData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import java.util.function.Supplier;

public class BoxPlotDecorationsData
extends Rave2BundleDecorationsData
implements IBaseLineData,
ITrendLineData,
IPolyLineData,
IDataMarkerData,
IDataPointMarkerData {
    private final Supplier<IRSDataSet> resolveDataSet;
    private final Supplier<IRSProperties> resolveProperties;

    public BoxPlotDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<IRSProperties> _resolveProperties, Supplier<RaveRect> _resolvePlotAreaBounds) {
        super(_resolveBundle, _resolvePlotAreaBounds, null);
        this.resolveDataSet = _resolveDataSet;
        this.resolveProperties = _resolveProperties;
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        return this.createProperties(properties);
    }

    @Override
    public IPoint getPointPosition(Scale _xScale, Scale _yScale, IRSDataPoint _dataPoint) throws DecorationError {
        String CATEGORIES_SLOT = "categories";
        String VALUES_SLOT = "values";
        IRSDataSet dataSet = this.resolveDataSet.get();
        IRSSlot categoriesSlot = dataSet.getSlot(CATEGORIES_SLOT);
        IRSSlot valuesSlot = dataSet.getSlot(VALUES_SLOT);
        IRSDatum xVal = _dataPoint.get(categoriesSlot);
        IRSDatum yVal = _dataPoint.get(valuesSlot);
        double x = _xScale.getScaleValue(xVal);
        double y = _yScale.getScaleValue(yVal);
        return new PointImpl(x, y);
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws InvalidInputError, DecorationError {
        if (_items.length != 2) {
            throw new InvalidInputError("dataMarker");
        }
        double x = _xScale.getScaleValue(_items[0]);
        double y = _yScale.getScaleValue(_items[1]);
        return new PointImpl(x, y);
    }
}

