/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.data;

import com.ibm.vida.vizbundles.common.rave2bundle.IRave2BundleWrapper;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.InvalidInputError;
import com.ibm.vida.vizbundles.common.rendering.decorations.PropertiesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.ScalesImpl;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineRadarData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IDataPointMarkerData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IFreeMarkerData;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vipr.renderingservice.api.IRSColor;
import com.ibm.vipr.renderingservice.data.IRSDataPoint;
import com.ibm.vipr.renderingservice.data.IRSDataSet;
import com.ibm.vipr.renderingservice.data.IRSDatum;
import com.ibm.vipr.renderingservice.data.IRSSlot;
import com.ibm.vipr.renderingservice.data.RSFormatKind;
import com.ibm.vipr.renderingservice.property.Font;
import com.ibm.vipr.renderingservice.property.IRSProperties;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class RadarDecorationsData
implements IBaseLineRadarData,
IDataMarkerData,
IDataPointMarkerData,
IFreeMarkerData {
    private final Supplier<IRSDataSet> resolveDataSet;
    private final Supplier<IRave2BundleWrapper> resolveBundle;
    private final Supplier<IRSProperties> resolveProperties;
    private final Font bundleFont;

    public RadarDecorationsData(Supplier<IRSDataSet> _resolveDataSet, Supplier<IRave2BundleWrapper> _resolveBundle, Supplier<IRSProperties> _resolveProperties, Font _bundleFont) {
        this.resolveDataSet = _resolveDataSet;
        this.resolveBundle = _resolveBundle;
        this.resolveProperties = _resolveProperties;
        this.bundleFont = _bundleFont;
    }

    @Override
    public List<IPoint> getRelativeCoordinates(Scale _xScale, Scale _yScale, double _relativeValue) {
        ArrayList<IPoint> coordinates = new ArrayList<IPoint>();
        if (_relativeValue > 1.0 || _relativeValue < 0.0) {
            return coordinates;
        }
        List xDomain = _xScale.getScale().domain();
        List yDomain = _yScale.getScale().domain();
        double yValue = ((Double)yDomain.get(1) - (Double)yDomain.get(0)) * _relativeValue;
        double v2 = _yScale.getDoubleValue(yValue);
        for (Object _item : xDomain) {
            double v1 = _xScale.getDoubleValue(_item);
            coordinates.add(this.getCoordinate(v1, v2));
        }
        return coordinates;
    }

    @Override
    public List<IPoint> getAbsoluteCoordinates(Scale _xScale, Scale _yScale, double _absoluteValue) {
        ArrayList<IPoint> coordinates = new ArrayList<IPoint>();
        List xDomain = _xScale.getScale().domain();
        List yDomain = _yScale.getScale().domain();
        double maxValue = 0.0;
        for (Object _item : yDomain) {
            maxValue = Math.max(maxValue, (Double)_item);
        }
        if (_absoluteValue > maxValue) {
            return coordinates;
        }
        for (Object _item : xDomain) {
            double v1 = _xScale.getDoubleValue(_item);
            double v2 = _yScale.getDoubleValue(_absoluteValue);
            coordinates.add(this.getCoordinate(v1, v2));
        }
        return coordinates;
    }

    private IPoint getCoordinate(double _v1, double _v2) {
        double x = _v2 * Math.sin(_v1);
        double y = _v2 * Math.cos(_v1);
        return new PointImpl(x, y);
    }

    @Override
    public IScales getScales() {
        IRave2BundleWrapper bundleWrapper = this.resolveBundle.get();
        return new ScalesImpl(bundleWrapper);
    }

    @Override
    public IProperties getProperties() {
        IRSProperties properties = this.resolveProperties.get();
        boolean isHorizontal = false;
        IRSColor backgroundColor = (IRSColor)properties.getColor("backgroundColor").getValue();
        return new PropertiesImpl(isHorizontal, backgroundColor, false, false, this.bundleFont);
    }

    @Override
    public String getClipPath() {
        return "";
    }

    @Override
    public Bounds getCanvasSize() {
        return this.resolveBundle.get().getSize();
    }

    @Override
    public IPoint getPointPosition(Scale _xScale, Scale _yScale, IRSDataPoint _dataPoint) throws DecorationError {
        String CATEGORIES_SLOT = "categories";
        String VALUES_SLOT = "values";
        IRSDataSet dataSet = this.resolveDataSet.get();
        IRSSlot categoriesSlot = dataSet.getSlot(CATEGORIES_SLOT);
        IRSSlot valuesSlot = dataSet.getSlot(VALUES_SLOT);
        IRSDatum xVal = _dataPoint.get(categoriesSlot);
        IRSDatum yVal = _dataPoint.get(valuesSlot);
        double v1 = _xScale.getDoubleValue(xVal.asCat().getCaption(RSFormatKind.Label));
        double v2 = _yScale.getScaleValue(yVal);
        return this.getCoordinate(v1, v2);
    }

    @Override
    public IPoint getDataPosition(Scale _xScale, Scale _yScale, int[] _items) throws InvalidInputError, DecorationError {
        if (_items.length != 2) {
            throw new InvalidInputError("dataMarker");
        }
        int xCat = _items[0];
        int yCont = _items[1];
        double v1 = _xScale.getScaleValue(xCat);
        double v2 = _yScale.getScaleValue(yCont);
        return this.getCoordinate(v1, v2);
    }
}

