/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scales.AbstractScale;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.Symbol;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IProperties;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.LineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.PositionTypeError;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.data.VaneData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.BaseLineRenderInfo;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.LineHelpers;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.TextPositioning;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.VaneRenderer;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vida.vizbundles.extensions.decorations.Position;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLinePositionTypes;
import com.ibm.vida.vizbundles.extensions.decorations.lines.Crosshair;
import com.ibm.vida.vizbundles.extensions.decorations.lines.CrosshairShape;
import com.ibm.vida.vizbundles.extensions.decorations.lines.Grabber;
import com.ibm.vida.vizbundles.extensions.decorations.lines.GrabberPositionType;
import com.ibm.vipr.renderingservice.util.Bounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BaseLineRenderer
implements IRenderer<LineData> {
    private static final String _class = "class";
    private final IBaseLineData _bundleData;
    protected final BaseLineRenderInfo _info;
    private final VaneRenderer _vaneRenderer;

    public BaseLineRenderer(IBaseLineData _bundleData) {
        this._bundleData = _bundleData;
        this._info = new BaseLineRenderInfo(this._bundleData);
        this._vaneRenderer = new VaneRenderer(this._info);
    }

    @Override
    public void render(SceneNode _el, LineData _lineData) throws DecorationError {
        this._info.update(_lineData);
        BaseLine line = (BaseLine)_lineData.getDecoration();
        Selector container = Rave.select((SceneNode)_el);
        String className = line.getId();
        IProperties properties = this._bundleData.getProperties();
        double position = line.getPositionValue();
        Scale scale = this.getScale(_lineData);
        boolean isHorizontalLine = this._info.isHorizontalLine();
        if (scale == null) {
            container.remove();
            return;
        }
        double posPx = this.getPositionPx(position, line.getPositionType(), scale, isHorizontalLine);
        if (this.isOutsideVisBounds(posPx, scale)) {
            container.remove();
            return;
        }
        Bounds bounds = this._bundleData.getPlotAreaBounds();
        double tx = isHorizontalLine ? 0.0 : posPx;
        double ty = isHorizontalLine ? posPx : 0.0;
        container.attr("transform", (Object)("translate(" + tx + ", " + ty + ")"));
        Object[] arrData = new String[]{className};
        Selector lineSelection = container.selectAll("." + className).data(arrData);
        lineSelection.enter().append("line").attr(_class, (Object)className);
        lineSelection.attr("x1", (Object)(isHorizontalLine ? bounds.getLeft() : 0.0)).attr("x2", (Object)(isHorizontalLine ? bounds.getRight() : 0.0)).attr("y1", (Object)(isHorizontalLine ? 0.0 : bounds.getTop())).attr("y2", (Object)(isHorizontalLine ? 0.0 : bounds.getBottom()));
        LineHelpers.applyLineProperties(lineSelection, (AbstractLine)line, properties);
        IPoint textPosition = this.getTextPosition(bounds, isHorizontalLine);
        TextPositioning textPositioning = new TextPositioning(bounds, textPosition, isHorizontalLine, isHorizontalLine ? ty : tx);
        LineHelpers.renderOverlayText(container, (AbstractLine)line, properties, textPositioning);
        ArrayList<LineData> arrGrabberData = line.isGrabberVisible() ? Arrays.asList(_lineData) : new ArrayList<LineData>();
        this.renderGrabber(container, arrGrabberData, line.getGrabber(), bounds);
        ArrayList<LineData> arrCrosshairData = line.isCrosshairVisible() ? Arrays.asList(_lineData) : new ArrayList<LineData>();
        this.renderCrosshair(container, arrCrosshairData, line.getCrosshair(), bounds);
        ArrayList<VaneData> arrVaneData = new ArrayList<VaneData>();
        if (line.isVaneVisible()) {
            arrVaneData.add(new VaneData(_lineData, this.getVanePosition(_lineData)));
        }
        if (properties.getFont() != null) {
            this._vaneRenderer.setFont(properties.getFont());
        }
        this._vaneRenderer.render(_el, (List<VaneData>)arrVaneData);
    }

    protected boolean isOutsideVisBounds(double _posPx, Scale _scale) {
        AbstractScale<?, Object> scale = _scale.getScale();
        List range = _scale.isCategorical() ? scale.getRangeExtent().getValue() : scale.range();
        double rangeFirst = ObjectConverter.toDouble(range.get(0));
        double rangeLast = ObjectConverter.toDouble(range.get(range.size() - 1));
        return _posPx < Math.min(rangeFirst, rangeLast) || _posPx > Math.max(rangeFirst, rangeLast);
    }

    protected Scale getScale(LineData _lineData) {
        IScales rScales = this._bundleData.getScales();
        switch (_lineData.getAxis()) {
            case "x": {
                return rScales.getXScale();
            }
            case "x2": {
                return rScales.getX2Scale();
            }
            case "y": {
                return rScales.getYScale();
            }
            case "y2": {
                return rScales.getY2Scale();
            }
        }
        return null;
    }

    private double getPositionPx(double _position, BaseLinePositionTypes _posType, Scale _scale, boolean _isHorizontal) throws DecorationError {
        switch (_posType) {
            case DATA_VALUE: {
                return this.getAbsoluteCoordinates(_position, _scale);
            }
            case STATIC_PCT: {
                return this.getStaticCoordinates(_position, _scale, _isHorizontal);
            }
            case TUPLE_IDX: {
                return this.getTuplePosition(_position, _scale);
            }
        }
        throw new PositionTypeError(_posType, "BaseLine");
    }

    private IPoint getTextPosition(Bounds _bounds, boolean _horizontalLine) {
        double center = _horizontalLine ? _bounds.getWidth() * 0.5 + _bounds.getLeft() : _bounds.getBottom() - _bounds.getHeight() * 0.5;
        double x = _horizontalLine ? center : 0.0;
        double y = _horizontalLine ? 0.0 : center;
        return new PointImpl(x, y);
    }

    protected Position getVanePosition(LineData _lineData) {
        return this._info.isHorizontalLine() ? Position.LEFT : Position.BOTTOM;
    }

    protected void renderCrosshair(Selector _container, List<LineData> _arrData, Crosshair _crosshair, Bounds _bounds) throws DecorationError {
        Selector crosshairSelection = _container.selectAll(".crosshair").data(_arrData);
        crosshairSelection.enter().append("g").attr(_class, (Object)"crosshair");
        crosshairSelection.exit().remove();
        if (_arrData.size() > 0) {
            double y;
            double x;
            boolean isHorizontalLine = this._info.isHorizontalLine();
            double position = _crosshair.getPosition();
            switch (_crosshair.getPositionType()) {
                case STATIC_PCT: {
                    x = isHorizontalLine ? position * _bounds.getWidth() + _bounds.getLeft() : 0.0;
                    y = isHorizontalLine ? 0.0 : position * _bounds.getHeight() + _bounds.getTop();
                    break;
                }
                case STATIC_POS: {
                    x = isHorizontalLine ? position + _bounds.getLeft() : 0.0;
                    y = isHorizontalLine ? 0.0 : position + _bounds.getTop();
                    break;
                }
                default: {
                    throw new DecorationError("Invalid position type " + _crosshair.getPositionType().toString());
                }
            }
            crosshairSelection.attr("transform", (Object)("translate(" + x + ", " + y + ")")).style("stroke-opacity", (Object)(_crosshair.isSelected() || _crosshair.isHighlighted() ? 0.9 : 0.3));
            this.renderShape(crosshairSelection, _crosshair);
        }
    }

    protected Selector renderShape(Selector _containerSelection, Crosshair _crosshair) {
        CrosshairShape shape = _crosshair.getShape();
        Object[] shapeData = new Double[]{new Double(0.0)};
        String className = "crosshairShape";
        Selector shapeSelection = _containerSelection.selectAll("." + className).data(shapeData);
        shapeSelection.exit().remove();
        shapeSelection.enter().append("svg:path").attr(_class, (Object)className);
        if (shape != null) {
            double shapeSize = _crosshair.getShapeSize().calculatePx(0.0, 10.0);
            Symbol path = Rave.svg.symbol().type(shape.value()).size(shapeSize * shapeSize);
            shapeSelection.attr("d", (ValueFunction)path).style("fill", (Object)"white").style("stroke", (Object)"black").style("stroke-width", (Object)"1px");
        } else {
            shapeSelection.attr("d", (Object)"");
        }
        return shapeSelection;
    }

    protected Position getGrabberPosition(LineData _lineData, GrabberPositionType _position) {
        if (_position == GrabberPositionType.BEGIN) {
            return this._info.isHorizontalLine() ? Position.LEFT : Position.BOTTOM;
        }
        return this._info.isHorizontalLine() ? Position.RIGHT : Position.TOP;
    }

    private void renderGrabber(Selector _container, List<LineData> _arrData, Grabber _grabber, Bounds _bounds) {
        double grabberWidth = 10.0;
        double grabberHeight = 20.0;
        Selector grabberSelection = _container.selectAll(".grabber").data(_arrData);
        Selector grabberEnter = grabberSelection.enter().append("g").attr(_class, (Object)"grabber");
        grabberEnter.append("rect").attr("x", (Object)0).attr("y", (Object)0).attr("width", (Object)grabberWidth).attr("height", (Object)grabberHeight).style("fill", (Object)"white").style("stroke-width", (Object)"1px").style("stroke", (Object)"grey");
        grabberEnter.append("line").attr("x1", (Object)4).attr("x2", (Object)4).attr("y1", (Object)3).attr("y2", (Object)17).style("stroke-width", (Object)"1px").style("stroke", (Object)"black");
        grabberEnter.append("line").attr("x1", (Object)6).attr("x2", (Object)6).attr("y1", (Object)3).attr("y2", (Object)17).style("stroke-width", (Object)"1px").style("stroke", (Object)"black");
        grabberSelection.exit().remove();
        if (_arrData.size() > 0) {
            boolean isHorizontalLine = this._info.isHorizontalLine();
            Position position = this.getGrabberPosition(_arrData.get(0), _grabber.getPositionType());
            IPoint translate = this.getGrabberTranslate(position, grabberHeight, grabberWidth, _bounds);
            grabberSelection.attr("transform", (_context, _data, _index, _groupIndex) -> {
                if (isHorizontalLine) {
                    return "translate(" + translate.getX() + ", " + translate.getY() + ") rotate(90)";
                }
                return "translate(" + translate.getX() + ", " + translate.getY() + ")";
            }).style("stroke-opacity", (Object)(_grabber.isSelected() || _grabber.isHighlighted() ? 0.9 : 0.3));
        }
    }

    protected IPoint getGrabberTranslate(Position _grabberPosition, double _grabberHeight, double _grabberWidth, Bounds _bounds) {
        double translateY;
        double translateX;
        double grabberMiddle = _grabberWidth / 2.0;
        switch (_grabberPosition) {
            case LEFT: {
                translateX = _bounds.getLeft() + _grabberHeight;
                translateY = -grabberMiddle;
                break;
            }
            case RIGHT: {
                translateX = _bounds.getRight();
                translateY = -grabberMiddle;
                break;
            }
            case TOP: {
                translateX = -grabberMiddle;
                translateY = _bounds.getTop();
                break;
            }
            case BOTTOM: {
                translateX = -grabberMiddle;
                translateY = _bounds.getBottom() - _grabberHeight;
                break;
            }
            default: {
                translateX = 0.0;
                translateY = 0.0;
            }
        }
        return new PointImpl(translateX, translateY);
    }

    protected double getTuplePosition(double _tupleIdx, Scale _scale) throws DecorationError {
        if (!_scale.isCategorical()) {
            throw new DecorationError("Baseline does not support tuple coordinates on continuous axis");
        }
        AbstractScale<?, Object> scale = _scale.getScale();
        List yDomain = scale.domain();
        if (_tupleIdx >= (double)yDomain.size() || _tupleIdx < 0.0) {
            throw new DecorationError("TupleIndex is out of bounds");
        }
        double rangeBand = scale.getRangeBand().getValue().doubleValue();
        double scaleValue = _scale.getDoubleValue(yDomain.get((int)_tupleIdx));
        return scaleValue + rangeBand * 0.5;
    }

    protected double getStaticCoordinates(double _value, Scale _scale, boolean _isHorizontal) {
        AbstractScale<?, Object> scale = _scale.getScale();
        List range = _scale.isCategorical() ? scale.getRangeExtent().getValue() : scale.range();
        double rangeFirst = ObjectConverter.toDouble(range.get(0));
        double rangeLast = ObjectConverter.toDouble(range.get(range.size() - 1));
        double minRange = Math.min(rangeFirst, rangeLast);
        double maxRange = Math.max(rangeFirst, rangeLast);
        double size = maxRange - minRange;
        return _isHorizontal ? maxRange - size * _value : size * _value + minRange;
    }

    protected double getAbsoluteCoordinates(double _absoluteValue, Scale _scale) throws DecorationError {
        if (_scale.isCategorical()) {
            throw new DecorationError("Baseline does not support absolute coordinates on categorical axis");
        }
        return _scale.getDoubleValue(_absoluteValue);
    }
}

