/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.Symbol;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.FontHelper;
import com.ibm.vida.vizbundles.extensions.decorations.markers.AbstractMarker;
import com.ibm.vida.vizbundles.extensions.decorations.markers.MarkerShape;
import java.util.Arrays;

public class MarkerHelpers {
    private MarkerHelpers() {
    }

    public static Selector renderShape(Selector _containerSelection, AbstractMarker _marker) {
        MarkerShape shape = _marker.getShape();
        Object[] shapeData = new Double[]{new Double(0.0)};
        String className = _marker.getId();
        Selector shapeSelection = _containerSelection.selectAll("." + className).data(shapeData);
        shapeSelection.exit().remove();
        shapeSelection.enter().append("path").attr("class", (Object)className);
        if (shape != null) {
            double shapeSize = _marker.getShapeSize().calculatePx(0.0, 10.0);
            Symbol path = Rave.svg.symbol().type(shape.value()).size(shapeSize * shapeSize);
            shapeSelection.attr("d", (ValueFunction)path);
        } else {
            shapeSelection.attr("d", (Object)"");
        }
        return shapeSelection;
    }

    public static Selector renderCaptionText(Selector _containerSelection, AbstractMarker _marker) {
        String text = _marker.getCaption();
        Selector textSelection = _containerSelection.selectAll(".captionText").data(Arrays.asList(text));
        textSelection.exit().remove();
        if (text != null) {
            textSelection.enter().append("text").attr("class", (Object)"captionText").style("font-family", (Object)FontHelper.getFamily(_marker.getFont(), null)).style("font-size", (Object)FontHelper.getSize(_marker.getFont(), "12px")).style("font-weight", (Object)FontHelper.getWeight(_marker.getFont(), "normal")).style("font-style", (Object)FontHelper.getStyle(_marker.getFont(), "normal"));
            textSelection.text((Object)text);
            if (_marker.getShape() != null) {
                double x = 0.0;
                double y = 0.0;
                String dy = null;
                String textAnchor = null;
                double offsetFromShape = _marker.getShapeSize().calculatePx(0.0, 10.0) * 0.6 + 3.0;
                switch (_marker.getCaptionPosition()) {
                    case LEFT: {
                        x = -offsetFromShape;
                        dy = "5px";
                        textAnchor = "end";
                        break;
                    }
                    case RIGHT: {
                        x = offsetFromShape;
                        dy = "5px";
                        textAnchor = "start";
                        break;
                    }
                    case BOTTOM: {
                        y = offsetFromShape;
                        dy = "10px";
                        textAnchor = "middle";
                        break;
                    }
                    default: {
                        y = -offsetFromShape;
                        dy = "0";
                        textAnchor = "middle";
                    }
                }
                textSelection.attr("y", (Object)y).attr("dy", (Object)dy).attr("x", (Object)x).attr("text-anchor", (Object)textAnchor);
            }
        }
        return textSelection;
    }

    public static void applyMarkerProperties(Selector _selection, AbstractMarker _marker) {
        Selector shape = MarkerHelpers.renderShape(_selection, _marker);
        shape.style("fill", (Object)_marker.getFillColor()).style("stroke", (Object)_marker.getStrokeColor());
        MarkerHelpers.renderCaptionText(_selection, _marker);
    }
}

