/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.nativeImpl.util.ObjectConverter;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.CallbackFunction;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.selector.ValueFunction;
import com.ibm.vida.rave.core.svg.LinePathGenerator;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.LineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IPolyLineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.LineHelpers;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.common.PointImpl;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.PolyFitLine;
import java.util.ArrayList;
import java.util.List;

public class PolyFitLineRenderer
implements IRenderer<LineData> {
    private final LinePathGenerator _linePathGenerator;
    private final IPolyLineData _bundleData;
    private static final int INTERPOLATION_PX = 25;

    public PolyFitLineRenderer(IPolyLineData _bundleData) {
        this._linePathGenerator = Rave.svg.line.create();
        this._linePathGenerator.x((_context, _data, _index, _groupIndex) -> ((IPoint)_data).getX());
        this._linePathGenerator.y((_context, _data, _index, _groupIndex) -> ((IPoint)_data).getY());
        this._bundleData = _bundleData;
    }

    @Override
    public void render(SceneNode _el, LineData _item) throws DecorationError {
        Selector container = Rave.select((SceneNode)_el);
        final IPolyLineData bundleData = this._bundleData;
        IScales rScales = bundleData.getScales();
        final PolyFitLine line = (PolyFitLine)_item.getDecoration();
        ArrayList<PolyFitLine> arrData = new ArrayList<PolyFitLine>();
        arrData.add(line);
        Selector lineSelection = container.selectAll("." + line.getId()).data(arrData, (_context, _data, _index, _groupIndex) -> {
            PolyFitLine data = (PolyFitLine)_data;
            return data.getId();
        });
        boolean isHorizontal = _item.getAxis().contentEquals("x");
        IScales scales = !isHorizontal ? rScales : rScales.invert();
        List<List<IPoint>> coordinates = this._calculateCoordinates(line, scales);
        if (coordinates.isEmpty()) {
            container.remove();
            return;
        }
        lineSelection.enter().append("g").attr("class", (Object)line.getId());
        LinePathGenerator lpg = this._linePathGenerator;
        lpg.interpolate("basis");
        final Selector segmentSelection = lineSelection.selectAll(".segment").data(coordinates);
        segmentSelection.enter().append("path").attr("class", (Object)"segment");
        segmentSelection.attr("d", (ValueFunction)lpg).each((CallbackFunction)new CallbackFunction<SceneNode>(){

            public void run(SceneNode context, Object data, int index, int groupIndex) {
                LineHelpers.applyLineProperties(segmentSelection, (AbstractLine)line, bundleData.getProperties());
            }
        });
        segmentSelection.exit().remove();
    }

    protected List<List<IPoint>> _calculateCoordinates(PolyFitLine _line, IScales _scales) {
        ArrayList<List<IPoint>> coordinates = new ArrayList<List<IPoint>>();
        double[] params = _line.getParams();
        Scale xScale = _scales.getXScale();
        Scale yScale = _scales.getYScale();
        if (_scales.getXScale() == null || _scales.getYScale() == null) {
            return coordinates;
        }
        if (!xScale.isCategorical() && !yScale.isCategorical()) {
            List xDomain = xScale.getScale().domain();
            List yDomain = yScale.getScale().domain();
            List xRange = xScale.getScale().range();
            double rangeMin = ObjectConverter.toDouble(xRange.get(0));
            double rangeMax = ObjectConverter.toDouble(xRange.get(1));
            double rangePx = Math.abs(rangeMax - rangeMin);
            int steps = (int)Math.ceil(rangePx / 25.0);
            double yMax = ObjectConverter.toDouble(yDomain.get(yDomain.size() - 1));
            double yMin = ObjectConverter.toDouble(yDomain.get(0));
            double xMax = ObjectConverter.toDouble(xDomain.get(xDomain.size() - 1));
            double xMin = ObjectConverter.toDouble(xDomain.get(0));
            double step = (xMax - xMin) / (double)steps;
            boolean newSegment = true;
            ArrayList<PointImpl> currentSegment = null;
            for (int i = 0; i <= steps; ++i) {
                double xValue = ObjectConverter.toDouble(xDomain.get(0)) + (double)i * step;
                double yValue = 0.0;
                for (int j = 0; j < params.length; ++j) {
                    yValue += params[j] * Math.pow(xValue - _line.getCenter(), j);
                }
                if (yValue > yMax || yValue < yMin) {
                    newSegment = true;
                    continue;
                }
                if (newSegment) {
                    currentSegment = new ArrayList<PointImpl>();
                    coordinates.add(currentSegment);
                    newSegment = false;
                }
                double x = xScale.getDoubleValue(xValue);
                double y = yScale.getDoubleValue(yValue);
                currentSegment.add(new PointImpl(x, y));
            }
        }
        return coordinates;
    }
}

