/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.common.rendering.decorations.renderers.radar;

import com.ibm.vida.rave.core.Rave;
import com.ibm.vida.rave.core.scene.SceneNode;
import com.ibm.vida.rave.core.selector.Selector;
import com.ibm.vida.rave.core.svg.LinePathGenerator;
import com.ibm.vida.vizbundles.common.rendering.decorations.DecorationError;
import com.ibm.vida.vizbundles.common.rendering.decorations.IRenderer;
import com.ibm.vida.vizbundles.common.rendering.decorations.IScales;
import com.ibm.vida.vizbundles.common.rendering.decorations.LineData;
import com.ibm.vida.vizbundles.common.rendering.decorations.PositionTypeError;
import com.ibm.vida.vizbundles.common.rendering.decorations.Scale;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.IBaseLineRadarData;
import com.ibm.vida.vizbundles.common.rendering.decorations.renderers.LineHelpers;
import com.ibm.vida.vizbundles.extensions.common.IPoint;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLinePositionTypes;
import java.util.ArrayList;
import java.util.List;

public class RadarBaseLineRenderer
implements IRenderer<LineData> {
    private final IBaseLineRadarData _bundleData;
    private final LinePathGenerator _linePathGenerator;

    public RadarBaseLineRenderer(IBaseLineRadarData _bundleData) {
        this._bundleData = _bundleData;
        this._linePathGenerator = Rave.svg.line.create();
        this._linePathGenerator.x((_context, _data, _index, _groupIndex) -> ((IPoint)_data).getX());
        this._linePathGenerator.y((_context, _data, _index, _groupIndex) -> ((IPoint)_data).getY());
    }

    @Override
    public void render(SceneNode _el, LineData _lineData) throws DecorationError {
        BaseLine line = (BaseLine)_lineData.getDecoration();
        Selector container = Rave.select((SceneNode)_el);
        String className = line.getId();
        double position = line.getPositionValue();
        List<IPoint> coordinates = this.getCoords(position, line.getPositionType());
        if (coordinates == null || coordinates.size() < 2) {
            container.remove();
            return;
        }
        Object[] arrData = new String[]{className};
        Selector lineSelection = container.selectAll("." + className).data(arrData);
        lineSelection.enter().append("path").attr("class", (Object)className);
        lineSelection.attr("d", (Object)(this._linePathGenerator.getValue(null, coordinates, 0, 0) + "Z"));
        LineHelpers.applyLineProperties(lineSelection, (AbstractLine)line, this._bundleData.getProperties());
    }

    private List<IPoint> getCoords(double _position, BaseLinePositionTypes _posType) throws PositionTypeError {
        IScales scales = this._bundleData.getScales();
        Scale xScale = scales.getXScale();
        Scale yScale = scales.getYScale();
        if (xScale == null || yScale == null) {
            return new ArrayList<IPoint>();
        }
        switch (_posType) {
            case DATA_VALUE: {
                return this._bundleData.getAbsoluteCoordinates(xScale, yScale, _position);
            }
            case RELATIVE_PCT: 
            case STATIC_PCT: {
                return this._bundleData.getRelativeCoordinates(xScale, yScale, _position);
            }
        }
        throw new PositionTypeError(_posType, "RadarBaseline");
    }
}

