/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vida.vizbundles.extensions.decorations.lines;

import com.ibm.vida.vizbundles.extensions.decorations.DecorationType;
import com.ibm.vida.vizbundles.extensions.decorations.lines.AbstractLine;
import com.ibm.vida.vizbundles.extensions.decorations.lines.BaseLinePositionTypes;
import com.ibm.vida.vizbundles.extensions.decorations.lines.Crosshair;
import com.ibm.vida.vizbundles.extensions.decorations.lines.Grabber;
import com.ibm.vida.vizbundles.extensions.decorations.lines.GrabberPositionType;
import com.ibm.vida.vizbundles.extensions.decorations.lines.Vane;

public class BaseLine
extends AbstractLine {
    private double position;
    private BaseLinePositionTypes positionType;
    private Vane vane;
    private Grabber grabber;
    private Crosshair crosshair;
    private boolean isCrosshairVisible;
    private boolean isGrabberVisible;
    private boolean isVaneVisible;

    public BaseLine(String _id, double _position, BaseLinePositionTypes _positionType) {
        super("baseline_" + _id, 1, DecorationType.BASELINE);
        this.position = _position;
        this.positionType = _positionType;
        this.crosshair = new Crosshair("baseline_" + _id + "_crosshair", this);
        this.grabber = new Grabber("baseline_" + _id + "_grabber", this, GrabberPositionType.BEGIN);
        this.vane = new Vane("baseline_" + _id + "_vane", this);
        this.isCrosshairVisible = false;
        this.isGrabberVisible = false;
        this.isVaneVisible = false;
    }

    public BaseLine setPosition(double _position, BaseLinePositionTypes _positionType) {
        this.position = _position;
        this.positionType = _positionType;
        return this;
    }

    public double getPositionValue() {
        return this.position;
    }

    public BaseLinePositionTypes getPositionType() {
        return this.positionType;
    }

    public Vane getVane() {
        return this.vane;
    }

    public Grabber getGrabber() {
        return this.grabber;
    }

    public Crosshair getCrosshair() {
        return this.crosshair;
    }

    public BaseLine showCrosshair(boolean _show) {
        this.isCrosshairVisible = _show;
        return this;
    }

    public BaseLine showGrabber(boolean _show) {
        this.isGrabberVisible = _show;
        return this;
    }

    public BaseLine showVane(boolean _show) {
        this.isVaneVisible = _show;
        return this;
    }

    public boolean isCrosshairVisible() {
        return this.isCrosshairVisible;
    }

    public boolean isGrabberVisible() {
        return this.isGrabberVisible;
    }

    public boolean isVaneVisible() {
        return this.isVaneVisible;
    }
}

