/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.lobdata;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.PropertyResourceBundle;

public class CommandLineParser {
    private String cfgfilepath = null;
    private String dispURI = null;
    private String dbusername = null;
    private String dbpassword = null;
    private String dbport = null;

    public void parse(String[] args) {
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing arguments: no arguments provided");
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareToIgnoreCase("-f") == 0) {
                this.cfgfilepath = args[++i];
                continue;
            }
            if (args[i].compareToIgnoreCase("-uri") == 0) {
                this.dispURI = args[++i];
                continue;
            }
            if (args[i].compareToIgnoreCase("-port") == 0) {
                this.dbport = args[++i];
                continue;
            }
            if (args[i].compareToIgnoreCase("-u") == 0) {
                this.dbusername = args[++i];
                continue;
            }
            if (args[i].compareToIgnoreCase("-p") != 0) continue;
            this.dbpassword = args[++i];
        }
        if (this.cfgfilepath == null || this.cfgfilepath.isEmpty()) {
            this.checkRequiredParameter("-uri", this.dispURI);
            this.checkRequiredParameter("-port", this.dbport);
            this.checkRequiredParameter("-u", this.dbusername);
            this.checkRequiredParameter("-p", this.dbpassword);
        }
    }

    private void checkRequiredParameter(String name, String value) throws IllegalArgumentException {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Missing argument: " + name);
        }
    }

    public String getURI() {
        return this.dispURI;
    }

    public String getDBPort() {
        return this.dbport;
    }

    public String getDBUserName() {
        return this.dbusername;
    }

    public String getDBPassword() {
        return this.dbpassword;
    }

    public String getCfgFilePath() {
        return this.cfgfilepath;
    }

    public void readConfiguration() throws IOException {
        FileInputStream fis = new FileInputStream(this.getCfgFilePath());
        PropertyResourceBundle bundle = new PropertyResourceBundle(fis);
        if (bundle.containsKey("DB2_USERNAME")) {
            this.dbusername = bundle.getString("DB2_USERNAME");
        }
        if (bundle.containsKey("DB2_PASSWORD")) {
            this.dbpassword = bundle.getString("DB2_PASSWORD");
        }
        if (bundle.containsKey("DB2_PORT")) {
            this.dbport = bundle.getString("DB2_PORT");
        }
        if (bundle.containsKey("internalDispatcher")) {
            this.dispURI = bundle.getString("internalDispatcher");
        }
        this.checkRequiredParameter("internalDispatcher", this.dispURI);
        this.checkRequiredParameter("DB2_PORT", this.dbport);
        this.checkRequiredParameter("DB2_USERNAME", this.dbusername);
        this.checkRequiredParameter("DB2_PASSWORD", this.dbpassword);
    }
}

