/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.lobdata;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.AnyURIArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.DataSource;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.DataSourceSignon;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.Nil;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.ibm.cognos.lobdata.CommandLineParser;
import java.io.IOException;
import java.net.URL;
import org.apache.axis.client.Stub;

public class MyDataSetsDataSource {
    private ContentManagerService_PortType cmService;
    private static final String DATA_SOURCE_NAME = "MyDataSetsRepository";
    private CommandLineParser cliParser;

    public void connect() throws Exception {
        String endPoint = this.cliParser.getURI();
        try {
            ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
            this.cmService = cmServiceLocator.getcontentManagerService(new URL(endPoint));
            System.out.println("Connected to Dispatcher at: " + endPoint);
        }
        catch (Exception e) {
            System.out.println("Failed to connect to Dispatcher.");
            System.exit(1);
        }
    }

    public void quickLogon() {
        try {
            CAM cam = new CAM();
            cam.setAction("logon");
            HdrSession header = new HdrSession();
            BiBusHeader bibus = new BiBusHeader();
            bibus.setCAM(cam);
            bibus.setHdrSession(header);
            ((Stub)this.cmService).setHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader", (Object)bibus);
        }
        catch (Exception e) {
            System.out.println("Failed to log on as Anonymous user.");
        }
    }

    public void createDataSource(String dataSourceConnectionString) throws Exception {
        DataSource dataSource = new DataSource();
        TokenProp tp = new TokenProp();
        tp.setValue(DATA_SOURCE_NAME);
        dataSource.setDefaultName(tp);
        AnyURIArrayProp capabilities = new AnyURIArrayProp();
        capabilities.setValue(new String[]{"http://developer.cognos.com/ceba/constants/dataSourceCapabilityEnum#reporting", "http://developer.cognos.com/ceba/constants/dataSourceCapabilityEnum#lobData"});
        dataSource.setCapabilities(capabilities);
        DataSourceConnection dataSourceConnection = new DataSourceConnection();
        dataSourceConnection.setDefaultName(tp);
        StringProp s = new StringProp();
        s.setValue(dataSourceConnectionString);
        dataSourceConnection.setConnectionString(s);
        AddOptions addOptions = new AddOptions();
        addOptions.setUpdateAction(UpdateActionEnum.replace);
        this.cmService.add(new SearchPathSingleObject("CAMID(\":\")"), new BaseClass[]{dataSource}, addOptions);
        this.cmService.add(new SearchPathSingleObject("CAMID(\":\")/dataSource[@name='MyDataSetsRepository']"), new BaseClass[]{dataSourceConnection}, addOptions);
    }

    public void createsignon() throws Exception {
        String dsConnection = "CAMID(\":\")/dataSource[@name='MyDataSetsRepository']/dataSourceConnection[@name='MyDataSetsRepository']";
        PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.user, PropEnum.credentials, PropEnum.searchPath, PropEnum.version, PropEnum.consumers};
        DataSourceSignon newdsSignon = new DataSourceSignon();
        BaseClassArrayProp cons = new BaseClassArrayProp();
        BaseClass[] oConsumers = new BaseClass[1];
        Nil c1 = new Nil();
        StringProp sp = new StringProp();
        sp.setValue("CAMID(\"::Everyone\")");
        c1.setSearchPath(sp);
        oConsumers[0] = c1;
        cons.setValue(oConsumers);
        newdsSignon.setConsumers(cons);
        AnyTypeProp credentials = new AnyTypeProp();
        String credString = "<credential><username>" + this.getDbusername() + "</username><password>" + this.getDbpassword() + "</password></credential>";
        credentials.setValue(credString);
        newdsSignon.setCredentials(credentials);
        TokenProp tp = new TokenProp();
        tp.setValue(DATA_SOURCE_NAME);
        newdsSignon.setDefaultName(tp);
        SearchPathMultipleObject dsConnSearchPobj = new SearchPathMultipleObject();
        dsConnSearchPobj.set_value(dsConnection);
        BaseClass[] bc = this.cmService.query(dsConnSearchPobj, props, new Sort[0], new QueryOptions());
        BaseClassArrayProp bcap = new BaseClassArrayProp();
        bcap.setValue(bc);
        newdsSignon.setParent(bcap);
        AddOptions ao = new AddOptions();
        ao.setUpdateAction(UpdateActionEnum.replace);
        SearchPathSingleObject newObject = new SearchPathSingleObject();
        newObject.set_value(bc[0].getSearchPath().getValue());
        this.cmService.add(newObject, new BaseClass[]{newdsSignon}, ao);
    }

    public static void main(String[] args) {
        MyDataSetsDataSource dscreate = new MyDataSetsDataSource();
        try {
            dscreate.parse(args);
        }
        catch (Exception ex) {
            System.out.println("error: " + ex.getMessage());
            System.out.println("Please provide either the Path to a configuration file or the Dispatcher portnumber, DB username and password in order to proceed.");
            System.out.println("Usage: -f filename | -uri <disp internal uri> -port <db2 port#> -u db2username -p password");
            System.exit(1);
        }
        String dataSourceConnectionString = "^User ID:^?Password:;LOCAL;JDBC;URL=jdbc:db2://localhost:" + dscreate.getDbPort() + "/CognosDS" + ";DRIVER_NAME=com.ibm.db2.jcc.DB2Driver";
        System.out.println("dataSourceConnectionString=" + dataSourceConnectionString);
        try {
            dscreate.connect();
            dscreate.quickLogon();
            dscreate.createDataSource(dataSourceConnectionString);
            dscreate.createsignon();
            System.out.println("Successfully created the data source for My Data Sets repository.");
        }
        catch (Exception ex) {
            System.out.println("Encountered an error: ");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void parse(String[] args) throws IOException {
        if (this.cliParser == null) {
            this.cliParser = new CommandLineParser();
        }
        this.cliParser.parse(args);
        if (this.cliParser.getCfgFilePath() != null && !this.cliParser.getCfgFilePath().isEmpty()) {
            this.cliParser.readConfiguration();
        }
    }

    public String getDbPort() {
        return this.cliParser.getDBPort();
    }

    public String getDbusername() {
        return this.cliParser.getDBUserName();
    }

    public String getDbpassword() {
        return this.cliParser.getDBPassword();
    }
}

