/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.attachments;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.activation.DataHandler;
import org.apache.wsif.WSIFException;
import org.apache.wsif.logging.Trc;

public class WSIFAttachmentPart
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private transient DataHandler dh;
    private Map properties;

    public WSIFAttachmentPart() {
        Trc.entry(this);
        this.dh = null;
        this.properties = new HashMap();
        Trc.exit();
    }

    public WSIFAttachmentPart(DataHandler dataHandler) {
        Trc.entry((Object)this, dataHandler);
        this.dh = dataHandler;
        this.properties = new HashMap();
        Trc.exit();
    }

    public WSIFAttachmentPart(Object object) {
        Trc.entry((Object)this, object);
        this.dh = (DataHandler)object;
        this.properties = new HashMap();
        Trc.exit();
    }

    public WSIFAttachmentPart(DataHandler dataHandler, Map map) throws WSIFException {
        Trc.entry(this, dataHandler, map);
        this.validateProperties(map);
        this.dh = dataHandler;
        this.properties = map;
        Trc.exit();
    }

    public void setProperty(String string, String string2) throws WSIFException {
        Trc.entry(this, string, string2);
        this.properties.put(string, string2);
        Trc.exit();
    }

    public void setProperties(Map map) throws WSIFException {
        Trc.entry((Object)this, map);
        this.validateProperties(map);
        map.putAll(map);
        Trc.exit();
    }

    public String getProperty(String string) {
        Trc.entry((Object)this, string);
        String string2 = (String)this.properties.get(string);
        Trc.exit(string2);
        return string2;
    }

    public boolean containsProperty(String string) {
        Trc.entry((Object)this, string);
        boolean bl = this.properties.containsKey(string);
        Trc.exit(bl);
        return bl;
    }

    public Iterator getPropertyIterator() {
        Trc.entry(this);
        Iterator iterator = this.properties.keySet().iterator();
        Trc.exit(iterator);
        return iterator;
    }

    public void clearProperties() {
        Trc.entry(this);
        this.properties = new HashMap();
        Trc.exit();
    }

    public DataHandler getDataHandler() {
        Trc.entry(this);
        Trc.exit(this.dh);
        return this.dh;
    }

    public void setDataHandler(DataHandler dataHandler) {
        Trc.entry((Object)this, dataHandler);
        this.dh = dataHandler;
        Trc.exit();
    }

    private void validateProperties(Map map) throws WSIFException {
        Trc.entry((Object)this, map);
        for (String string : map.keySet()) {
            if (map.get(string) instanceof String) continue;
            throw new WSIFException("Property " + string + " was not a String.");
        }
        Trc.exit();
    }

    public Object clone() throws CloneNotSupportedException {
        Trc.entry(this);
        DataHandler dataHandler = new DataHandler(this.dh.getDataSource());
        HashMap hashMap = new HashMap(this.properties);
        WSIFAttachmentPart wSIFAttachmentPart = null;
        try {
            wSIFAttachmentPart = new WSIFAttachmentPart(dataHandler, hashMap);
        }
        catch (WSIFException wSIFException) {
            Trc.exception(wSIFException);
            throw new CloneNotSupportedException(wSIFException.toString());
        }
        Trc.exit(wSIFAttachmentPart);
        return wSIFAttachmentPart;
    }
}

