/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.providers.WSIFDynamicTypeMapping;
import org.apache.wsif.util.WSIFUtils;

public class WSIFClientProxy
implements InvocationHandler {
    protected Class iface = null;
    protected Definition def = null;
    protected String serviceNS = null;
    protected String serviceName = null;
    protected String portTypeNS = null;
    protected String portTypeName = null;
    protected WSIFDynamicTypeMap typeMap = null;
    protected Map simpleTypeReg = null;
    protected PortType portType = null;
    protected WSIFPort wsifport = null;
    protected Object proxy = null;
    private Map wsdlOperationTable = null;

    public static WSIFClientProxy newInstance(Class clazz, Definition definition, String string, String string2, String string3, String string4, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(null, clazz, definition, string, string2, string3, string4, wSIFDynamicTypeMap);
        if (!clazz.isInterface()) {
            throw new WSIFException("Cannot get a stub for " + clazz + " because it is not an interface");
        }
        WSIFClientProxy wSIFClientProxy = new WSIFClientProxy(clazz, definition, string, string2, string3, string4, wSIFDynamicTypeMap);
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)wSIFClientProxy);
        wSIFClientProxy.setProxy(object);
        if (Trc.ON) {
            Trc.exit(wSIFClientProxy.deep());
        }
        return wSIFClientProxy;
    }

    private WSIFClientProxy(Class clazz, Definition definition, String string, String string2, String string3, String string4, WSIFDynamicTypeMap wSIFDynamicTypeMap) throws WSIFException {
        Trc.entry(this, clazz, definition, string, string2, string3, string4, wSIFDynamicTypeMap);
        this.iface = clazz;
        this.def = definition;
        this.serviceNS = string;
        this.serviceName = string2;
        this.portTypeNS = string3;
        this.portTypeName = string4;
        this.typeMap = wSIFDynamicTypeMap;
        this.portType = WSIFUtils.selectPortType(definition, string3, string4);
        this.simpleTypeReg = WSIFUtils.getSimpleTypesMap();
        this.wsdlOperationTable = new HashMap();
        Trc.exit();
    }

    private void setProxy(Object object) {
        this.proxy = object;
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void setPort(WSIFPort wSIFPort) {
        Trc.entry((Object)this, wSIFPort);
        this.wsifport = wSIFPort;
        Trc.exit();
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        List list;
        Part part;
        Object object2;
        Object object3;
        List list2;
        Serializable serializable;
        Object object4;
        String string;
        Trc.entry(this, method, objectArray);
        Operation operation = this.findMatchingOperation(method, objectArray);
        Input input = operation.getInput();
        Output output = operation.getOutput();
        String string2 = input == null ? null : input.getName();
        String string3 = output == null ? null : output.getName();
        Message message = input == null ? null : input.getMessage();
        Message message2 = output == null ? null : output.getMessage();
        WSIFOperation wSIFOperation = this.wsifport.createOperation(method.getName(), string2, string3);
        String string4 = "";
        if (input != null && (string = input.getMessage()) != null) {
            object4 = string.getQName();
            string4 = object4 == null ? "" : ((QName)object4).getLocalPart();
        }
        string = "";
        if (output != null && (object4 = output.getMessage()) != null) {
            serializable = object4.getQName();
            string = serializable == null ? "" : ((QName)serializable).getLocalPart();
        }
        object4 = wSIFOperation.createInputMessage(string4);
        serializable = null;
        WSIFMessage wSIFMessage = null;
        if (output != null) {
            serializable = wSIFOperation.createOutputMessage(string4);
            wSIFMessage = wSIFOperation.createFaultMessage(string4);
        }
        boolean bl = false;
        List list3 = list2 = message == null ? new ArrayList() : message.getOrderedParts(null);
        if (objectArray != null) {
            bl = this.unWrapIfRequired(operation.getName(), list2, objectArray);
            object3 = list2.iterator();
            int n = 0;
            while (object3.hasNext()) {
                object2 = (Part)object3.next();
                part = object2.getName();
                object4.setObjectPart((String)part, objectArray[n]);
                ++n;
            }
        }
        if (output == null) {
            wSIFOperation.executeInputOnlyOperation((WSIFMessage)object4);
        } else {
            boolean bl2 = wSIFOperation.executeRequestResponseOperation((WSIFMessage)object4, (WSIFMessage)serializable, wSIFMessage);
            if (!bl2) {
                Iterator iterator = wSIFMessage.getParts();
                if (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (object2 instanceof Throwable) {
                        part = method.getExceptionTypes();
                        for (int i = 0; i < ((Class<?>[])part).length; ++i) {
                            if (!part[i].isAssignableFrom(object2.getClass())) continue;
                            throw (Throwable)object2;
                        }
                        throw new WSIFException("Operation failed, fault message contains a non-declared throwable", (Throwable)object2);
                    }
                    throw new WSIFException("Operation failed and a non-throwable fault message part was returned: " + object2);
                }
                throw new WSIFException("Operation failed but returned fault message contained no part");
            }
        }
        object3 = null;
        if (message2 != null && (list = message2.getOrderedParts(null)) != null && list.size() > 0) {
            if (bl || this.isWrappedInContext()) {
                this.unwrap(operation.getName() + "Response", list);
            }
            object2 = list.iterator();
            part = (Part)object2.next();
            object3 = serializable.getObjectPart(part.getName());
            if (object2.hasNext()) {
                Object[] objectArray2 = message.getOrderedParts(null).toArray();
                Part part2 = (Part)object2.next();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!((Part)objectArray2[i]).getName().equals(part2.getName())) continue;
                    objectArray[i] = serializable.getObjectPart(part2.getName());
                    if (!object2.hasNext()) break;
                    part2 = (Part)object2.next();
                }
            }
        }
        Trc.exit(object3);
        return object3;
    }

    private Operation findMatchingOperation(Method method, Object[] objectArray) throws WSIFException {
        Object object;
        int n;
        String string = this.createWSDLOperationKey(method, objectArray);
        Operation operation = (Operation)this.wsdlOperationTable.get(string);
        if (operation != null) {
            return operation;
        }
        Method[] methodArray = this.iface.getMethods();
        for (n = 0; n < methodArray.length && !methodArray[n].equals(method); ++n) {
        }
        if (n >= methodArray.length || !method.equals(methodArray[n])) {
            throw new WSIFException("Method " + method.getName() + " is not in interface " + this.iface.getName());
        }
        String string2 = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        List list = this.portType.getOperations();
        Iterator iterator = list.iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            object = (Operation)iterator.next();
            if (!string2.equalsIgnoreCase(object.getName())) continue;
            Input input = object.getInput();
            Message message = input == null ? null : input.getMessage();
            List list2 = message == null ? new ArrayList() : message.getOrderedParts(null);
            int n2 = list2.size();
            if (n2 == 0 && classArray.length == 0) {
                this.wsdlOperationTable.put(string, object);
                return object;
            }
            if (this.isWrappedInContext() || classArray != null && n2 != classArray.length) {
                if (!ProviderUtils.isUnwrapable(object)) continue;
                this.unWrapIfRequired(object.getName(), list2, objectArray);
                n2 = list2.size();
                if (n2 != classArray.length) continue;
            }
            Iterator iterator2 = list2.iterator();
            boolean bl = true;
            boolean bl2 = true;
            int n3 = 0;
            while (iterator2.hasNext() && bl) {
                Serializable serializable;
                Part part = (Part)iterator2.next();
                QName qName = part.getTypeName();
                if (qName == null) {
                    qName = part.getElementName();
                }
                QName qName2 = new QName(qName.getNamespaceURI(), ">" + qName.getLocalPart());
                boolean bl3 = false;
                boolean bl4 = false;
                Object object3 = this.typeMap.iterator();
                while (object3.hasNext() && !bl3) {
                    serializable = (WSIFDynamicTypeMapping)object3.next();
                    if (!((WSIFDynamicTypeMapping)serializable).getXmlType().equals(qName) && !((WSIFDynamicTypeMapping)serializable).getXmlType().equals(qName2) || !((WSIFDynamicTypeMapping)serializable).getJavaType().isAssignableFrom(classArray[n3]) && (objectArray[n3] == null || !((WSIFDynamicTypeMapping)serializable).getJavaType().isAssignableFrom(objectArray[n3].getClass()))) continue;
                    bl3 = true;
                    if (!((WSIFDynamicTypeMapping)serializable).getJavaType().equals(classArray[n3]) && (objectArray[n3] == null || !((WSIFDynamicTypeMapping)serializable).getJavaType().equals(objectArray[n3].getClass()))) continue;
                    bl4 = true;
                }
                object3 = (String)this.simpleTypeReg.get(qName);
                if (!bl3) {
                    if (object3 != null) {
                        if (classArray[n3].toString().equals(object3)) {
                            bl3 = true;
                            bl4 = true;
                        } else {
                            try {
                                serializable = Class.forName((String)object3, true, Thread.currentThread().getContextClassLoader());
                                if (((Class)serializable).isAssignableFrom(classArray[n3])) {
                                    bl3 = true;
                                    if (serializable.equals(classArray[n3])) {
                                        bl4 = true;
                                    }
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                Trc.ignoredException(classNotFoundException);
                            }
                        }
                    } else if (classArray[n3].equals(DataHandler.class)) {
                        bl3 = true;
                    }
                }
                if (!bl3) {
                    bl = false;
                }
                if (!bl4) {
                    bl2 = false;
                }
                ++n3;
            }
            if (!bl) continue;
            if (bl2) {
                this.wsdlOperationTable.put(string, object);
                return object;
            }
            object2 = object;
        }
        if (object2 != null) {
            this.wsdlOperationTable.put(string, object2);
            return object2;
        }
        object = new String();
        if (classArray != null) {
            for (n = 0; n < classArray.length; ++n) {
                if (n != 0) {
                    object = (String)object + ", ";
                }
                object = (String)object + classArray[n];
            }
        }
        throw new WSIFException("Method " + string2 + "(" + (String)object + ") was not found in portType " + this.portType.getQName());
    }

    private String createWSDLOperationKey(Method method, Object[] objectArray) {
        int n;
        Trc.entry(this, method, objectArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName()).append(":");
        Class<?>[] classArray = method.getParameterTypes();
        for (n = 0; n < classArray.length; ++n) {
            stringBuffer.append(classArray[n].getName()).append(":");
        }
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] == null) {
                    stringBuffer.append("null");
                } else {
                    stringBuffer.append(objectArray[n].getClass().getName());
                }
                stringBuffer.append(":");
            }
        }
        Trc.exit(stringBuffer.toString());
        return stringBuffer.toString();
    }

    private String createWSIFOperationKey(String string, String string2, String string3) {
        Trc.entry(this, string, string2, string3);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(string2).append(string3);
        Trc.exit(stringBuffer.toString());
        return stringBuffer.toString();
    }

    protected boolean isUnwrapRequired() {
        boolean bl = false;
        try {
            WSIFMessage wSIFMessage = this.wsifport.getContext();
            String string = (String)wSIFMessage.getObjectPart("org.apache.wsif.axis.operationStyle");
            bl = "wrapped".equals(string);
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        return bl;
    }

    private boolean unWrapIfRequired(String string, List list, Object[] objectArray) throws WSIFException {
        boolean bl = false;
        boolean bl2 = this.isWrappedInContext();
        if (!bl2) {
            boolean bl3 = bl2 = objectArray.length != list.size();
        }
        if (bl2) {
            bl = this.unwrap(string, list);
        }
        return bl;
    }

    private boolean unwrap(String string, List list) throws WSIFException {
        boolean bl = false;
        Part part = ProviderUtils.getWrapperPart(list, string);
        if (part != null) {
            List list2 = ProviderUtils.unWrapPart(part, this.def, this.wsifport.getContext());
            list.remove(part);
            list.addAll(list2);
            bl = true;
        }
        return bl;
    }

    private boolean isWrappedInContext() throws WSIFException {
        WSIFMessage wSIFMessage = this.wsifport.getContext();
        String string = null;
        try {
            string = (String)wSIFMessage.getObjectPart("org.apache.wsif.axis.operationStyle");
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        boolean bl = "wrapped".equals(string);
        return bl;
    }

    public String deep() {
        String string = "";
        try {
            string = new String(this.toString() + "\n");
            string = string + "iface: " + this.iface;
            string = string + " def: " + Trc.brief(this.def);
            string = string + " serviceNS: " + this.serviceNS;
            string = string + " serviceName: " + this.serviceName;
            string = string + " portTypeNS: " + this.portTypeNS;
            string = string + " portTypeName: " + this.portTypeName;
            string = string + " typeMap: " + this.typeMap;
            string = string + "\nsimpleTypeReg: " + this.simpleTypeReg;
            string = string + "\nportType: " + Trc.brief(this.portType);
            string = string + " wsifport: " + this.wsifport;
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

