/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFCorrelationService;
import org.apache.wsif.WSIFException;
import org.apache.wsif.base.WSIFObjectInputStream;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;

public class WSIFDefaultCorrelationService
implements WSIFCorrelationService {
    private HashMap correlatorStore;
    private HashMap timeouts;
    private Thread timeoutWatcher;
    private boolean shutdown;

    public WSIFDefaultCorrelationService() {
        Trc.entry(this);
        Trc.exit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void put(WSIFCorrelationId wSIFCorrelationId, Serializable serializable, long l) throws WSIFException {
        Trc.entry(this, wSIFCorrelationId, serializable, new Long(l));
        if (wSIFCorrelationId == null || serializable == null) throw new IllegalArgumentException("cannot put null " + (wSIFCorrelationId == null ? "correlator" : "state"));
        if (this.correlatorStore == null) {
            this.initialise();
        }
        try {
            this.correlatorStore.put(wSIFCorrelationId, this.serialize(serializable));
            if (l > 0L) {
                if (this.timeouts == null) {
                    this.initTimeouts();
                }
                this.timeouts.put(wSIFCorrelationId, new Long(System.currentTimeMillis() + l));
            }
        }
        catch (IOException iOException) {
            Trc.exception(iOException);
            throw new WSIFException(iOException.toString());
        }
        Trc.exit();
    }

    public synchronized Serializable get(WSIFCorrelationId wSIFCorrelationId) throws WSIFException {
        Trc.entry((Object)this, wSIFCorrelationId);
        if (this.correlatorStore == null) {
            throw new WSIFException("get called on correlation service but put never done");
        }
        if (wSIFCorrelationId == null) {
            throw new IllegalArgumentException("cannot get null");
        }
        try {
            Serializable serializable = (Serializable)this.unserialize((byte[])this.correlatorStore.get(wSIFCorrelationId));
            Trc.exit(serializable);
            return serializable;
        }
        catch (Exception exception) {
            Trc.exception(exception);
            throw new WSIFException(exception.toString());
        }
    }

    public synchronized void remove(WSIFCorrelationId wSIFCorrelationId) throws WSIFException {
        Trc.entry((Object)this, wSIFCorrelationId);
        if (this.correlatorStore == null) {
            throw new WSIFException("corelation service has been shutdown");
        }
        if (wSIFCorrelationId == null) {
            throw new IllegalArgumentException("cannot remove null");
        }
        this.correlatorStore.remove(wSIFCorrelationId);
        if (this.timeouts != null) {
            this.timeouts.remove(wSIFCorrelationId);
        }
        Trc.exit();
    }

    private synchronized void remove(ArrayList arrayList) {
        Trc.entry((Object)this, arrayList);
        if (arrayList != null && this.correlatorStore != null) {
            for (Serializable serializable : arrayList) {
                this.correlatorStore.remove(serializable);
                this.timeouts.remove(serializable);
                MessageLogger.log("WSIF.0008W", serializable);
            }
        }
        Trc.exit();
    }

    public void shutdown() {
        Trc.entry(this);
        this.shutdown = true;
        Trc.exit();
    }

    private void initialise() {
        this.shutdown = false;
        this.correlatorStore = new HashMap();
    }

    private void initTimeouts() {
        this.timeouts = new HashMap();
        this.timeoutWatcher = new Thread(){

            public void run() {
                while (!WSIFDefaultCorrelationService.this.shutdown) {
                    try {
                        1.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Trc.ignoredException(interruptedException);
                    }
                    WSIFDefaultCorrelationService.this.checkForTimeouts();
                }
                if (WSIFDefaultCorrelationService.this.correlatorStore != null) {
                    WSIFDefaultCorrelationService.this.correlatorStore = null;
                }
                if (WSIFDefaultCorrelationService.this.timeouts != null) {
                    WSIFDefaultCorrelationService.this.timeouts = null;
                }
            }
        };
        this.timeoutWatcher.setName("WSIFDefaultCorrelationService timeout watcher");
        this.timeoutWatcher.start();
    }

    private void checkForTimeouts() {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        Long l = new Long(System.currentTimeMillis());
        try {
            for (Serializable serializable : this.timeouts.keySet()) {
                Long l2 = (Long)this.timeouts.get(serializable);
                if (l.compareTo(l2) <= 0) continue;
                arrayList.add(serializable);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            Trc.ignoredException(concurrentModificationException);
        }
        if (arrayList.size() > 0) {
            this.remove(arrayList);
        }
    }

    private byte[] serialize(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(object);
        objectOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    private Object unserialize(byte[] byArray) throws IOException, ClassNotFoundException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        WSIFObjectInputStream wSIFObjectInputStream = new WSIFObjectInputStream(byteArrayInputStream);
        return wSIFObjectInputStream.readObject();
    }
}

