/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Message;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.base.WSIFObjectInputStream;
import org.apache.wsif.logging.Trc;

public class WSIFDefaultMessage
implements WSIFMessage {
    private static final long serialVersionUID = 1L;
    protected Map parts;
    protected String name;
    protected String style;
    protected Message msgDefinition;

    public WSIFDefaultMessage() {
        Trc.entry(this);
        Trc.exit();
    }

    public String getName() {
        Trc.entry(this);
        Trc.exit(this.name);
        return this.name;
    }

    public void setName(String string) {
        Trc.entry((Object)this, string);
        this.name = string;
        Trc.exit();
    }

    public String getRepresentationStyle() {
        Trc.entry(this);
        Trc.exit(this.style);
        return this.style;
    }

    public void setRepresentationStyle(String string) {
        Trc.entry((Object)this, string);
        this.style = string;
        Trc.exit();
    }

    public Iterator getParts() {
        Trc.entry(this);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        Iterator iterator = this.parts.values().iterator();
        Trc.exit(iterator);
        return iterator;
    }

    public void setParts(Map map) {
        Trc.entry((Object)this, map);
        if (this.parts == null) {
            this.parts = new HashMap();
        } else {
            this.parts.clear();
        }
        for (String string : map.keySet()) {
            Object v = map.get(string);
            this.parts.put(string, v);
        }
        Trc.exit();
    }

    public Message getMessageDefinition() {
        Trc.entry(this);
        Trc.exit(this.msgDefinition);
        return this.msgDefinition;
    }

    public void setMessageDefinition(Message message) {
        Trc.entry((Object)this, this.msgDefinition);
        this.msgDefinition = message;
        Trc.exit();
    }

    public void setObjectPart(String string, Object object) throws WSIFException {
        Trc.entry(this, string, object);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, object);
        Trc.exit();
    }

    public Object getObjectPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "Object");
            Trc.exit(null);
            return null;
        }
        if (this.parts.get(string) == null) {
            if (!this.parts.keySet().contains(string)) {
                this.handlePartNotFoundException(string);
            }
            Trc.exit(null);
            return null;
        }
        Object v = this.parts.get(string);
        Trc.exit(v);
        return v;
    }

    public Object getObjectPart(String string, Class clazz) throws WSIFException {
        Trc.entry(this, string, clazz);
        if (this.parts == null) {
            this.handleNoPartsException(string, "Object");
            Trc.exit(null);
            return null;
        }
        Object v = this.parts.get(string);
        if (v == null) {
            if (!this.parts.keySet().contains(string)) {
                this.handlePartNotFoundException(string);
            }
            Trc.exit(null);
            return null;
        }
        if (v.getClass().getName().equals(clazz.getName())) {
            Trc.exit(v);
            return v;
        }
        this.handleSourcedPartNotFoundException(string, clazz);
        Trc.exit(null);
        return null;
    }

    public byte getBytePart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "byte");
        }
        try {
            byte by = (Byte)this.parts.get(string);
            Trc.exit(by);
            return by;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Byte");
            Trc.exit(0);
            return 0;
        }
    }

    public void setBytePart(String string, byte by) {
        Trc.entry(this, string, new Byte(by));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Byte(by));
        Trc.exit();
    }

    public char getCharPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "char");
        }
        try {
            char c = ((Character)this.parts.get(string)).charValue();
            Trc.exit(c);
            return c;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return '\u0000';
        }
        catch (ClassCastException classCastException) {
            try {
                String string2 = (String)this.parts.get(string);
                if (string2 != null && string2.length() == 1) {
                    char c = string2.charAt(0);
                    Trc.exit(c);
                    return c;
                }
                throw classCastException;
            }
            catch (ClassCastException classCastException2) {
                Trc.exception(classCastException);
                this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Character");
                Trc.exit(0);
                return '\u0000';
            }
        }
    }

    public void setCharPart(String string, char c) {
        Trc.entry(this, string, new Character(c));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Character(c));
        Trc.exit();
    }

    public int getIntPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "int");
        }
        try {
            int n = (Integer)this.parts.get(string);
            Trc.exit(n);
            return n;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Integer");
            Trc.exit(0);
            return 0;
        }
    }

    public void setIntPart(String string, int n) {
        Trc.entry(this, string, new Integer(n));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Integer(n));
        Trc.exit();
    }

    public long getLongPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "long");
        }
        try {
            long l = (Long)this.parts.get(string);
            Trc.exit(new Long(l));
            return l;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return 0L;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Long");
            Trc.exit(0);
            return 0L;
        }
    }

    public void setLongPart(String string, long l) {
        Trc.entry(this, string, new Long(l));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Long(l));
        Trc.exit();
    }

    public short getShortPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "short");
        }
        try {
            short s = (Short)this.parts.get(string);
            Trc.exit(s);
            return s;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return 0;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Short");
            Trc.exit(0);
            return 0;
        }
    }

    public void setShortPart(String string, short s) {
        Trc.entry(this, string, new Short(s));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Short(s));
        Trc.exit();
    }

    public float getFloatPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "float");
        }
        try {
            float f = ((Float)this.parts.get(string)).floatValue();
            Trc.exit(new Float(f));
            return f;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return 0.0f;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Float");
            Trc.exit(0);
            return 0.0f;
        }
    }

    public void setFloatPart(String string, float f) {
        Trc.entry(this, string, new Float(f));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Float(f));
        Trc.exit();
    }

    public double getDoublePart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "double");
        }
        try {
            double d = (Double)this.parts.get(string);
            Trc.exit(new Double(d));
            return d;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(0);
            return 0.0;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Double");
            Trc.exit(0);
            return 0.0;
        }
    }

    public void setDoublePart(String string, double d) {
        Trc.entry(this, string, new Double(d));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Double(d));
        Trc.exit();
    }

    public boolean getBooleanPart(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (this.parts == null) {
            this.handleNoPartsException(string, "boolean");
        }
        try {
            boolean bl = (Boolean)this.parts.get(string);
            Trc.exit(bl);
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            Trc.exception(nullPointerException);
            this.handlePartNotFoundException(string);
            Trc.exit(false);
            return false;
        }
        catch (ClassCastException classCastException) {
            Trc.exception(classCastException);
            this.handlePartCastException(string, this.parts.get(string).getClass().getName(), "Boolean");
            Trc.exit(false);
            return false;
        }
    }

    public void setBooleanPart(String string, boolean bl) {
        Trc.entry(this, string, new Boolean(bl));
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        this.parts.put(string, new Boolean(bl));
        Trc.exit();
    }

    public Iterator getPartNames() {
        Trc.entry(this);
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        Iterator iterator = this.parts.keySet().iterator();
        Trc.exit(iterator);
        return iterator;
    }

    public Object clone() throws CloneNotSupportedException {
        Trc.entry(this);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        wSIFDefaultMessage.setName(this.name);
        wSIFDefaultMessage.setRepresentationStyle(this.style);
        wSIFDefaultMessage.setMessageDefinition(this.msgDefinition);
        if (this.parts != null) {
            Iterator iterator = this.getPartNames();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                String string = (String)iterator.next();
                Object v = this.parts.get(string);
                if (v == null) {
                    try {
                        wSIFDefaultMessage.setObjectPart(string, null);
                        continue;
                    }
                    catch (Exception exception) {
                        Trc.exception(exception);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + string + ". Message is " + exception.getMessage());
                    }
                }
                Object var5_5 = null;
                if (v instanceof String || v instanceof Integer || v instanceof Float || v instanceof Byte || v instanceof Long || v instanceof Short || v instanceof Double || v instanceof Boolean) {
                    var5_5 = v;
                }
                try {
                    if (var5_5 != null) {
                        wSIFDefaultMessage.setObjectPart(string, var5_5);
                        continue;
                    }
                }
                catch (Exception exception) {
                    Trc.exception(exception);
                    throw new CloneNotSupportedException("Exception thrown whilst cloning part " + string + ". Message is " + exception.getMessage());
                }
                if (v instanceof Cloneable) {
                    object3 = v.getClass();
                    try {
                        object2 = ((Class)object3).getMethod("clone", null);
                        object = ((Method)object2).invoke(v, null);
                        wSIFDefaultMessage.setObjectPart(string, object);
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Trc.exception(invocationTargetException);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + string + ". Message is " + invocationTargetException.getTargetException().getMessage());
                    }
                    catch (Exception exception) {
                        Trc.exception(exception);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + string + ". Message is " + exception.getMessage());
                    }
                }
                if (v instanceof Serializable) {
                    try {
                        object3 = new ByteArrayOutputStream();
                        object2 = new ObjectOutputStream((OutputStream)object3);
                        ((ObjectOutputStream)object2).writeObject(v);
                        ((ObjectOutputStream)object2).flush();
                        ((ObjectOutputStream)object2).close();
                        object = ((ByteArrayOutputStream)object3).toByteArray();
                        WSIFObjectInputStream wSIFObjectInputStream = new WSIFObjectInputStream(new ByteArrayInputStream((byte[])object));
                        Object object4 = wSIFObjectInputStream.readObject();
                        wSIFObjectInputStream.close();
                        wSIFDefaultMessage.setObjectPart(string, object4);
                        continue;
                    }
                    catch (Throwable throwable) {
                        Trc.exception(throwable);
                        throw new CloneNotSupportedException("Exception thrown whilst cloning part " + string + " by serialization. Message is " + throwable.getMessage());
                    }
                }
                throw new CloneNotSupportedException("Part " + string + " cannot be cloned");
            }
        }
        if (Trc.ON) {
            Trc.exit(wSIFDefaultMessage.deep());
        }
        return wSIFDefaultMessage;
    }

    private void handleNoPartsException(String string, String string2) throws WSIFException {
        throw new WSIFException("Cannot get " + string2 + " part '" + string + "'. No parts are set on the message");
    }

    private void handlePartNotFoundException(String string) throws WSIFException {
        throw new WSIFException("Cannot get part '" + string + "'. Part was not found in message");
    }

    private void handleSourcedPartNotFoundException(String string, Class clazz) throws WSIFException {
        throw new WSIFException("Cannot get part. Part '" + string + "' with source '" + clazz + "' was not found in message");
    }

    private void handlePartCastException(String string, String string2, String string3) throws WSIFException {
        throw new WSIFException("Cannot get part '" + string + "'. Cannot convert " + "from " + string2 + " to " + string3);
    }

    public String toString() {
        return this.deep();
    }

    public String deep() {
        String string = "";
        try {
            string = new String(super.toString());
            string = string + " name:" + this.name;
            string = this.parts == null ? string + " parts:null" : string + Trc.brief(2, " parts", this.parts.values());
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

