/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.wsdl.Operation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFCorrelationId;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFResponseHandler;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.extensions.jms.JMSProperty;
import org.apache.wsif.wsdl.extensions.jms.JMSPropertyValue;

public abstract class WSIFDefaultOperation
implements WSIFOperation {
    private static final long serialVersionUID = 1L;
    protected transient HashMap inJmsProps = new HashMap();
    protected transient HashMap outJmsProps = new HashMap();
    protected transient HashMap inJmsPropVals = new HashMap();
    protected WSIFMessage context;
    protected boolean closed = false;

    public abstract boolean executeRequestResponseOperation(WSIFMessage var1, WSIFMessage var2, WSIFMessage var3) throws WSIFException;

    public abstract void executeInputOnlyOperation(WSIFMessage var1) throws WSIFException;

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage, WSIFResponseHandler wSIFResponseHandler) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public WSIFCorrelationId executeRequestResponseAsync(WSIFMessage wSIFMessage) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public void fireAsyncResponse(Object object) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public boolean processAsyncResponse(Object object, WSIFMessage wSIFMessage, WSIFMessage wSIFMessage2) throws WSIFException {
        throw new WSIFException("asynchronous operations not supportted");
    }

    public WSIFMessage createInputMessage() {
        Trc.entry(this);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        if (wSIFDefaultMessage != null) {
            try {
                wSIFDefaultMessage.setMessageDefinition(this.getOperation().getInput().getMessage());
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createInputMessage(String string) {
        Trc.entry((Object)this, string);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        if (wSIFDefaultMessage != null) {
            wSIFDefaultMessage.setName(string);
            try {
                wSIFDefaultMessage.setMessageDefinition(this.getOperation().getInput().getMessage());
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createOutputMessage() {
        Trc.entry(this);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        if (wSIFDefaultMessage != null) {
            try {
                wSIFDefaultMessage.setMessageDefinition(this.getOperation().getOutput().getMessage());
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createOutputMessage(String string) {
        Trc.entry((Object)this, string);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        if (wSIFDefaultMessage != null) {
            wSIFDefaultMessage.setName(string);
            try {
                wSIFDefaultMessage.setMessageDefinition(this.getOperation().getOutput().getMessage());
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createFaultMessage() {
        Trc.entry(this);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public WSIFMessage createFaultMessage(String string) {
        Trc.entry((Object)this, string);
        WSIFDefaultMessage wSIFDefaultMessage = new WSIFDefaultMessage();
        if (wSIFDefaultMessage != null) {
            wSIFDefaultMessage.setName(string);
            try {
                wSIFDefaultMessage.setMessageDefinition(this.getOperation().getFault(string).getMessage());
            }
            catch (Exception exception) {
                Trc.ignoredException(exception);
            }
        }
        Trc.exit(wSIFDefaultMessage);
        return wSIFDefaultMessage;
    }

    public void setInputJmsProperties(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        this.inJmsProps = this.makeSomeKindOfJmsMap(list);
        Trc.exit();
    }

    public void setOutputJmsProperties(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        this.outJmsProps = this.makeSomeKindOfJmsMap(list);
        Trc.exit();
    }

    public void setInputJmsProperties(HashMap hashMap) {
        Trc.entry((Object)this, hashMap);
        this.inJmsProps = hashMap;
        Trc.exit();
    }

    public void setOutputJmsProperties(HashMap hashMap) {
        Trc.entry((Object)this, hashMap);
        this.outJmsProps = hashMap;
        Trc.exit();
    }

    public HashMap getInputJmsProperties() {
        Trc.entry(this);
        Trc.exit(this.inJmsProps);
        return this.inJmsProps;
    }

    public HashMap getOutputJmsProperties() {
        Trc.entry(this);
        Trc.exit(this.outJmsProps);
        return this.outJmsProps;
    }

    public abstract WSIFPort getWSIFPort();

    public void addInputJmsPropertyValues(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        if (list != null && !list.isEmpty()) {
            HashMap hashMap = this.makeSomeKindOfJmsMap(list);
            hashMap.putAll(this.inJmsPropVals);
            this.inJmsPropVals = hashMap;
        }
        Trc.exit();
    }

    public void setInputJmsPropertyValues(HashMap hashMap) {
        Trc.entry((Object)this, hashMap);
        this.inJmsPropVals = hashMap;
        Trc.exit();
    }

    public HashMap getInputJmsPropertyValues() {
        Trc.entry(this);
        Trc.exit(this.inJmsPropVals);
        return this.inJmsPropVals;
    }

    protected HashMap makeSomeKindOfJmsMap(List list) throws WSIFException {
        Trc.entry((Object)this, list);
        Map map = WSIFUtils.getSimpleTypesMap();
        HashMap<String, String> hashMap = new HashMap<String, String>(list.size());
        for (Object e : list) {
            Object object;
            String string;
            block20: {
                ExtensibilityElement extensibilityElement;
                if (e instanceof JMSProperty) {
                    extensibilityElement = (JMSProperty)e;
                    hashMap.put(extensibilityElement.getPart(), extensibilityElement.getName());
                    continue;
                }
                if (!(e instanceof JMSPropertyValue)) continue;
                extensibilityElement = (JMSPropertyValue)e;
                string = extensibilityElement.getName();
                if (string == null || string.length() == 0) {
                    throw new WSIFException("jms:propertyValue found without a name");
                }
                QName qName = extensibilityElement.getType();
                if (qName == null) {
                    throw new WSIFException("jms:propertyValue " + string + " did not have a type");
                }
                if (qName.getNamespaceURI() == null || qName.getLocalPart() == null) {
                    throw new WSIFException("jms:propertyValue " + string + " has a badly formed type");
                }
                String string2 = extensibilityElement.getValue();
                if (string2 == null || string2.length() == 0) {
                    throw new WSIFException("jms:propertyValue " + string + " did not have a value");
                }
                String string3 = (String)map.get(qName);
                if (string3 == null) {
                    throw new WSIFException("jms:propertyValue " + string + " had a type that was " + "unknown or was not a simple type");
                }
                Class<?> clazz = null;
                ClassNotFoundException classNotFoundException = null;
                try {
                    clazz = Class.forName(string3, true, Thread.currentThread().getContextClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    Trc.exception(classNotFoundException2);
                    classNotFoundException = classNotFoundException2;
                }
                object = null;
                try {
                    if (String.class.equals(clazz)) {
                        object = string2;
                        break block20;
                    }
                    if ("int".equals(string3) || Integer.class.equals(clazz)) {
                        object = new Integer(string2);
                        break block20;
                    }
                    if ("boolean".equals(string3) || Boolean.class.equals(clazz)) {
                        object = new Boolean(string2);
                        break block20;
                    }
                    if ("byte".equals(string3) || Byte.class.equals(clazz)) {
                        object = new Byte(string2);
                        break block20;
                    }
                    if ("double".equals(string3) || Double.class.equals(clazz)) {
                        object = new Double(string2);
                        break block20;
                    }
                    if ("float".equals(string3) || Float.class.equals(clazz)) {
                        object = new Float(string2);
                        break block20;
                    }
                    if ("long".equals(string3) || Long.class.equals(clazz)) {
                        object = new Long(string2);
                        break block20;
                    }
                    if ("short".equals(string3) || Short.class.equals(clazz)) {
                        object = new Short(string2);
                        break block20;
                    }
                    if (classNotFoundException != null) {
                        throw new WSIFException("Unexpected ClassNotFoundException when processing jms:propertyValue " + string + ". Could not convert the type to a java class. " + classNotFoundException);
                    }
                    throw new WSIFException("jms:propertyValue " + string + " had an invalid type");
                }
                catch (NumberFormatException numberFormatException) {
                    Trc.exception(numberFormatException);
                    throw new WSIFException("jms:propertyValue " + string + " a value that could not " + "be converted into the specified type. Caught NumberFormatException. " + numberFormatException);
                }
            }
            hashMap.put(string, (String)object);
        }
        Trc.exit(hashMap);
        return hashMap;
    }

    public void setContext(WSIFMessage wSIFMessage) {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = wSIFMessage;
        Trc.exit();
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage wSIFMessage;
        Trc.entry(this);
        try {
            wSIFMessage = this.context == null ? (WSIFMessage)this.getWSIFPort().getContext().clone() : (WSIFMessage)this.context.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new WSIFException("CloneNotSupportedException cloning context", cloneNotSupportedException);
        }
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    protected abstract Operation getOperation() throws Exception;

    protected void close() throws WSIFException {
        Trc.entry(this);
        if (this.closed) {
            throw new WSIFException("Cannot reuse a WSIFOperation to invoke multiple operations");
        }
        this.closed = true;
        Trc.exit();
    }
}

