/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.Trc;

public abstract class WSIFDefaultPort
implements WSIFPort {
    private static final long serialVersionUID = 1L;
    protected WSIFMessage context;

    public void close() throws WSIFException {
        Trc.entry(this);
        Trc.exit();
    }

    public void finalize() throws Throwable {
        Trc.entry(this);
        try {
            this.close();
        }
        catch (WSIFException wSIFException) {
            Trc.ignoredException(wSIFException);
        }
        super.finalize();
        Trc.exit();
    }

    protected String getKey(String string, String string2, String string3) {
        Trc.entry(this, string, string2, string3);
        String string4 = string + (string2 != null ? ":" + string2 : "") + (string3 != null ? ":" + string3 : "");
        Trc.exit(string4);
        return string4;
    }

    protected Object getExtElem(Object object, Class clazz, List list) throws WSIFException {
        Trc.entry(this, object, clazz, list);
        Object var4_4 = null;
        if (list != null) {
            for (Object e : list) {
                if (!clazz.isAssignableFrom(e.getClass())) continue;
                if (var4_4 != null) {
                    throw new WSIFException("duplicated extensibility element " + clazz.getClass().getName() + " in " + object);
                }
                var4_4 = e;
            }
        }
        Trc.exit(var4_4);
        return var4_4;
    }

    protected List getExtElems(Object object, Class clazz, List list) throws WSIFException {
        Trc.entry(this, object, clazz, list);
        ArrayList arrayList = new ArrayList();
        if (list != null) {
            for (Object e : list) {
                if (!clazz.isAssignableFrom(e.getClass())) continue;
                arrayList.add(e);
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Trc.exit(arrayList);
        return arrayList;
    }

    public boolean supportsSync() {
        Trc.entry(this);
        Trc.exit(true);
        return true;
    }

    public boolean supportsAsync() {
        Trc.entry(this);
        Trc.exit(false);
        return false;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage wSIFMessage;
        Trc.entry(this);
        if (this.context == null) {
            wSIFMessage = new WSIFDefaultMessage();
        } else {
            try {
                wSIFMessage = (WSIFMessage)this.context.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new WSIFException("CloneNotSupportedException cloning context", cloneNotSupportedException);
            }
        }
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public void setContext(WSIFMessage wSIFMessage) {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = wSIFMessage;
        Trc.exit(null);
    }
}

