/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;

class WSIFObjectInputStream
extends ObjectInputStream {
    WSIFObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        super(inputStream);
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(objectStreamClass.getName(), true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string = objectStreamClass.getName();
            if (string.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (string.equals("char")) {
                return Character.TYPE;
            }
            if (string.equals("byte")) {
                return Byte.TYPE;
            }
            if (string.equals("short")) {
                return Short.TYPE;
            }
            if (string.equals("int")) {
                return Integer.TYPE;
            }
            if (string.equals("long")) {
                return Long.TYPE;
            }
            if (string.equals("float")) {
                return Float.TYPE;
            }
            if (string.equals("double")) {
                return Double.TYPE;
            }
            throw classNotFoundException;
        }
    }
}

