/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.util.Hashtable;
import org.apache.wsif.logging.Trc;

public class WSIFServiceCache
extends Hashtable {
    static final int CUSHION_PERCENT = 10;
    LRUWrapper oldestObject = null;
    LRUWrapper newestObject = null;
    int cushionSize = 1;
    int cacheLimit = 0;
    int currentSize = 0;

    WSIFServiceCache(int n) {
        super(n);
        this.cacheLimit = n;
        this.cushionSize = this.cacheLimit * 10 / 100;
        if (this.cushionSize == 0) {
            this.cushionSize = 1;
        }
        Trc.event(this, "WSIFServiceCache created - cache limit:" + this.cacheLimit + " Cushion:" + this.cushionSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int n) {
        WSIFServiceCache wSIFServiceCache = this;
        synchronized (wSIFServiceCache) {
            this.cacheLimit = n;
            this.cushionSize = this.cacheLimit * 10 / 100;
        }
    }

    public Object put(Object object, Object object2) {
        LRUWrapper lRUWrapper = new LRUWrapper(object, object2);
        if (this.currentSize >= this.cacheLimit) {
            this.shrinkCache();
        }
        if (this.oldestObject == null) {
            this.oldestObject = lRUWrapper;
            this.newestObject = lRUWrapper;
        } else {
            this.addToTopOfLRUList(lRUWrapper);
        }
        lRUWrapper = super.put(object, lRUWrapper);
        ++this.currentSize;
        Trc.event(this, "WSIFServiceCache (put). Current cache size: " + this.currentSize);
        if (lRUWrapper == null) {
            return null;
        }
        return lRUWrapper.value;
    }

    public Object get(Object object) {
        LRUWrapper lRUWrapper = (LRUWrapper)super.get(object);
        if (lRUWrapper == null) {
            Trc.event(this, "WSIFServiceCache (get). No hit. Cache size: " + this.currentSize);
            return null;
        }
        Trc.event(this, "WSIFServiceCache (get). MATCH FOUND. Cache size: " + this.currentSize);
        if (this.newestObject != lRUWrapper) {
            this.removeFromLRUList(lRUWrapper);
            this.addToTopOfLRUList(lRUWrapper);
        }
        return lRUWrapper.value;
    }

    private void addToTopOfLRUList(LRUWrapper lRUWrapper) {
        this.newestObject.nextObject = lRUWrapper;
        lRUWrapper.prevObject = this.newestObject;
        this.newestObject = lRUWrapper;
    }

    private void removeFromLRUList(LRUWrapper lRUWrapper) {
        if (lRUWrapper != this.oldestObject) {
            lRUWrapper.prevObject.nextObject = lRUWrapper.nextObject;
            lRUWrapper.nextObject.prevObject = lRUWrapper.prevObject;
        } else {
            lRUWrapper.nextObject.prevObject = null;
            this.oldestObject = lRUWrapper.nextObject;
        }
    }

    private void shrinkCache() {
        LRUWrapper lRUWrapper = this.oldestObject;
        for (int i = 1; i <= this.cushionSize; ++i) {
            super.remove(lRUWrapper.key);
            lRUWrapper = lRUWrapper.nextObject;
        }
        this.oldestObject = lRUWrapper;
        this.currentSize -= this.cushionSize;
        Trc.event(this, "WSIFServiceCache (put). Cache size after shrinkage: " + this.currentSize);
    }

    class LRUWrapper {
        LRUWrapper nextObject = null;
        LRUWrapper prevObject = null;
        Object value = null;
        Object key = null;

        LRUWrapper(Object object, Object object2) {
            this.value = object2;
            this.key = object;
        }
    }
}

