/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsif.base;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Output;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFService;
import org.apache.wsif.base.PrivateCompositeExtensionRegistry;
import org.apache.wsif.base.WSIFClientProxy;
import org.apache.wsif.base.WSIFDefaultMessage;
import org.apache.wsif.logging.MessageLogger;
import org.apache.wsif.logging.Trc;
import org.apache.wsif.mapping.WSIFMapper;
import org.apache.wsif.mapping.WSIFMapperFactory;
import org.apache.wsif.mapping.WSIFMappingConvention;
import org.apache.wsif.mapping.WSIFMappingConventionFactory;
import org.apache.wsif.providers.WSIFDynamicTypeMap;
import org.apache.wsif.schema.Parser;
import org.apache.wsif.schema.SchemaType;
import org.apache.wsif.spi.WSIFProvider;
import org.apache.wsif.util.WSIFPluggableProviders;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.AuthenticatingProxyWSDLLocatorImpl;
import org.apache.wsif.wsdl.ClosableLocator;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;

public class WSIFServiceImpl
implements WSIFService {
    private static PrivateCompositeExtensionRegistry providersExtRegs = new PrivateCompositeExtensionRegistry();
    private Definition def = null;
    private Service service;
    private PortType portType;
    private Map availablePorts;
    private WSIFDynamicTypeMap typeMap = new WSIFDynamicTypeMap();
    private String preferredPort = null;
    private Map typeReg = null;
    private Port chosenPort = null;
    private WSIFMessage context;
    protected ArrayList schemaTypes = new ArrayList();
    protected WSIFMappingConvention mapCon = null;
    protected WSIFMapper mapper = null;
    private boolean typeMapInitialised = false;
    private boolean schemaTypesInitialised = false;
    private WSDLLocator specialistLocator = null;
    protected Map features = null;

    WSIFServiceImpl(String string, String string2, String string3, String string4, String string5, Map map) throws WSIFException {
        PasswordAuthentication passwordAuthentication;
        Trc.entry(this, string, string2, string3, string4, string5);
        this.features = map;
        Definition definition = null;
        try {
            passwordAuthentication = this.getProxyAuthentication();
            if (passwordAuthentication != null) {
                definition = WSIFUtils.readWSDLThroughAuthProxy(string, passwordAuthentication);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(string, passwordAuthentication);
            }
            if (definition == null) {
                definition = WSIFUtils.readWSDL(null, string);
            }
            this.checkWSDL(definition);
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            throw new WSIFException("could not load " + string, wSDLException);
        }
        passwordAuthentication = WSIFUtils.selectService(definition, string2, string3);
        PortType portType = WSIFUtils.selectPortType(definition, string4, string5);
        this.init(definition, (Service)passwordAuthentication, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(String string, ClassLoader classLoader, String string2, String string3, String string4, String string5, Map map) throws WSIFException {
        PasswordAuthentication passwordAuthentication;
        Trc.entry(this, string, classLoader, string2, string3, string4, string5);
        this.features = map;
        Definition definition = null;
        try {
            passwordAuthentication = this.getProxyAuthentication();
            if (passwordAuthentication != null) {
                definition = WSIFUtils.readWSDLThroughAuthProxy(string, passwordAuthentication);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(string, passwordAuthentication);
            }
            if (definition == null) {
                definition = WSIFUtils.readWSDL(null, string, classLoader);
                this.specialistLocator = new WSIFWSDLLocatorImpl(null, string, classLoader);
            }
            this.checkWSDL(definition);
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            throw new WSIFException("could not load " + string, wSDLException);
        }
        passwordAuthentication = WSIFUtils.selectService(definition, string2, string3);
        PortType portType = WSIFUtils.selectPortType(definition, string4, string5);
        this.init(definition, (Service)passwordAuthentication, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(Definition definition, Map map) throws WSIFException {
        this(definition, null, map);
    }

    WSIFServiceImpl(Definition definition, Service service, Map map) throws WSIFException {
        this(definition, service, null, map);
    }

    WSIFServiceImpl(Definition definition, Service service, PortType portType, Map map) throws WSIFException {
        Trc.entry(this, definition, service, portType, map);
        this.features = map;
        try {
            PasswordAuthentication passwordAuthentication = this.getProxyAuthentication();
            if (passwordAuthentication != null) {
                definition = WSIFUtils.readWSDLThroughAuthProxy(definition.getDocumentBaseURI(), passwordAuthentication);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(definition.getDocumentBaseURI(), passwordAuthentication);
            }
        }
        catch (WSDLException wSDLException) {
            Trc.ignoredException(wSDLException);
        }
        this.init(definition, service, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(Definition definition, String string, String string2, Map map) throws WSIFException {
        PasswordAuthentication passwordAuthentication;
        Trc.entry(this, definition, string, string2, map);
        this.features = map;
        try {
            passwordAuthentication = this.getProxyAuthentication();
            if (passwordAuthentication != null) {
                definition = WSIFUtils.readWSDLThroughAuthProxy(definition.getDocumentBaseURI(), passwordAuthentication);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(definition.getDocumentBaseURI(), passwordAuthentication);
            }
        }
        catch (WSDLException wSDLException) {
            Trc.ignoredException(wSDLException);
        }
        passwordAuthentication = WSIFUtils.selectService(definition, string, string2);
        this.init(definition, (Service)passwordAuthentication, null);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(Definition definition, String string, String string2, String string3, String string4, Map map) throws WSIFException {
        PasswordAuthentication passwordAuthentication;
        Trc.entry(this, definition, string, string2, string3, string4, map);
        this.features = map;
        try {
            passwordAuthentication = this.getProxyAuthentication();
            if (passwordAuthentication != null) {
                definition = WSIFUtils.readWSDLThroughAuthProxy(definition.getDocumentBaseURI(), passwordAuthentication);
                this.specialistLocator = new AuthenticatingProxyWSDLLocatorImpl(definition.getDocumentBaseURI(), passwordAuthentication);
            }
        }
        catch (WSDLException wSDLException) {
            Trc.ignoredException(wSDLException);
        }
        this.checkWSDLForWSIF(definition);
        passwordAuthentication = WSIFUtils.selectService(definition, string, string2);
        PortType portType = WSIFUtils.selectPortType(definition, string3, string4);
        this.init(definition, (Service)passwordAuthentication, portType);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    WSIFServiceImpl(WSIFServiceImpl wSIFServiceImpl) throws WSIFException {
        Trc.entry((Object)this, wSIFServiceImpl);
        this.copyInitializedService(wSIFServiceImpl);
        if (Trc.ON) {
            Trc.exit(this.deep());
        }
    }

    private void copyInitializedService(WSIFServiceImpl wSIFServiceImpl) {
        this.def = wSIFServiceImpl.def;
        this.service = wSIFServiceImpl.service;
        this.portType = wSIFServiceImpl.portType;
        this.availablePorts = (Map)((Hashtable)wSIFServiceImpl.availablePorts).clone();
        this.typeMap = wSIFServiceImpl.typeMap.copy();
        this.schemaTypesInitialised = wSIFServiceImpl.schemaTypesInitialised;
        this.typeMapInitialised = wSIFServiceImpl.typeMapInitialised;
        this.schemaTypes = (ArrayList)wSIFServiceImpl.schemaTypes.clone();
        this.mapCon = wSIFServiceImpl.mapCon;
        this.mapper = wSIFServiceImpl.mapper;
        this.features = wSIFServiceImpl.features instanceof Hashtable ? (Map)((Hashtable)wSIFServiceImpl.features).clone() : (wSIFServiceImpl.features instanceof HashMap ? (Map)((HashMap)wSIFServiceImpl.features).clone() : wSIFServiceImpl.features);
    }

    public void setPreferredPort(String string) throws WSIFException {
        Trc.entry((Object)this, string);
        if (string == null) {
            throw new WSIFException("Preferred port name cannot be null");
        }
        PortType portType = this.getPortTypeFromPortName(string);
        if (!portType.getQName().equals(this.portType.getQName())) {
            throw new WSIFException("Preferred port " + string + "is not available for the port type " + this.portType.getQName());
        }
        this.preferredPort = string;
        Trc.exit();
    }

    private PortType getPortTypeFromPortName(String string) throws WSIFException {
        if (string == null) {
            throw new WSIFException("Unable to find port type from a null port name");
        }
        Port port = this.service.getPort(string);
        if (port == null) {
            throw new WSIFException("Port '" + string + "' cannot be found in the service");
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            throw new WSIFException("No binding found for port '" + string + "'");
        }
        PortType portType = binding.getPortType();
        if (portType == null) {
            throw new WSIFException("No port type found for binding '" + binding.getQName() + "'");
        }
        this.checkPortTypeInformation(this.def, portType);
        return portType;
    }

    public Iterator getAvailablePortNames() throws WSIFException {
        Trc.entry(this);
        Iterator iterator = null;
        if (this.availablePorts != null) {
            iterator = this.availablePorts.keySet().iterator();
        }
        Trc.exit(iterator);
        return iterator;
    }

    private WSIFPort createDynamicWSIFPort(Definition definition, Service service, Port port) throws WSIFException {
        this.checkWSDLForWSIF(definition);
        List list = port.getBinding().getExtensibilityElements();
        ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
        String string = extensibilityElement.getElementType().getNamespaceURI();
        WSIFProvider wSIFProvider = WSIFPluggableProviders.getProvider(string);
        if (wSIFProvider == null) {
            throw new WSIFException("could not find suitable provider for binding namespace '" + string + "'");
        }
        WSIFPort wSIFPort = wSIFProvider.createDynamicWSIFPort(definition, service, port, this.typeMap);
        wSIFPort.setContext(this.getContext());
        return wSIFPort;
    }

    public WSIFPort getPort() throws WSIFException {
        Trc.entry(this);
        WSIFPort wSIFPort = null;
        if (this.preferredPort != null && this.availablePorts.get(this.preferredPort) != null) {
            wSIFPort = this.getPort(this.preferredPort);
        } else {
            if (this.preferredPort != null) {
                MessageLogger.log("WSIF.0011I", this.preferredPort);
            }
            wSIFPort = this.getPort(null);
        }
        Trc.exit(wSIFPort);
        return wSIFPort;
    }

    public WSIFPort getPort(String string) throws WSIFException {
        Object object;
        Trc.entry((Object)this, string);
        Port port = null;
        if (string == null) {
            if (this.availablePorts.size() > 0) {
                port = (Port)this.availablePorts.values().iterator().next();
            }
            if (port == null) {
                throw new WSIFException("Unable to find an available port");
            }
        } else {
            port = (Port)this.availablePorts.get(string);
            object = "{empty list}";
            StringBuffer stringBuffer = new StringBuffer();
            for (String string2 : this.availablePorts.keySet()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string2);
            }
            if (stringBuffer.length() > 0) {
                object = "{" + stringBuffer.toString() + "}";
            }
            if (port == null) {
                throw new WSIFException("Port '" + string + "' is not available and " + "no alternative can be found in " + (String)object);
            }
        }
        this.setupTypeMappings();
        object = this.createDynamicWSIFPort(this.def, this.service, port);
        if (object == null) {
            throw new WSIFException("Provider was unable to create WSIFPort for port " + port.getName());
        }
        this.chosenPort = port;
        Trc.exit(object);
        return object;
    }

    private void mapType(QName qName, Class clazz, boolean bl) throws WSIFException {
        Trc.entry(this, qName, clazz, new Boolean(bl));
        this.typeMap.mapType(qName, clazz, bl);
        Trc.exit();
    }

    public void mapType(QName qName, Class clazz) throws WSIFException {
        Trc.entry(this, qName, clazz);
        if (this.mapper != null) {
            this.mapper.overrideTypeMapping(qName, clazz.getName());
        }
        if (!this.schemaTypesInitialised) {
            this.typeMap.mapType(qName, clazz, true);
        }
        Trc.exit();
    }

    public void mapType(QName qName, String string) throws WSIFException {
        Trc.entry(this, qName, string);
        if (this.mapper != null) {
            this.mapper.overrideTypeMapping(qName, string);
        }
        if (!this.schemaTypesInitialised) {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trc.ignoredException(classNotFoundException);
            }
            if (clazz != null) {
                this.typeMap.mapType(qName, clazz, true);
            }
        }
        Trc.exit();
    }

    public void mapPackage(String string, String string2) throws WSIFException {
        Trc.entry((Object)string, string2);
        this.populateSchemaTypes(this.specialistLocator);
        if (this.mapCon != null) {
            this.mapCon.overridePackageMapping(string, string2);
        }
        Trc.exit();
    }

    public static WSIFProvider getDynamicWSIFProvider(String string) {
        Trc.entry(null, string);
        WSIFProvider wSIFProvider = WSIFPluggableProviders.getProvider(string);
        Trc.exit(wSIFProvider);
        return wSIFProvider;
    }

    public static void setDynamicWSIFProvider(String string, WSIFProvider wSIFProvider) {
        Trc.entry(null, string, wSIFProvider);
        WSIFPluggableProviders.overrideDefaultProvider(string, wSIFProvider);
        Trc.exit();
    }

    public static void setAutoLoadProviders(boolean bl) {
        Trc.entry(null, bl);
        WSIFPluggableProviders.setAutoLoadProviders(bl);
        Trc.exit();
    }

    public Object getStub(String string, Class clazz) throws WSIFException {
        Trc.entry(this, string, clazz);
        this.populateSchemaTypes(this.specialistLocator);
        WSIFPort wSIFPort = this.getPort(string);
        PortType portType = this.getPortTypeFromPortName(string);
        WSIFClientProxy wSIFClientProxy = WSIFClientProxy.newInstance(clazz, this.def, this.service.getQName().getNamespaceURI(), this.service.getQName().getLocalPart(), this.portType.getQName().getNamespaceURI(), this.portType.getQName().getLocalPart(), this.typeMap);
        wSIFClientProxy.setPort(wSIFPort);
        Object object = wSIFClientProxy.getProxy();
        Trc.exit();
        return object;
    }

    public Object getStub(Class clazz) throws WSIFException {
        Trc.entry((Object)this, clazz);
        this.populateSchemaTypes(this.specialistLocator);
        WSIFPort wSIFPort = this.getPort();
        String string = this.chosenPort.getName();
        PortType portType = this.getPortTypeFromPortName(string);
        WSIFClientProxy wSIFClientProxy = WSIFClientProxy.newInstance(clazz, this.def, this.service.getQName().getNamespaceURI(), this.service.getQName().getLocalPart(), portType.getQName().getNamespaceURI(), portType.getQName().getLocalPart(), this.typeMap);
        wSIFClientProxy.setPort(wSIFPort);
        Object object = wSIFClientProxy.getProxy();
        Trc.exit();
        return object;
    }

    public static void addExtensionRegistry(ExtensionRegistry extensionRegistry) {
        Trc.entry(null, extensionRegistry);
        providersExtRegs.addExtensionRegistry(extensionRegistry);
        Trc.exit();
    }

    public static ExtensionRegistry getCompositeExtensionRegistry() {
        Trc.entry(null);
        Trc.exit((Object)providersExtRegs);
        return providersExtRegs;
    }

    private void init(Definition definition, Service service, PortType portType) throws WSIFException {
        PortType portType2;
        Object object2;
        Map map;
        if (definition == null) {
            throw new IllegalArgumentException("WSDL definition can not be null");
        }
        this.checkWSDLForWSIF(definition);
        if (service == null) {
            map = WSIFUtils.getAllItems(definition, "Service");
            service = (Service)WSIFUtils.getNamedItem(map, null, "Service");
        }
        if (portType == null) {
            map = service.getPorts();
            if (map.size() == 0) {
                throw new WSIFException("WSDL must contain at least one port in " + service.getQName());
            }
            for (Object object2 : map.values()) {
                if (portType == null) {
                    portType = object2.getBinding().getPortType();
                    continue;
                }
                portType2 = object2.getBinding().getPortType();
                if (portType2.getQName().equals(portType.getQName())) continue;
                throw new WSIFException("when no port type was specified all ports must have the same port type in WSDL service " + service.getQName());
            }
            if (portType == null) {
                throw new IllegalArgumentException("WSDL more than one portType in service " + service);
            }
        }
        this.def = definition;
        this.service = service;
        this.portType = portType;
        this.checkPortTypeInformation(definition, portType);
        map = service.getPorts();
        if (map.size() == 0) {
            throw new WSIFException("WSDL must contain at least one port in " + service.getQName());
        }
        this.availablePorts = new Hashtable();
        for (Object object2 : map.values()) {
            String string;
            Object object3;
            List list;
            portType2 = object2.getBinding();
            if (portType2 == null || (list = portType2.getExtensibilityElements()).size() <= 0) continue;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(0);
            String string2 = extensibilityElement.getElementType().getNamespaceURI();
            List list2 = object2.getExtensibilityElements();
            if (list2.size() > 0) {
                object3 = (ExtensibilityElement)list2.get(0);
                string = object3.getElementType().getNamespaceURI();
            } else {
                string = string2;
            }
            if (!WSIFPluggableProviders.isProviderAvailable(string2, string)) continue;
            object3 = portType.getQName();
            if (!portType2.getPortType().getQName().equals(object3)) continue;
            String string3 = object2.getName();
            this.availablePorts.put(string3, object2);
        }
        Object object4 = null;
        object2 = null;
        try {
            object4 = (String)this.features.get("org.apache.wsif.mapper");
        }
        catch (ClassCastException classCastException) {
            Trc.ignoredException(classCastException);
        }
        try {
            object2 = (String)this.features.get("org.apache.wsif.mappingconvention");
        }
        catch (ClassCastException classCastException) {
            Trc.ignoredException(classCastException);
        }
        this.overrideMapper((String)object4);
        this.overrideMappingConvention((String)object2);
        if (this.autoMapTypesOn()) {
            this.populateSchemaTypes(this.specialistLocator);
        }
    }

    private void checkPortTypeInformation(Definition definition, PortType portType) throws WSIFException {
        List list = portType.getOperations();
        for (Operation operation : list) {
            Input input;
            String string = operation.getName();
            if (operation.isUndefined()) {
                throw new WSIFException("operation " + string + " is undefined!");
            }
            OperationType operationType = operation.getStyle();
            if (operationType == null) {
                throw new WSIFException("operation " + string + " has no type!");
            }
            if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                input = operation.getInput();
                Output output = operation.getOutput();
                if (input == null) {
                    throw new WSIFException("missing input message for operation " + string);
                }
                if (output != null) continue;
                throw new WSIFException("missing output message for operation " + string);
            }
            if (operationType.equals(OperationType.ONE_WAY)) {
                input = operation.getInput();
                if (input != null) continue;
                throw new WSIFException("missing input message for operation " + string);
            }
            MessageLogger.log("WSIF.0004E", operationType, portType.getQName().getLocalPart());
            throw new WSIFException("operation type " + operationType + " is not supported in port instance for " + portType.getQName());
        }
    }

    private void checkWSDLForWSIF(Definition definition) throws WSIFException {
        try {
            this.checkWSDL(definition);
        }
        catch (WSDLException wSDLException) {
            Trc.exception(wSDLException);
            throw new WSIFException("invalid WSDL defintion " + definition.getQName(), wSDLException);
        }
    }

    private void checkWSDL(Definition definition) throws WSDLException {
        for (Message message : definition.getMessages().values()) {
            if (!message.isUndefined()) continue;
            throw new WSDLException("INVALID_WSDL", "referencing undefined message " + message);
        }
        for (Message message : definition.getPortTypes().values()) {
            if (!message.isUndefined()) continue;
            throw new WSDLException("INVALID_WSDL", "referencing undefined portType " + message);
        }
        for (Message message : definition.getBindings().values()) {
            if (!message.isUndefined()) continue;
            throw new WSDLException("INVALID_WSDL", "referencing undefined binding " + message);
        }
    }

    public Definition getDefinition() {
        Trc.entry(this);
        Trc.exit(this.def);
        return this.def;
    }

    public WSIFMessage getContext() throws WSIFException {
        WSIFMessage wSIFMessage;
        Trc.entry(this);
        if (this.context == null) {
            wSIFMessage = new WSIFDefaultMessage();
        } else {
            try {
                wSIFMessage = (WSIFMessage)this.context.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new WSIFException("CloneNotSupportedException cloning context", cloneNotSupportedException);
            }
        }
        Trc.exit(wSIFMessage);
        return wSIFMessage;
    }

    public void setContext(WSIFMessage wSIFMessage) {
        Trc.entry((Object)this, wSIFMessage);
        if (wSIFMessage == null) {
            throw new IllegalArgumentException("context must not be null");
        }
        this.context = wSIFMessage;
        Trc.exit();
    }

    protected void overrideMapper(String string) throws WSIFException {
        this.mapper = string != null ? WSIFMapperFactory.newMapper(string) : WSIFMapperFactory.newMapper();
    }

    protected void overrideMappingConvention(String string) throws WSIFException {
        this.mapCon = string != null ? WSIFMappingConventionFactory.newMappingConvention(string) : WSIFMappingConventionFactory.newMappingConvention();
        this.mapper.setMappingConvention(this.mapCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateSchemaTypes(WSDLLocator wSDLLocator) throws WSIFException {
        ArrayList arrayList = this.schemaTypes;
        synchronized (arrayList) {
            if (this.schemaTypesInitialised) {
                return;
            }
            if (wSDLLocator == null) {
                wSDLLocator = new WSIFWSDLLocatorImpl((String)null, (String)null, (ClassLoader)null);
            }
            Parser.getAllSchemaTypes(this.def, this.schemaTypes, wSDLLocator);
            if (wSDLLocator instanceof ClosableLocator) {
                try {
                    ((ClosableLocator)wSDLLocator).close();
                }
                catch (IOException iOException) {
                    Trc.ignoredException(iOException);
                }
            }
            WSIFMessage wSIFMessage = this.getContext();
            wSIFMessage.setObjectPart("org.apache.wsif.schematypes", Collections.unmodifiableList(this.schemaTypes));
            this.setContext(wSIFMessage);
            this.schemaTypesInitialised = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupTypeMappings() throws WSIFException {
        ArrayList arrayList = this.schemaTypes;
        synchronized (arrayList) {
            if (this.typeMapInitialised) {
                return;
            }
            if (this.mapper == null) {
                Trc.event(this, "Automatic mapping of types did not take place because mapper was null");
                return;
            }
            SchemaType[] schemaTypeArray = new SchemaType[this.schemaTypes.size()];
            this.schemaTypes.toArray(schemaTypeArray);
            Map map = this.mapper.getMappings(schemaTypeArray);
            if (map != null) {
                for (QName qName : map.keySet()) {
                    String string = (String)map.get(qName);
                    if (string == null) continue;
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Trc.ignoredException(classNotFoundException);
                    }
                    if (clazz == null) continue;
                    this.mapType(qName, clazz, false);
                }
            }
            this.typeMapInitialised = true;
        }
    }

    private boolean autoMapTypesOn() {
        if (this.features == null) {
            return false;
        }
        Object v = this.features.get("org.apache.wsif.automaptypes");
        if (v != null && v instanceof Boolean) {
            return (Boolean)v != false;
        }
        return false;
    }

    private PasswordAuthentication getProxyAuthentication() {
        Object v;
        if (this.features != null && (v = this.features.get("org.apache.wsif.proxyauthentication")) != null && v instanceof PasswordAuthentication) {
            return (PasswordAuthentication)v;
        }
        return null;
    }

    public String deep() {
        String string = "";
        try {
            string = new String(this.toString());
            string = string + "\nprovidersExtRegs:" + (providersExtRegs == null ? "null" : ((Object)((Object)providersExtRegs)).toString());
            string = string + "\ndef:" + Trc.brief(this.def);
            string = string + "\nservice:" + Trc.brief(this.service);
            string = string + "\nportType:" + Trc.brief(this.portType);
            string = string + "\navailablePorts:" + Trc.brief(this.availablePorts);
            string = string + "\ntypeMap:" + (this.typeMap == null ? "null" : this.typeMap.toString());
            string = string + "\ntypeMapInitialised:" + this.typeMapInitialised;
            string = string + "\npreferredPort:" + (this.preferredPort == null ? "null" : this.preferredPort);
            string = string + "\nchosenPort:" + Trc.brief(this.chosenPort);
            string = string + "\ncontext:" + this.context;
        }
        catch (Exception exception) {
            Trc.exceptionInTrace(exception);
        }
        return string;
    }
}

